/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.connectors.config.GroupMap;
import org.glassfish.connectors.config.PrincipalMap;
import org.glassfish.connectors.config.WorkSecurityMap;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.api.ResourceAttributes;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="work-security-map")
@I18n(value="add.resources")
public class ConnectorWorkSecurityMapResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(ConnectorWorkSecurityMapResourceManager.class);
    private String raName;
    private Properties principalsMap;
    private Properties groupsMap;
    private String mapName;

    @Override
    public String getResourceType() {
        return "work-security-map";
    }

    @Override
    public ResourceStatus create(Resources resources, ResourceAttributes attributes, final Properties properties, String target) throws Exception {
        this.setAttributes(attributes);
        ResourceStatus validationStatus = this.isValid(resources);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    return ConnectorWorkSecurityMapResourceManager.this.createResource(param, properties);
                }
            }, resources);
        }
        catch (TransactionFailure tfe) {
            String msg = I18N.getLocalString("create.connector.work.security.map.fail", "Unable to create connector work security map {0}.", this.mapName) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg, true);
        }
        String msg = I18N.getLocalString("create.work.security.map.success", "Work security map {0} created.", this.mapName);
        return new ResourceStatus(0, msg, true);
    }

    private ResourceStatus isValid(Resources resources) {
        ResourceStatus status = new ResourceStatus(0, "Validation Successful");
        if (this.mapName == null) {
            String msg = I18N.getLocalString("create.connector.work.security.map.noMapName", "No mapname defined for connector work security map.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.raName == null) {
            String msg = I18N.getLocalString("create.connector.work.security.map.noRaName", "No raname defined for connector work security map.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.principalsMap == null && this.groupsMap == null) {
            String msg = I18N.getLocalString("create.connector.work.security.map.noMap", "No principalsmap or groupsmap defined for connector work security map.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.principalsMap != null && this.groupsMap != null) {
            String msg = I18N.getLocalString("create.connector.work.security.map.specifyPrincipalsOrGroupsMap", "A work-security-map can have either (any number of) group mapping  or (any number of) principals mapping but not both. Specify--principalsmap or --groupsmap.");
            return new ResourceStatus(1, msg, true);
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof WorkSecurityMap) || !((WorkSecurityMap)resource).getName().equals(this.mapName) || !((WorkSecurityMap)resource).getResourceAdapterName().equals(this.raName)) continue;
            String msg = I18N.getLocalString("create.connector.work.security.map.duplicate", "A connector work security map named {0} for resource adapter {1} already exists.", this.mapName, this.raName);
            return new ResourceStatus(1, msg, true);
        }
        return status;
    }

    private WorkSecurityMap createConfigBean(Resources param) throws PropertyVetoException, TransactionFailure {
        WorkSecurityMap workSecurityMap;
        block3: {
            block2: {
                workSecurityMap = param.createChild(WorkSecurityMap.class);
                workSecurityMap.setName(this.mapName);
                workSecurityMap.setResourceAdapterName(this.raName);
                if (this.principalsMap == null) break block2;
                for (Map.Entry<Object, Object> e : this.principalsMap.entrySet()) {
                    PrincipalMap principalMap = workSecurityMap.createChild(PrincipalMap.class);
                    principalMap.setEisPrincipal((String)e.getKey());
                    principalMap.setMappedPrincipal((String)e.getValue());
                    workSecurityMap.getPrincipalMap().add(principalMap);
                }
                break block3;
            }
            if (this.groupsMap == null) break block3;
            for (Map.Entry<Object, Object> e : this.groupsMap.entrySet()) {
                GroupMap groupMap = workSecurityMap.createChild(GroupMap.class);
                groupMap.setEisGroup((String)e.getKey());
                groupMap.setMappedGroup((String)e.getValue());
                workSecurityMap.getGroupMap().add(groupMap);
            }
        }
        return workSecurityMap;
    }

    private WorkSecurityMap createResource(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        WorkSecurityMap newResource = this.createConfigBean(param);
        param.getResources().add(newResource);
        return newResource;
    }

    private void setAttributes(ResourceAttributes attrList) {
        this.raName = attrList.getString("resource-adapter-name");
        this.mapName = attrList.getString("name");
        this.principalsMap = attrList.getProperties("principal-map");
        this.groupsMap = attrList.getProperties("group-map");
    }

    @Override
    public Resource createConfigBean(Resources resources, ResourceAttributes attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes);
        ResourceStatus status = validate ? this.isValid(resources) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources);
        }
        throw new ResourceException(status.getMessage(), status.getException());
    }
}

