/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.api.ResourceAttributes;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="connector-resource")
@PerLookup
@I18n(value="create.connector.resource")
public class ConnectorResourceManager
implements ResourceManager {
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(ConnectorResourceManager.class);
    private String poolName;
    private String enabled = Boolean.TRUE.toString();
    private String enabledValueForTarget = Boolean.TRUE.toString();
    private String jndiName;
    private String description;
    private String objectType = "user";
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private BindableResourcesHelper resourcesHelper;

    @Override
    public String getResourceType() {
        return "connector-resource";
    }

    @Override
    public ResourceStatus create(Resources resources, ResourceAttributes attributes, Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            SingleConfigCode<Resources> configCode = param -> this.createResource((Resources)param, properties);
            ConfigSupport.apply(configCode, resources);
            if (!"domain".equals(target)) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = I18N.getLocalString("create.connector.resource.fail", "Connector resource {0} create failed ", this.jndiName) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg);
        }
        String msg = I18N.getLocalString("create.connector.resource.success", "Connector resource {0} created successfully", this.jndiName);
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.jndiName == null) {
            String msg = I18N.getLocalString("create.connector.resource.noJndiName", "No JNDI name defined for connector resource.");
            return new ResourceStatus(1, msg);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, ConnectorResource.class);
        if (status.getStatus() == 1) {
            return status;
        }
        if (!this.isConnPoolExists(resources)) {
            String msg = I18N.getLocalString("create.connector.resource.connPoolNotFound", "Attribute value (pool-name = {0}) is not found in list of connector connection pools.", this.poolName);
            return new ResourceStatus(1, msg);
        }
        return status;
    }

    private ConnectorResource createResource(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        ConnectorResource newResource = this.createConfigBean(param, props);
        param.getResources().add(newResource);
        return newResource;
    }

    private ConnectorResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ConnectorResource newResource = param.createChild(ConnectorResource.class);
        newResource.setJndiName(this.jndiName);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        newResource.setPoolName(this.poolName);
        newResource.setEnabled(this.enabled);
        newResource.setObjectType(this.objectType);
        if (properties != null) {
            for (String propertyName : properties.stringPropertyNames()) {
                Property prop = newResource.createChild(Property.class);
                prop.setName(propertyName);
                prop.setValue(properties.getProperty(propertyName));
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    private void setAttributes(ResourceAttributes attributes, String target) {
        this.poolName = attributes.getString("pool-name");
        this.enabled = target == null ? attributes.getString("enabled") : this.resourceUtil.computeEnabledValueForResourceBasedOnTarget(attributes.getString("enabled"), target);
        this.enabledValueForTarget = attributes.getString("enabled");
        this.jndiName = attributes.getString("jndi-name");
        this.description = attributes.getString(DESCRIPTION);
        this.objectType = attributes.getString("object-type");
    }

    private boolean isConnPoolExists(Resources resources) {
        SimpleJndiName jndiPoolName = new SimpleJndiName(this.poolName);
        return resources.getResourceByName(ConnectorConnectionPool.class, jndiPoolName) != null;
    }

    @Override
    public Resource createConfigBean(Resources resources, ResourceAttributes attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = validate ? this.isValid(resources, false, null) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage(), status.getException());
    }
}

