/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.api.ResourceAttributes;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="admin-object-resource")
@PerLookup
@I18n(value="create.admin.object")
public class AdminObjectManager
implements ResourceManager {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(AdminObjectManager.class);
    @Inject
    private Applications applications;
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private BindableResourcesHelper resourcesHelper;
    @Inject
    private ServerEnvironment environment;
    private String resType;
    private String className;
    private String raName;
    private String enabled = Boolean.TRUE.toString();
    private String enabledValueForTarget = Boolean.TRUE.toString();
    private String jndiName;
    private String description;

    @Override
    public String getResourceType() {
        return "admin-object-resource";
    }

    @Override
    public ResourceStatus create(Resources resources, ResourceAttributes attributes, Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            SingleConfigCode<Resources> configCode = param -> this.createResource((Resources)param, properties);
            ConfigSupport.apply(configCode, resources);
            if (!"domain".equals(target)) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(AdminObjectManager.class.getName()).log(Level.SEVERE, "Unabled to create administered object", tfe);
            String msg = I18N.getLocalString("create.admin.object.fail", "Unable to create administered object {0}.", this.jndiName) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg);
        }
        String msg = I18N.getLocalString("create.admin.object.success", "Administered object {0} created.", this.jndiName);
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.jndiName == null) {
            String msg = I18N.getLocalString("create.admin.object.noJndiName", "No JNDI name defined for administered object.");
            return new ResourceStatus(1, msg);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, AdminObjectResource.class);
        if (status.getStatus() == 1) {
            return status;
        }
        if (this.environment.isDas()) {
            status = this.isValidRAName();
            if (status.getStatus() == 1) {
                return status;
            }
            status = this.isValidAdminObject();
            if (status.getStatus() == 1) {
                return status;
            }
        }
        return status;
    }

    private AdminObjectResource createResource(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        AdminObjectResource newResource = this.createConfigBean(param, props);
        param.getResources().add(newResource);
        return newResource;
    }

    private AdminObjectResource createConfigBean(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        AdminObjectResource newResource = param.createChild(AdminObjectResource.class);
        newResource.setJndiName(this.jndiName);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        newResource.setResAdapter(this.raName);
        newResource.setResType(this.resType);
        newResource.setClassName(this.className);
        newResource.setEnabled(this.enabled);
        if (props != null) {
            for (String propertyName : props.stringPropertyNames()) {
                Property prop = newResource.createChild(Property.class);
                prop.setName(propertyName);
                prop.setValue(props.getProperty(propertyName));
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    private void setAttributes(ResourceAttributes attributes, String target) {
        this.resType = attributes.getString("res-type");
        this.className = attributes.getString("class-name");
        this.enabled = target == null ? attributes.getString("enabled") : this.resourceUtil.computeEnabledValueForResourceBasedOnTarget(attributes.getString("enabled"), target);
        this.enabledValueForTarget = attributes.getString("enabled");
        this.jndiName = attributes.getString("jndi-name");
        this.description = attributes.getString("description");
        this.raName = attributes.getString("res-adapter");
    }

    private ResourceStatus isValidAdminObject() {
        boolean isValidAdminObject = false;
        if (this.className == null) {
            String[] resTypes;
            try {
                resTypes = this.connectorRuntime.getAdminObjectInterfaceNames(this.raName);
            }
            catch (ConnectorRuntimeException cre) {
                Logger.getLogger(AdminObjectManager.class.getName()).log(Level.SEVERE, "Could not find admin-ojbect-interface names (resTypes) from ConnectorRuntime for resource adapter.", cre);
                String string = I18N.getLocalString("admin.mbeans.rmb.null_ao_intf", "Resource Adapter {0} does not contain any resource type for admin-object. Please specify another res-adapter.", this.raName) + " " + cre.getLocalizedMessage();
                return new ResourceStatus(1, string);
            }
            if (resTypes == null || resTypes.length <= 0) {
                String msg = I18N.getLocalString("admin.mbeans.rmb.null_ao_intf", "Resource Adapter {0} does not contain any resource type for admin-object. Please specify another res-adapter.", this.raName);
                return new ResourceStatus(1, msg);
            }
            int count = 0;
            for (String resType2 : resTypes) {
                if (!resType2.equals(this.resType)) continue;
                isValidAdminObject = true;
                ++count;
            }
            if (count > 1) {
                String string = I18N.getLocalString("admin.mbeans.rmb.multiple_admin_objects.found.for.restype", "Need to specify admin-object classname parameter (--classname) as multiple admin objects use this resType [ {0} ]", this.resType);
                return new ResourceStatus(1, string);
            }
        } else {
            try {
                isValidAdminObject = this.connectorRuntime.hasAdminObject(this.raName, this.resType, this.className);
            }
            catch (ConnectorRuntimeException cre) {
                Logger.getLogger(AdminObjectManager.class.getName()).log(Level.SEVERE, "Could not find admin-object-interface names (resTypes) and admin-object-classnames from ConnectorRuntime for resource adapter.", cre);
                String msg = I18N.getLocalString("admin.mbeans.rmb.ao_intf_impl_check_failed", "Could not determine admin object resource information of Resource Adapter [ {0} ] for resType [ {1} ] and classname [ {2} ] ", this.raName, this.resType, this.className) + " " + cre.getLocalizedMessage();
                return new ResourceStatus(1, msg);
            }
        }
        if (!isValidAdminObject) {
            String msg = I18N.getLocalString("admin.mbeans.rmb.invalid_res_type", "Invalid Resource Type: {0}", this.resType);
            return new ResourceStatus(1, msg);
        }
        return new ResourceStatus(0, "");
    }

    private ResourceStatus isValidRAName() {
        ResourceStatus status = new ResourceStatus(0, "");
        if (this.raName == null || this.raName.isEmpty()) {
            String msg = I18N.getLocalString("admin.mbeans.rmb.null_res_adapter", "Resource Adapter Name is null.");
            status = new ResourceStatus(1, msg);
        } else if (!ConnectorsUtil.getNonJdbcSystemRars().contains(this.raName)) {
            int indx = this.raName.indexOf("#");
            if (indx != -1) {
                String appName = this.raName.substring(0, indx);
                Application app = this.applications.getModule(Application.class, appName);
                if (app == null) {
                    String msg = I18N.getLocalString("admin.mbeans.rmb.invalid_ra_app_not_found", "Invalid raname. Application with name {0} not found.", appName);
                    status = new ResourceStatus(1, msg);
                }
            } else {
                Application app = this.applications.getModule(Application.class, this.raName);
                if (app == null) {
                    String msg = I18N.getLocalString("admin.mbeans.rmb.invalid_ra_cm_not_found", "Invalid raname. Connector Module with name {0} not found.", this.raName);
                    status = new ResourceStatus(1, msg);
                }
            }
        }
        return status;
    }

    @Override
    public Resource createConfigBean(Resources resources, ResourceAttributes attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = validate ? this.isValid(resources, false, null) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage(), status.getException());
    }
}

