/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support.datatypes;

import org.glassfish.config.support.datatypes.NonNegativeInteger;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.DataType;
import org.jvnet.hk2.config.ValidationException;

@Service
public final class Port
implements DataType {
    @Override
    public void validate(String value) throws ValidationException {
        if (value == null) {
            throw new ValidationException("null value is not of type Port");
        }
        if (NonNegativeInteger.isTokenized(value)) {
            return;
        }
        try {
            int port = Integer.parseInt(value);
            if (port < 0 || port > 65535) {
                String msg = "value: " + port + " not applicable for Port [0, 65535] data type";
                throw new ValidationException(msg);
            }
        }
        catch (NumberFormatException e) {
            String msg = value + " does not represent an Integer";
            throw new ValidationException(msg);
        }
    }
}

