/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.cdi.lock;

import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.concurro.cdi.Lock;

@Interceptor
@Lock
@Priority(value=0)
public class LockInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object doLock(InvocationContext ctx) throws Exception {
        Lock lockAnnotation = ctx.getInterceptorBinding(Lock.class);
        java.util.concurrent.locks.Lock lock = this.getReadOrWriteLock(lockAnnotation);
        this.acquireLock(lockAnnotation, lock);
        try {
            Object object = ctx.proceed();
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    private java.util.concurrent.locks.Lock getReadOrWriteLock(Lock lockAnnotation) {
        return lockAnnotation.type() == Lock.Type.READ ? this.readWriteLock.readLock() : this.readWriteLock.writeLock();
    }

    private void acquireLock(Lock lockAnnotation, java.util.concurrent.locks.Lock lock) throws InterruptedException {
        switch (lockAnnotation.timeoutType()) {
            case TIMEOUT: {
                if (lock.tryLock(lockAnnotation.accessTimeout(), lockAnnotation.unit())) break;
                throw new IllegalStateException("Could not obtain lock in " + lockAnnotation.accessTimeout() + " " + lockAnnotation.unit().name());
            }
            case INDEFINITTE: {
                lock.lock();
                break;
            }
            case NOT_PERMITTED: {
                if (lock.tryLock()) break;
                throw new IllegalStateException("Lock already locked, and no wait allowed");
            }
        }
    }
}

