/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro;

import jakarta.enterprise.concurrent.ManagedExecutorService;
import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.glassfish.concurro.AbstractManagedExecutorService;
import org.glassfish.concurro.AbstractPlatformThreadExecutorService;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.ManagedExecutorServiceAdapter;
import org.glassfish.concurro.ManagedThreadFactoryImpl;
import org.glassfish.concurro.internal.ManagedFutureTask;
import org.glassfish.concurro.internal.ManagedThreadPoolExecutor;

public class ManagedExecutorServiceImpl
extends AbstractPlatformThreadExecutorService {
    protected final ManagedThreadPoolExecutor threadPoolExecutor;
    protected final ManagedExecutorServiceAdapter adapter;

    public ManagedExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy, BlockingQueue<Runnable> queue) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, contextService, contextService != null ? contextService.getContextSetupProvider() : null, rejectPolicy);
        this.threadPoolExecutor = new ManagedThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, keepAliveTimeUnit, queue, this.managedThreadFactory);
        this.threadPoolExecutor.setThreadLifeTime(threadLifeTime);
        this.adapter = new ManagedExecutorServiceAdapter(this);
    }

    public ManagedExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, int queueCapacity, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, contextService, contextService != null ? contextService.getContextSetupProvider() : null, rejectPolicy);
        if (queueCapacity < 0) {
            throw new IllegalArgumentException();
        }
        AbstractQueue queue = queueCapacity == Integer.MAX_VALUE ? (corePoolSize == 0 ? new SynchronousQueue() : new LinkedBlockingQueue()) : (queueCapacity == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueCapacity));
        this.threadPoolExecutor = new ManagedThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, keepAliveTimeUnit, (BlockingQueue<Runnable>)((Object)queue), this.managedThreadFactory);
        this.threadPoolExecutor.setThreadLifeTime(threadLifeTime);
        this.adapter = new ManagedExecutorServiceAdapter(this);
    }

    @Override
    public void execute(Runnable command) {
        ManagedFutureTask<Object> task = this.getNewTaskFor(command, null);
        task.submitted();
        this.threadPoolExecutor.execute(task);
    }

    @Override
    public ManagedExecutorServiceAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    protected ExecutorService getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    @Override
    public ManagedExecutorService getExecutorForTaskListener() {
        return this.adapter;
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Runnable r, V result) {
        return new ManagedFutureTask<V>(this, r, result);
    }

    protected ManagedFutureTask getNewTaskFor(Callable callable) {
        return new ManagedFutureTask(this, callable);
    }

    @Override
    public long getTaskCount() {
        return this.threadPoolExecutor.getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.threadPoolExecutor.getCompletedTaskCount();
    }
}

