/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro;

import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.concurro.AbstractManagedExecutorService;
import org.glassfish.concurro.AbstractPlatformThreadExecutorService;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.ManagedExecutorServiceAdapter;
import org.glassfish.concurro.ManagedThreadFactoryImpl;
import org.glassfish.concurro.internal.ManagedFutureTask;
import org.glassfish.concurro.internal.MultiManagedTaskListener;

public class ForkJoinManagedExecutorService
extends AbstractPlatformThreadExecutorService
implements ManagedTaskListener {
    protected final ManagedExecutorServiceAdapter adapter;
    protected final ForkJoinPool pool;
    private final Map<ManagedFutureTask<?>, Runnable> runningFutures = new ConcurrentHashMap();
    private final AtomicLong taskCount = new AtomicLong();
    private final AtomicLong tasksCompleted = new AtomicLong();

    public ForkJoinManagedExecutorService(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, int queueCapacity, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        this(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, maxPoolSize, keepAliveTime, keepAliveTimeUnit, contextService, rejectPolicy);
    }

    public ForkJoinManagedExecutorService(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, contextService, contextService != null ? contextService.getContextSetupProvider() : null, rejectPolicy);
        this.pool = new ForkJoinPool(maxPoolSize, this.managedThreadFactory, null, false, 0, maxPoolSize, 1, null, keepAliveTime, TimeUnit.SECONDS);
        this.adapter = new ManagedExecutorServiceAdapter(this);
    }

    @Override
    public void execute(Runnable command) {
        ManagedFutureTask<Object> task = this.getNewTaskFor(command, null);
        task.submitted();
        this.runningFutures.put(task, command);
        this.pool.execute(task);
    }

    @Override
    public ManagedExecutorServiceAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public ManagedExecutorService getExecutorForTaskListener() {
        return this.adapter;
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Runnable r, V result) {
        StatefulRunnable statefulRunnable = new StatefulRunnable(r);
        Runnable notifiedRunnable = ManagedExecutors.managedTask(statefulRunnable, r instanceof ManagedTask ? ((ManagedTask)((Object)r)).getExecutionProperties() : null, (ManagedTaskListener)new MultiManagedTaskListener(this, r instanceof ManagedTask ? ((ManagedTask)((Object)r)).getManagedTaskListener() : null));
        ManagedFutureTask<V> managedFutureTask = new ManagedFutureTask<V>(this, notifiedRunnable, result);
        statefulRunnable.setTask(managedFutureTask);
        this.runningFutures.put(managedFutureTask, notifiedRunnable);
        return managedFutureTask;
    }

    protected <T> ManagedFutureTask<T> getNewTaskFor(Callable<T> callable) {
        return new ManagedFutureTask<T>(this, callable);
    }

    @Override
    public List<Runnable> shutdownNow() {
        super.shutdownNow();
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.runningFutures.values());
        ArrayList copyOfRunningFutures = new ArrayList(this.runningFutures.keySet());
        copyOfRunningFutures.stream().forEach(future -> future.cancel(false));
        return Collections.unmodifiableList(runnables);
    }

    @Override
    public long getTaskCount() {
        return this.taskCount.get();
    }

    @Override
    public ManagedThreadFactoryImpl getManagedThreadFactory() {
        return this.managedThreadFactory;
    }

    @Override
    protected ExecutorService getThreadPoolExecutor() {
        return this.pool;
    }

    @Override
    protected boolean isTaskHung(Thread thread, long now) {
        ManagedThreadFactoryImpl.WorkerThread managedThread = (ManagedThreadFactoryImpl.WorkerThread)thread;
        return managedThread.isTaskHung(now);
    }

    @Override
    public long getCompletedTaskCount() {
        return this.tasksCompleted.get();
    }

    @Override
    public void taskSubmitted(Future<?> future, ManagedExecutorService executor, Object task) {
        this.taskCount.incrementAndGet();
    }

    @Override
    public void taskAborted(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
        this.runningFutures.remove(future);
        this.taskCount.decrementAndGet();
    }

    @Override
    public void taskDone(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
        this.runningFutures.remove(future);
        this.tasksCompleted.incrementAndGet();
    }

    @Override
    public void taskStarting(Future<?> future, ManagedExecutorService executor, Object task) {
    }

    public class StatefulRunnable
    implements Runnable {
        private final Runnable runnable;
        private ManagedFutureTask<?> task;

        public StatefulRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            ManagedThreadFactoryImpl.WorkerThread workerThread;
            Thread thread = Thread.currentThread();
            if (thread instanceof ManagedThreadFactoryImpl.WorkerThread) {
                workerThread = (ManagedThreadFactoryImpl.WorkerThread)thread;
                workerThread.notifyTaskStarting(this.task);
            }
            this.task.starting(thread);
            this.runnable.run();
            ForkJoinManagedExecutorService.this.taskDone(this.task, ForkJoinManagedExecutorService.this.adapter, this.runnable, null);
            if (thread instanceof ManagedThreadFactoryImpl.WorkerThread) {
                workerThread = (ManagedThreadFactoryImpl.WorkerThread)thread;
                workerThread.notifyTaskDone();
            }
        }

        public void setTask(ManagedFutureTask<?> task) {
            this.task = task;
        }
    }
}

