/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro;

import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.glassfish.concurro.AbstractManagedExecutorService;
import org.glassfish.concurro.ManagedExecutorServiceImpl;
import org.glassfish.concurro.internal.ContextProxyInvocationHandler;
import org.glassfish.concurro.internal.ManagedCompletableFuture;
import org.glassfish.concurro.spi.ContextSetupProvider;
import org.glassfish.concurro.spi.TransactionSetupProvider;

public class ContextServiceImpl
implements ContextService,
Serializable {
    static final long serialVersionUID = -386695836029966433L;
    protected final ContextSetupProvider contextSetupProvider;
    protected final TransactionSetupProvider transactionSetupProvider;
    protected final String name;
    private static final String INVALID_PROXY = "contextObject is not a valid contextual object proxy created with the createContextualProxy method";
    private static final String NULL_INSTANCE = "instance cannot be null";
    private static final String NO_INTERFACES = "No interfaces is provided in the method argument";
    private static final String CLASS_DOES_NOT_IMPLEMENT_INTERFACES = "Class does not implement at least one of the provided interfaces";
    private static final String DIFFERENT_CONTEXTSERVICE = "Proxy is created by a different ContextService object";

    public ContextServiceImpl(String name, ContextSetupProvider contextSetupProvider) {
        this(name, contextSetupProvider, null);
    }

    public ContextServiceImpl(String name, ContextSetupProvider contextSetupProvider, TransactionSetupProvider transactionSetupProvider) {
        this.name = name;
        this.contextSetupProvider = contextSetupProvider;
        this.transactionSetupProvider = transactionSetupProvider;
    }

    public String getName() {
        return this.name;
    }

    public ContextSetupProvider getContextSetupProvider() {
        return this.contextSetupProvider;
    }

    public TransactionSetupProvider getTransactionSetupProvider() {
        return this.transactionSetupProvider;
    }

    @Override
    public Object createContextualProxy(Object instance, Class<?> ... interfaces) {
        return this.createContextualProxy(instance, (Map<String, String>)null, interfaces);
    }

    @Override
    public Object createContextualProxy(Object instance, Map<String, String> executionProperties, Class<?> ... interfaces) {
        if (instance == null) {
            throw new IllegalArgumentException(NULL_INSTANCE);
        }
        if (interfaces == null || interfaces.length == 0) {
            throw new IllegalArgumentException(NO_INTERFACES);
        }
        Class<?> instanceClass = instance.getClass();
        for (Class<?> thisInterface : interfaces) {
            if (thisInterface.isAssignableFrom(instanceClass)) continue;
            throw new IllegalArgumentException(CLASS_DOES_NOT_IMPLEMENT_INTERFACES);
        }
        ContextProxyInvocationHandler handler = new ContextProxyInvocationHandler(this, instance, executionProperties);
        Object proxy = Proxy.newProxyInstance(instance.getClass().getClassLoader(), interfaces, (InvocationHandler)handler);
        return proxy;
    }

    @Override
    public <T> T createContextualProxy(T instance, Class<T> intf) {
        return this.createContextualProxy(instance, (Map<String, String>)null, intf);
    }

    @Override
    public <T> T createContextualProxy(T instance, Map<String, String> executionProperties, Class<T> intf) {
        if (instance == null) {
            throw new IllegalArgumentException(NULL_INSTANCE);
        }
        if (intf == null) {
            throw new IllegalArgumentException(NO_INTERFACES);
        }
        ContextProxyInvocationHandler handler = new ContextProxyInvocationHandler(this, instance, executionProperties);
        Object proxy = Proxy.newProxyInstance(instance.getClass().getClassLoader(), new Class[]{intf}, (InvocationHandler)handler);
        return (T)proxy;
    }

    @Override
    public Map<String, String> getExecutionProperties(Object contextObject) {
        ContextProxyInvocationHandler handler = this.verifyHandler(contextObject);
        return handler.getExecutionProperties();
    }

    protected void verifyStringValue(Enumeration e) throws ClassCastException {
        while (e.hasMoreElements()) {
            String string = (String)e.nextElement();
        }
    }

    protected ContextProxyInvocationHandler verifyHandler(Object contextObject) {
        InvocationHandler handler = Proxy.getInvocationHandler(contextObject);
        if (handler instanceof ContextProxyInvocationHandler) {
            ContextProxyInvocationHandler cpih = (ContextProxyInvocationHandler)handler;
            if (cpih.getContextService() != this) {
                throw new IllegalArgumentException(DIFFERENT_CONTEXTSERVICE);
            }
            return cpih;
        }
        throw new IllegalArgumentException(INVALID_PROXY);
    }

    @Override
    public <R> Callable<R> contextualCallable(Callable<R> clbl) {
        return this.createContextualProxy((T)clbl, (Map<String, String>)null, (Class<T>)Callable.class);
    }

    @Override
    public <T, U> BiConsumer<T, U> contextualConsumer(BiConsumer<T, U> bc) {
        return this.createContextualProxy((T)bc, (Map<String, String>)null, (Class<T>)BiConsumer.class);
    }

    @Override
    public <T> Consumer<T> contextualConsumer(Consumer<T> cnsmr) {
        return this.createContextualProxy((T)cnsmr, (Map<String, String>)null, (Class<T>)Consumer.class);
    }

    @Override
    public <T, U, R> BiFunction<T, U, R> contextualFunction(BiFunction<T, U, R> bf) {
        return this.createContextualProxy((T)bf, (Map<String, String>)null, (Class<T>)BiFunction.class);
    }

    @Override
    public <T, R> Function<T, R> contextualFunction(Function<T, R> fnctn) {
        return this.createContextualProxy((T)fnctn, (Map<String, String>)null, (Class<T>)Function.class);
    }

    @Override
    public Runnable contextualRunnable(Runnable r) {
        return this.createContextualProxy((T)r, (Map<String, String>)null, (Class<T>)Runnable.class);
    }

    @Override
    public <R> Supplier<R> contextualSupplier(Supplier<R> splr) {
        return this.createContextualProxy((T)splr, (Map<String, String>)null, (Class<T>)Supplier.class);
    }

    @Override
    public Executor currentContextExecutor() {
        Executor executor = new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
        return this.createContextualProxy((T)executor, (Map<String, String>)null, (Class<T>)Executor.class);
    }

    @Override
    public <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> cf) {
        CompletableFuture<T> cs = cf;
        return (CompletableFuture)this.withContextCapture((CompletionStage<T>)cs);
    }

    @Override
    public <T> CompletionStage<T> withContextCapture(CompletionStage<T> cs) {
        Executor executor = this.getDefaultManageExecutorService();
        ManagedCompletableFuture newCompletableFuture = new ManagedCompletableFuture((ManagedExecutorService)executor);
        cs.whenComplete((result, failure) -> {
            if (failure == null) {
                newCompletableFuture.complete(result);
            } else {
                newCompletableFuture.completeExceptionally((Throwable)failure);
            }
        });
        return newCompletableFuture;
    }

    private Executor getDefaultManageExecutorService() {
        return new ManagedExecutorServiceImpl(this.name, null, 0L, false, 1, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, 0L, Integer.MAX_VALUE, this, AbstractManagedExecutorService.RejectPolicy.ABORT);
    }

    @Override
    public <T> Flow.Subscriber<T> contextualSubscriber(Flow.Subscriber<T> subscriber) {
        return this.createContextualProxy((T)subscriber, (Map<String, String>)null, (Class<T>)Flow.Subscriber.class);
    }

    @Override
    public <T, R> Flow.Processor<T, R> contextualProcessor(Flow.Processor<T, R> processor) {
        return this.createContextualProxy((T)processor, (Map<String, String>)null, (Class<T>)Flow.Processor.class);
    }
}

