/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManPageFinder {
    private static final String[] sections = new String[]{"1", "1m", "2", "2m", "3", "3m", "4", "4m", "5", "5m", "6", "6m", "7", "7m", "8", "8m", "9", "9m", "5asc"};

    private ManPageFinder() {
    }

    public static BufferedReader getCommandManPage(String cmdName, String cmdClass, Locale locale, ClassLoader classLoader, Logger logger2) {
        InputStream s = null;
        Iterator it = ManPageFinder.getPossibleLocations(cmdName, cmdClass, locale, logger2);
        while (s == null && it.hasNext()) {
            s = classLoader.getResourceAsStream((String)it.next());
        }
        if (s == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(s, StandardCharsets.UTF_8));
    }

    private static Iterator getPossibleLocations(final String cmdName, final String cmdClass, final Locale locale, final Logger logger2) {
        return new Iterator(){
            final String[] locales;
            private int i;
            private int j;
            private final String helpdir;
            private final String commandName;
            {
                this.locales = ManPageFinder.getLocaleLocations(locale);
                this.i = 0;
                this.j = 0;
                this.helpdir = ManPageFinder.getHelpDir(cmdClass);
                this.commandName = cmdName;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.locales.length && this.j < sections.length;
            }

            public Object next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String result = this.helpdir + this.locales[this.i] + "/" + this.commandName + "." + sections[this.j++];
                if (this.j == sections.length) {
                    ++this.i;
                    if (this.i < this.locales.length) {
                        this.j = 0;
                    }
                }
                logger2.log(Level.FINER, "Trying to get this manpage: {0}", result);
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static String getHelpDir(String cmdClass) {
        String pkgname = cmdClass.substring(0, cmdClass.lastIndexOf(46));
        return pkgname.replace('.', '/');
    }

    private static String[] getLocaleLocations(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        ArrayList<Object> l = new ArrayList<Object>();
        l.add("");
        if (language != null && language.length() > 0) {
            l.add("/" + language);
            if (country != null && country.length() > 0) {
                l.add("/" + language + "_" + country);
                if (variant != null && variant.length() > 0) {
                    l.add("/" + language + "_" + country + "_" + variant);
                }
            }
        }
        Collections.reverse(l);
        return l.toArray(new String[l.size()]);
    }
}

