/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import com.sun.enterprise.util.FelixPrettyPrinter;
import jakarta.inject.Singleton;
import java.util.HashSet;
import org.glassfish.hk2.api.ErrorInformation;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.MultiException;
import org.jvnet.hk2.annotations.Service;
import org.osgi.framework.BundleException;

@Service
@Singleton
public class GlassFishErrorServiceImpl
implements ErrorService {
    @Override
    public void onFailure(ErrorInformation errorInformation) throws MultiException {
        if (errorInformation.getAssociatedException() != null) {
            MultiException multiException = errorInformation.getAssociatedException();
            HashSet<String> bundleMessages = new HashSet<String>();
            HashSet<String> stateMessages = new HashSet<String>();
            for (Throwable throwable : multiException.getErrors()) {
                String bundleText = this.findBundleExceptionText(throwable);
                if (bundleText != null) {
                    bundleMessages.add(bundleText);
                }
                if (!(throwable instanceof IllegalStateException)) continue;
                stateMessages.add(throwable.getMessage());
            }
            for (String stateMessage : stateMessages) {
                bundleMessages.remove(stateMessage);
            }
            for (String bundleMessage : bundleMessages) {
                multiException.addError(new IllegalStateException(bundleMessage));
            }
            throw errorInformation.getAssociatedException();
        }
    }

    String findBundleExceptionText(Throwable throwable) {
        while (throwable != null) {
            boolean isBundleException = false;
            try {
                isBundleException = throwable instanceof BundleException;
            }
            catch (Exception | NoClassDefFoundError throwable2) {
                // empty catch block
            }
            if (isBundleException) {
                BundleException bundleException = (BundleException)throwable;
                return FelixPrettyPrinter.prettyPrintExceptionMessage(bundleException.getMessage());
            }
            throwable = throwable.getCause();
        }
        return null;
    }
}

