/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.enterprise.transaction.TransactionManagerHelper;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.Transactional;
import jakarta.transaction.TransactionalException;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.REQUIRES_NEW)
public class TransactionalInterceptorRequiresNew
extends TransactionalInterceptorBase {
    private static final long serialVersionUID = -3843074402046047130L;
    private static final System.Logger LOG = System.getLogger(TransactionalInterceptorRequiresNew.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        LOG.log(System.Logger.Level.TRACE, "Processing transactional context of type: {0}", new Object[]{Transactional.TxType.REQUIRES_NEW});
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(false);
        try {
            Object result;
            Transaction suspendedTx = this.suspendTransaction();
            this.beginTransaction();
            try {
                result = this.proceed(ctx);
            }
            finally {
                this.finishTransaction();
                this.resumeTx(suspendedTx);
            }
            Object object = result;
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }

    private Transaction suspendTransaction() throws SystemException {
        if (this.getTransactionManager().getTransaction() == null) {
            return null;
        }
        LOG.log(System.Logger.Level.DEBUG, "Managed bean with Transactional annotation and TxType of REQUIRES_NEW called inside a transaction context. Suspending before beginning a transaction...");
        try {
            Transaction suspendedTx = this.getTransactionManager().suspend();
            LOG.log(System.Logger.Level.DEBUG, "Transaction suspended: {0}", suspendedTx);
            return suspendedTx;
        }
        catch (Exception e) {
            throw new TransactionalException("Suspending transaction failed: " + e.getMessage(), e);
        }
    }

    private void beginTransaction() {
        try {
            this.getTransactionManager().begin();
            TransactionManager tm = this.getTransactionManager();
            if (tm instanceof TransactionManagerHelper) {
                ((TransactionManagerHelper)tm).preInvokeTx(true);
            }
        }
        catch (Exception e) {
            throw new TransactionalException("Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during begin: " + e.getMessage(), e);
        }
    }

    private void finishTransaction() {
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm instanceof TransactionManagerHelper) {
                ((TransactionManagerHelper)tm).postInvokeTx(false, true);
            }
            if (this.getTransactionManager().getTransaction().getStatus() == 1) {
                this.getTransactionManager().rollback();
            } else {
                this.getTransactionManager().commit();
            }
        }
        catch (Exception e) {
            throw new TransactionalException("Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during commit: " + e.getMessage(), e);
        }
    }

    private void resumeTx(Transaction suspendedTx) {
        if (suspendedTx == null) {
            return;
        }
        try {
            this.getTransactionManager().resume(suspendedTx);
            LOG.log(System.Logger.Level.DEBUG, "Transaction resumed: {0}", suspendedTx);
        }
        catch (Exception e) {
            throw new TransactionalException("Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during resume: " + e.getMessage(), e);
        }
    }
}

