/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.Transactional;
import jakarta.transaction.TransactionalException;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.NOT_SUPPORTED)
public class TransactionalInterceptorNotSupported
extends TransactionalInterceptorBase {
    private static final long serialVersionUID = 2905721637911698354L;
    private static final System.Logger LOG = System.getLogger(TransactionalInterceptorNotSupported.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        LOG.log(System.Logger.Level.TRACE, "Processing transactional context of type: {0}", new Object[]{Transactional.TxType.NOT_SUPPORTED});
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(true);
        try {
            Transaction suspendedTx = this.suspendTransaction();
            try {
                Object object = this.proceed(ctx);
                this.resumeTransaction(suspendedTx);
                return object;
            }
            catch (Throwable throwable) {
                this.resumeTransaction(suspendedTx);
                throw throwable;
            }
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }

    private Transaction suspendTransaction() throws SystemException {
        if (this.getTransactionManager().getTransaction() == null) {
            return null;
        }
        LOG.log(System.Logger.Level.DEBUG, "Managed bean with Transactional annotation and TxType of NOT_SUPPORTED called inside a transaction context. Suspending transaction...");
        try {
            Transaction suspendedTx = this.getTransactionManager().suspend();
            LOG.log(System.Logger.Level.DEBUG, "Transaction suspended: {0}", suspendedTx);
            return suspendedTx;
        }
        catch (Exception e) {
            throw new TransactionalException("Suspending transaction failed: " + e.getMessage(), e);
        }
    }

    private void resumeTransaction(Transaction suspendedTx) {
        if (suspendedTx == null) {
            return;
        }
        try {
            this.getTransactionManager().resume(suspendedTx);
            LOG.log(System.Logger.Level.DEBUG, "Transaction resumed: {0}", suspendedTx);
        }
        catch (Exception e) {
            throw new TransactionalException("Managed bean with Transactional annotation and TxType of NOT_SUPPORTED encountered exception during resume: " + e.getMessage(), e);
        }
    }
}

