/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.enterprise.transaction.spi.TransactionOperationsManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.logging.annotation.LoggerInfo;

public class TransactionalInterceptorBase
implements Serializable {
    private static final long serialVersionUID = 706603825748958619L;
    @LoggerInfo(subsystem="AS-CDI-JTA", description="CDI-JTA", publish=true)
    private static final String CDI_JTA_LOGGER_SUBSYSTEM_NAME = "org.glassfish.cdi.transaction";
    private static final System.Logger LOG = System.getLogger(TransactionalInterceptorBase.class.getName());
    private static TransactionManager testTransactionManager;
    private static volatile TransactionManager transactionManager;
    private static final TransactionOperationsManager txOperationsManagerTransactionMethodsAllowed;
    private static final TransactionOperationsManager txOperationsManagerTransactionMethodsNotAllowed;
    private transient TransactionOperationsManager preexistingTransactionOperationsManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() {
        if (testTransactionManager != null) {
            return testTransactionManager;
        }
        if (transactionManager == null) {
            try {
                Class<TransactionalInterceptorBase> clazz = TransactionalInterceptorBase.class;
                synchronized (TransactionalInterceptorBase.class) {
                    if (transactionManager == null) {
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:appserver/TransactionManager");
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Unable to obtain TransactionManager for Transactional Interceptor: " + e.getMessage(), e);
            }
        }
        {
            return transactionManager;
        }
    }

    static void setTestTransactionManager(TransactionManager transactionManager) {
        testTransactionManager = transactionManager;
    }

    boolean isLifeCycleMethod(InvocationContext ctx) {
        Method method = ctx.getMethod();
        return method.getAnnotation(PostConstruct.class) != null || method.getAnnotation(PreDestroy.class) != null;
    }

    public Object proceed(InvocationContext ctx) throws Exception {
        Object object;
        Transactional transactionalAnnotation = ctx.getMethod().getAnnotation(Transactional.class);
        Class[] rollbackOn = null;
        Class[] dontRollbackOn = null;
        if (transactionalAnnotation != null) {
            rollbackOn = transactionalAnnotation.rollbackOn();
            dontRollbackOn = transactionalAnnotation.dontRollbackOn();
        } else {
            Class<?> targetClass = ctx.getTarget().getClass();
            transactionalAnnotation = targetClass.getAnnotation(Transactional.class);
            if (transactionalAnnotation != null) {
                rollbackOn = transactionalAnnotation.rollbackOn();
                dontRollbackOn = transactionalAnnotation.dontRollbackOn();
            }
        }
        try {
            object = ctx.proceed();
        }
        catch (RuntimeException runtimeException) {
            LOG.log(System.Logger.Level.ERROR, "Error during transaction processing", (Throwable)runtimeException);
            Class<?> dontRollbackOnClass = this.getClassInArrayClosestToClassOrNull(dontRollbackOn, runtimeException.getClass());
            if (dontRollbackOnClass == null) {
                this.markRollbackIfActiveTransaction();
                throw runtimeException;
            }
            if (dontRollbackOnClass.equals(runtimeException.getClass()) || dontRollbackOnClass.isAssignableFrom(runtimeException.getClass())) {
                throw runtimeException;
            }
            Class<?> rollbackOnClass = this.getClassInArrayClosestToClassOrNull(rollbackOn, runtimeException.getClass());
            if (rollbackOnClass != null) {
                if (rollbackOnClass.isAssignableFrom(dontRollbackOnClass)) {
                    throw runtimeException;
                }
                if (dontRollbackOnClass.isAssignableFrom(rollbackOnClass)) {
                    // empty if block
                }
            }
            this.markRollbackIfActiveTransaction();
            throw runtimeException;
        }
        catch (Exception checkedException) {
            LOG.log(System.Logger.Level.ERROR, "Error during transaction processing", (Throwable)checkedException);
            Class<?> rollbackOnClass = this.getClassInArrayClosestToClassOrNull(rollbackOn, checkedException.getClass());
            if (rollbackOnClass == null) {
                throw checkedException;
            }
            Class<?> dontRollbackOnClass = this.getClassInArrayClosestToClassOrNull(dontRollbackOn, checkedException.getClass());
            if (dontRollbackOnClass != null) {
                if (rollbackOnClass.isAssignableFrom(dontRollbackOnClass)) {
                    throw checkedException;
                }
                if (dontRollbackOnClass.isAssignableFrom(rollbackOnClass)) {
                    this.markRollbackIfActiveTransaction();
                    throw checkedException;
                }
            }
            if (rollbackOnClass.equals(checkedException.getClass()) || rollbackOnClass.isAssignableFrom(checkedException.getClass())) {
                this.markRollbackIfActiveTransaction();
            }
            throw checkedException;
        }
        return object;
    }

    private Class<?> getClassInArrayClosestToClassOrNull(Class<?>[] exceptionArray, Class<?> exception) {
        if (exceptionArray == null || exception == null) {
            return null;
        }
        Class<?> closestMatch = null;
        for (Class<?> exceptionArrayElement : exceptionArray) {
            if (exceptionArrayElement.equals(exception)) {
                return exceptionArrayElement;
            }
            if (!exceptionArrayElement.isAssignableFrom(exception) || closestMatch != null && !closestMatch.isAssignableFrom(exceptionArrayElement)) continue;
            closestMatch = exceptionArrayElement;
        }
        return closestMatch;
    }

    private void markRollbackIfActiveTransaction() throws SystemException {
        Transaction transaction = this.getTransactionManager().getTransaction();
        if (transaction != null) {
            LOG.log(System.Logger.Level.DEBUG, "About to setRollbackOnly from @Transactional interceptor on transaction: {0}", transaction);
            this.getTransactionManager().setRollbackOnly();
        }
    }

    void setTransactionalTransactionOperationsManger(boolean userTransactionMethodsAllowed) {
        if (testTransactionManager != null) {
            return;
        }
        ComponentInvocation currentInvocation = this.getCurrentInvocation();
        if (currentInvocation == null) {
            LOG.log(System.Logger.Level.WARNING, "No ComponentInvocation present for @Transactional annotation processing. Restriction on use of UserTransaction will not be enforced.");
            return;
        }
        this.preexistingTransactionOperationsManager = (TransactionOperationsManager)currentInvocation.getTransactionOperationsManager();
        currentInvocation.setTransactionOperationsManager(userTransactionMethodsAllowed ? txOperationsManagerTransactionMethodsAllowed : txOperationsManagerTransactionMethodsNotAllowed);
    }

    void resetTransactionOperationsManager() {
        if (testTransactionManager != null) {
            return;
        }
        ComponentInvocation currentInvocation = this.getCurrentInvocation();
        if (currentInvocation == null) {
            LOG.log(System.Logger.Level.WARNING, "TransactionalInterceptorBase.resetTransactionOperationsManager currentInvocation is null");
            return;
        }
        currentInvocation.setTransactionOperationsManager(this.preexistingTransactionOperationsManager);
    }

    ComponentInvocation getCurrentInvocation() {
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        InvocationManager invocationManager = serviceLocator == null ? null : serviceLocator.getService(InvocationManager.class, new Annotation[0]);
        return invocationManager == null ? null : (ComponentInvocation)invocationManager.getCurrentInvocation();
    }

    static {
        txOperationsManagerTransactionMethodsAllowed = new TransactionalTransactionOperationsManagerTransactionMethodsAllowed();
        txOperationsManagerTransactionMethodsNotAllowed = new TransactionalTransactionOperationsManagerTransactionMethodsNotAllowed();
    }

    private static final class TransactionalTransactionOperationsManagerTransactionMethodsAllowed
    implements TransactionOperationsManager {
        private TransactionalTransactionOperationsManagerTransactionMethodsAllowed() {
        }

        @Override
        public boolean userTransactionMethodsAllowed() {
            return true;
        }

        @Override
        public void userTransactionLookupAllowed() throws NameNotFoundException {
        }

        @Override
        public void doAfterUtxBegin() {
        }
    }

    private static final class TransactionalTransactionOperationsManagerTransactionMethodsNotAllowed
    implements TransactionOperationsManager {
        private TransactionalTransactionOperationsManagerTransactionMethodsNotAllowed() {
        }

        @Override
        public boolean userTransactionMethodsAllowed() {
            return false;
        }

        @Override
        public void userTransactionLookupAllowed() throws NameNotFoundException {
        }

        @Override
        public void doAfterUtxBegin() {
        }
    }
}

