/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.persistence;

import com.sun.enterprise.container.common.impl.ComponentEnvManagerImpl;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.util.AnnotationUtil;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.SchemaManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;

public class PersistenceExtension
implements Extension {
    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        ApplicationInfo applicationInfo;
        PersistenceUnitsDescriptor persistenceUnits;
        Object container = ((ComponentInvocation)Globals.get(InvocationManager.class).getCurrentInvocation()).getContainer();
        if (container instanceof ApplicationInfo && (persistenceUnits = (applicationInfo = (ApplicationInfo)container).getMetaData(PersistenceUnitsDescriptor.class)) != null) {
            for (PersistenceUnitDescriptor descriptor : persistenceUnits.getPersistenceUnitDescriptors()) {
                this.addBeanForEntityManager(afterBeanDiscovery, descriptor);
                this.addBeanForEntityManagerFactory(afterBeanDiscovery, descriptor);
                this.addBeanForCriteriaBuilder(afterBeanDiscovery, descriptor);
                this.addBeanForPersistenceUnitUtil(afterBeanDiscovery, descriptor);
                this.addBeanForCache(afterBeanDiscovery, descriptor);
                this.addBeanForSchemaManager(afterBeanDiscovery, descriptor);
                this.addBeanForMetamodel(afterBeanDiscovery, descriptor);
            }
        }
    }

    private void addBeanForEntityManager(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitDescriptor descriptor) {
        BeanConfigurator<Object> bean = this.addQualifiedBean(afterBeanDiscovery, descriptor, (Type)((Object)EntityManager.class));
        if (descriptor.getScope() != null) {
            bean.scope(this.loadClass(descriptor.getScope()));
        }
        bean.createWith(e -> this.createEntityManager(descriptor.getName()));
    }

    private void addBeanForEntityManagerFactory(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitDescriptor descriptor) {
        BeanConfigurator<Object> bean = this.addQualifiedBean(afterBeanDiscovery, descriptor, (Type)((Object)EntityManagerFactory.class));
        if (descriptor.getScope() != null) {
            bean.scope(this.loadClass(descriptor.getScope()));
        }
        bean.createWith(e -> this.createEntityManagerFactory(descriptor.getName()));
    }

    private void addBeanForCriteriaBuilder(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitDescriptor descriptor) {
        this.addQualifiedBean(afterBeanDiscovery, descriptor, (Type)((Object)CriteriaBuilder.class)).scope(Dependent.class).createWith(e -> this.getEntityManagerFactory(descriptor).getCriteriaBuilder());
    }

    private void addBeanForPersistenceUnitUtil(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitDescriptor descriptor) {
        this.addQualifiedBean(afterBeanDiscovery, descriptor, (Type)((Object)PersistenceUnitUtil.class)).scope(Dependent.class).createWith(e -> this.getEntityManagerFactory(descriptor).getPersistenceUnitUtil());
    }

    private void addBeanForCache(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitDescriptor descriptor) {
        this.addQualifiedBean(afterBeanDiscovery, descriptor, (Type)((Object)Cache.class)).scope(Dependent.class).createWith(e -> this.getEntityManagerFactory(descriptor).getCache());
    }

    private void addBeanForSchemaManager(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitDescriptor descriptor) {
        this.addQualifiedBean(afterBeanDiscovery, descriptor, (Type)((Object)SchemaManager.class)).scope(Dependent.class).createWith(e -> this.getEntityManagerFactory(descriptor).getSchemaManager());
    }

    private void addBeanForMetamodel(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitDescriptor descriptor) {
        this.addQualifiedBean(afterBeanDiscovery, descriptor, (Type)((Object)Metamodel.class)).scope(Dependent.class).createWith(e -> this.getEntityManagerFactory(descriptor).getMetamodel());
    }

    private EntityManagerFactory getEntityManagerFactory(PersistenceUnitDescriptor descriptor) {
        return (EntityManagerFactory)CDI.current().select(EntityManagerFactory.class, (Annotation[])descriptor.getQualifiers().stream().map(e -> AnnotationUtil.createAnnotationInstance(this.loadClass((String)e))).toArray(Annotation[]::new)).get();
    }

    private BeanConfigurator<Object> addQualifiedBean(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitDescriptor descriptor, Type type2) {
        BeanConfigurator<Object> bean = afterBeanDiscovery.addBean().addType(type2);
        for (String qualifierClassName : descriptor.getQualifiers()) {
            bean.addQualifier(AnnotationUtil.createAnnotationInstance(this.loadClass(qualifierClassName)));
        }
        if (descriptor.getQualifiers().isEmpty()) {
            bean.addQualifier(AnnotationUtil.createAnnotationInstance(Default.class));
        }
        if (descriptor.getName() != null && !descriptor.getName().isBlank()) {
            bean.addQualifier(NamedLiteral.of(descriptor.getName()));
        }
        return bean;
    }

    private EntityManager createEntityManager(String unitName) {
        return Globals.get(ComponentEnvManagerImpl.class).createFactoryForEntityManager(new EntityManagerReferenceDescriptor(unitName)).create(null);
    }

    private EntityManagerFactory createEntityManagerFactory(String unitName) {
        return Globals.get(ComponentEnvManagerImpl.class).createFactoryForEntityManagerFactory(unitName).create(null);
    }

    private Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

