/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.LogManager;

public class LogNamesResource {
    protected ServiceLocator habitat = Globals.getDefaultBaseServiceLocator();

    @GET
    @Produces(value={"text/plain; qs=0.5"})
    public Response getLogNamesText(@QueryParam(value="instanceName") String instanceName) throws Exception {
        return this.getLogNames(instanceName, "text/plain");
    }

    @GET
    @Produces(value={"application/json; qs=1"})
    public Response getLogNamesJson(@QueryParam(value="instanceName") String instanceName) throws Exception {
        return this.getLogNames(instanceName, "application/json");
    }

    @GET
    @Produces(value={"application/xml; qs=0.75"})
    public Response getLogNamesXml(@QueryParam(value="instanceName") String instanceName) throws Exception {
        return this.getLogNames(instanceName, "application/xml");
    }

    private Response getLogNames(String instanceName, String type2) throws Exception {
        if (this.habitat.getService(LogManager.class, new Annotation[0]) == null) {
            throw new IOException("The GlassFish LogManager Service is not available. Not installed?");
        }
        LogFilter logFilter = this.habitat.getService(LogFilter.class, new Annotation[0]);
        return this.convertQueryResult(logFilter.getInstanceLogFileNames(instanceName), type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response convertQueryResult(List<String> files, String type2) throws Exception {
        Object entity;
        switch (type2) {
            case "application/json": {
                entity = new JSONObject().put("InstanceLogFileNames", files);
                break;
            }
            case "application/xml": {
                StringWriter xml = new StringWriter();
                try (XMLStreamWriter writer = XMLOutputFactory.newDefaultFactory().createXMLStreamWriter(xml);){
                    writer.writeStartElement("InstanceLogFileNames");
                    for (String file : files) {
                        writer.writeEmptyElement(file);
                    }
                    writer.writeEndElement();
                }
                entity = xml;
                break;
            }
            case "text/plain": {
                StringBuilder sb = new StringBuilder();
                String separator = "";
                for (String file : files) {
                    sb.append(separator);
                    sb.append(file);
                    separator = ",";
                }
                entity = sb;
                break;
            }
            default: {
                return Response.status(Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
            }
        }
        return Response.ok((Object)entity.toString(), type2).build();
    }
}

