/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.Utility;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.glassfish.admin.rest.adapter.LocatorBridge;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ProxyImpl;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;

@Path(value="/")
@Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5", "application/x-www-form-urlencoded;qs=0.5"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
public class MonitoringResource {
    @Inject
    private UriInfo uriInfo;
    @Inject
    private LocatorBridge locator;
    @Inject
    private ServerContext serverContext;

    @GET
    @Path(value="domain{path:.*}")
    @Produces(value={"application/json;qs=0.5", "application/xml;qs=0.5", "text/html"})
    public Response getChildNodes(@PathParam(value="path") List<PathSegment> pathSegments) {
        PathSegment lastSegment;
        Response.ResponseBuilder responseBuilder = Response.status(Response.Status.OK);
        RestActionReporter ar = new RestActionReporter();
        ar.setActionDescription("Monitoring Data");
        ar.setMessage("");
        ar.setSuccess();
        String currentInstanceName = System.getProperty("com.sun.aas.instanceName");
        boolean isRunningOnDAS = "server".equals(currentInstanceName);
        ServiceLocator serviceLocator = this.locator.getRemoteLocator();
        MonitoringRuntimeDataRegistry monitoringRegistry = serviceLocator.getService(MonitoringRuntimeDataRegistry.class, new Annotation[0]);
        TreeNode rootNode = monitoringRegistry.get(currentInstanceName);
        pathSegments = pathSegments.subList(1, pathSegments.size());
        if (!pathSegments.isEmpty() && (lastSegment = pathSegments.get(pathSegments.size() - 1)).getPath().isEmpty()) {
            pathSegments = pathSegments.subList(0, pathSegments.size() - 1);
        }
        if (pathSegments.isEmpty()) {
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            if (rootNode != null) {
                list.add(rootNode);
            }
            this.constructEntity(list, ar);
            if (isRunningOnDAS) {
                Domain domain = serviceLocator.getService(Domain.class, new Annotation[0]);
                Map links = (Map)ar.getExtraProperties().get("childResources");
                for (Server s : domain.getServers().getServer()) {
                    if ("server".equals(s.getName())) continue;
                    links.put(s.getName(), ProviderUtil.getElementLink(this.uriInfo, s.getName()));
                }
            }
            responseBuilder.entity(new ActionReportResult(ar));
        } else {
            String firstPathElement = pathSegments.get(0).getPath();
            if (firstPathElement.equals(currentInstanceName)) {
                TreeNode resultNode;
                StringBuilder pathInMonitoringRegistry = new StringBuilder();
                for (PathSegment pathSegment : pathSegments.subList(1, pathSegments.size())) {
                    if (pathInMonitoringRegistry.length() > 0) {
                        pathInMonitoringRegistry.append('.');
                    }
                    pathInMonitoringRegistry.append(pathSegment.getPath().replaceAll("\\.", "\\\\."));
                }
                TreeNode treeNode = resultNode = pathInMonitoringRegistry.length() > 0 && rootNode != null ? rootNode.getNode(pathInMonitoringRegistry.toString()) : rootNode;
                if (resultNode == null) {
                    responseBuilder.status(Response.Status.NOT_FOUND);
                    ar.setFailure();
                    responseBuilder.entity(new ActionReportResult(ar));
                } else {
                    ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                    if (resultNode.hasChildNodes()) {
                        list.addAll(resultNode.getEnabledChildNodes());
                    } else {
                        list.add(resultNode);
                    }
                    this.constructEntity(list, ar);
                    responseBuilder.entity(new ActionReportResult(ar));
                }
            } else if (isRunningOnDAS) {
                Properties proxiedResponse = Utility.runWithContextClassLoader(this.serverContext.getCommonClassLoader(), () -> new MonitoringProxyImpl().proxyRequest(this.uriInfo, Util.getJerseyClient(), serviceLocator));
                ar.setExtraProperties(proxiedResponse);
                responseBuilder.entity(new ActionReportResult(ar));
            } else {
                return Response.status(Response.Status.FORBIDDEN).build();
            }
        }
        return responseBuilder.build();
    }

    private void constructEntity(List<TreeNode> nodeList, RestActionReporter ar) {
        TreeMap<String, Object> entity = new TreeMap<String, Object>();
        TreeMap<String, String> links = new TreeMap<String, String>();
        for (TreeNode node : nodeList) {
            if (!node.hasChildNodes()) {
                Object value = node.getValue();
                if (value == null) continue;
                try {
                    if (value instanceof Statistic) {
                        Statistic statisticObject = (Statistic)value;
                        entity.put(node.getName(), ProviderUtil.getStatistic(statisticObject));
                        continue;
                    }
                    if (value instanceof Stats) {
                        TreeMap<String, Map<String, Object>> subMap = new TreeMap<String, Map<String, Object>>();
                        for (Statistic statistic : ((Stats)value).getStatistics()) {
                            subMap.put(statistic.getName(), ProviderUtil.getStatistic(statistic));
                        }
                        entity.put(node.getName(), subMap);
                        continue;
                    }
                    entity.put(node.getName(), ProviderUtil.jsonValue(value));
                }
                catch (Exception exception) {}
                continue;
            }
            String name = node.getName();
            name = name.replace("\\.", ".");
            links.put(name, ProviderUtil.getElementLink(this.uriInfo, name));
        }
        ar.getExtraProperties().put("entity", entity);
        ar.getExtraProperties().put("childResources", links);
    }

    private static class MonitoringProxyImpl
    extends ProxyImpl {
        private MonitoringProxyImpl() {
        }

        @Override
        public UriBuilder constructTargetURLPath(UriInfo sourceUriInfo, URL responseURLReceivedFromTarget) {
            return sourceUriInfo.getBaseUriBuilder().replacePath(responseURLReceivedFromTarget.getFile());
        }

        @Override
        public UriBuilder constructForwardURLPath(UriInfo sourceUriInfo) {
            return sourceUriInfo.getAbsolutePathBuilder();
        }

        @Override
        public String extractTargetInstanceName(UriInfo uriInfo) {
            return uriInfo.getPathSegments().get(1).getPath();
        }
    }
}

