/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.jvnet.hk2.config.Dom;

public abstract class LeafResource
extends AbstractResource {
    protected LeafContent entity;
    protected Dom parent;
    protected String tagName;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LeafResource.class);

    public void setEntity(LeafContent p) {
        this.entity = p;
    }

    public LeafContent getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        this.entity = new LeafContent();
        this.entity.name = tagName;
        this.entity.value = parent.leafElement(tagName);
    }

    @GET
    @Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5", "application/x-www-form-urlencoded;qs=0.5"})
    public ActionReportResult get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        if (this.getEntity() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return this.buildActionReportResult();
    }

    @POST
    @Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5", "application/x-www-form-urlencoded;qs=0.5"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult create(HashMap<String, String> data) {
        if (data.containsKey("operation") && data.get("operation").equals("__deleteoperation")) {
            data.remove("operation");
            return this.delete(data);
        }
        return null;
    }

    @DELETE
    @Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5", "application/x-www-form-urlencoded;qs=0.5"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult delete(HashMap<String, String> data) {
        ResourceUtil.addQueryString(this.uriInfo.getQueryParameters(), data);
        return null;
    }

    @OPTIONS
    @Produces(value={"application/json;qs=0.5", "text/html", "application/xml;qs=0.5"})
    public ActionReportResult options() {
        return this.buildActionReportResult();
    }

    protected ActionReportResult buildActionReportResult() {
        RestActionReporter ar = new RestActionReporter();
        String typeKey = Util.decode(this.getName());
        ar.setActionDescription(typeKey);
        ar.getExtraProperties().put("entityLeaf", this.getEntity());
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        Map<String, MethodMetaData> mmd = this.getMethodMetaData();
        optionsResult.putMethodMetaData("GET", mmd.get("GET"));
        optionsResult.putMethodMetaData("POST", mmd.get("POST"));
        ResourceUtil.addMethodMetaData(ar, mmd);
        ActionReportResult r = new ActionReportResult(ar, optionsResult);
        r.setLeafContent(this.entity);
        return r;
    }

    protected Map<String, MethodMetaData> getMethodMetaData() {
        TreeMap<String, MethodMetaData> mmd = new TreeMap<String, MethodMetaData>();
        mmd.put("GET", new MethodMetaData());
        return mmd;
    }

    protected String getName() {
        return Util.getResourceName(this.uriInfo);
    }

    public static class LeafContent {
        public String name;
        public String value;
    }
}

