/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.utils.Util;

@Consumes(value={"application/vnd.oracle.glassfish+json"})
public class RestModelListReader
implements MessageBodyReader<List<RestModel>> {
    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String submittedType = mediaType.toString();
        int index = submittedType.indexOf(";");
        if (index > -1) {
            submittedType = submittedType.substring(0, index);
        }
        return submittedType.equals("application/vnd.oracle.glassfish+json") && List.class.isAssignableFrom(type2) && RestModel.class.isAssignableFrom(Util.getFirstGenericType(genericType));
    }

    @Override
    public List<RestModel> readFrom(Class<List<RestModel>> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            Locale locale = CompositeUtil.instance().getLocale(httpHeaders);
            ArrayList<RestModel> list = new ArrayList<RestModel>();
            JSONArray array = new JSONArray(new String(entityStream.readAllBytes(), StandardCharsets.UTF_8));
            Class modelType = null;
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                modelType = (Class)pt.getActualTypeArguments()[0];
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject o = array.getJSONObject(i);
                RestModel model = (RestModel)CompositeUtil.instance().unmarshallClass(locale, modelType, o);
                Set cv = CompositeUtil.instance().validateRestModel(locale, model);
                if (!cv.isEmpty()) {
                    Response response = Response.status(Response.Status.BAD_REQUEST).entity(CompositeUtil.instance().getValidationFailureMessages(locale, cv, model)).build();
                    throw new WebApplicationException(response);
                }
                list.add(model);
            }
            return list;
        }
        catch (Exception e) {
            throw new WebApplicationException(e);
        }
    }
}

