/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.results.OptionsResult;

@Provider
@Produces(value={"application/json"})
public class OptionsResultJsonProvider
extends BaseProvider<OptionsResult> {
    private static final String NAME = "name";
    private static final String MESSAGE_PARAMETERS = "messageParameters";

    public OptionsResultJsonProvider() {
        super(OptionsResult.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public String getContent(OptionsResult proxy) {
        JSONObject obj = new JSONObject();
        try {
            obj.put(proxy.getName(), this.getRespresenationForMethodMetaData(proxy));
        }
        catch (JSONException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        return obj.toString();
    }

    public JSONArray getRespresenationForMethodMetaData(OptionsResult proxy) {
        JSONArray arr = new JSONArray();
        Set<String> methods = proxy.methods();
        Iterator<String> iterator = methods.iterator();
        while (iterator.hasNext()) {
            try {
                String methodName = iterator.next();
                MethodMetaData methodMetaData = proxy.getMethodMetaData(methodName);
                JSONObject method = new JSONObject();
                method.put(NAME, methodName);
                method.put(MESSAGE_PARAMETERS, this.getMessageParams(methodMetaData));
                arr.put(method);
            }
            catch (JSONException ex) {
                RestLogging.restLogger.log(Level.SEVERE, null, ex);
            }
        }
        return arr;
    }

    private JSONObject getParameter(ParameterMetaData parameterMetaData) throws JSONException {
        JSONObject result = new JSONObject();
        for (String attributeName : parameterMetaData.attributes()) {
            result.put(attributeName, parameterMetaData.getAttributeValue(attributeName));
        }
        return result;
    }

    private JSONObject getMessageParams(MethodMetaData methodMetaData) throws JSONException {
        JSONObject result = new JSONObject();
        if (methodMetaData.sizeParameterMetaData() > 0) {
            Set<String> parameters = methodMetaData.parameters();
            for (String parameter : parameters) {
                ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
                result.put(parameter, this.getParameter(parameterMetaData));
            }
        }
        return result;
    }
}

