/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.CollectionLeafMetaData;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.GeneratorException;
import org.glassfish.admin.rest.generator.ResourcesGenerator;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.config.support.Singleton;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.DomDocument;

public abstract class ResourcesGeneratorBase
implements ResourcesGenerator {
    private static final Set<String> alreadyGenerated = new HashSet<String>();
    ServiceLocator habitat;
    private static final Map<String, String> configBeanToDELETECommand = Map.ofEntries(Map.entry("AdminObjectResource", "delete-admin-object"), Map.entry("AuditModule", "delete-audit-module"), Map.entry("AuthRealm", "delete-auth-realm"), Map.entry("ApplicationRef", "delete-application-ref"), Map.entry("Cluster", "delete-cluster"), Map.entry("Config", "delete-config"), Map.entry("ConnectorConnectionPool", "delete-connector-connection-pool"), Map.entry("ConnectorResource", "delete-connector-resource"), Map.entry("CustomResource", "delete-custom-resource"), Map.entry("ExternalJndiResource", "delete-jndi-resource"), Map.entry("HttpListener", "delete-http-listener"), Map.entry("Http", "delete-http"), Map.entry("IiopListener", "delete-iiop-listener"), Map.entry("JdbcResource", "delete-jdbc-resource"), Map.entry("JaccProvider", "delete-jacc-provider"), Map.entry("LbConfig", "delete-http-lb-config"), Map.entry("LoadBalancer", "delete-http-lb"), Map.entry("NetworkListener", "delete-network-listener"), Map.entry("Profiler", "delete-profiler"), Map.entry("Protocol", "delete-protocol"), Map.entry("ProtocolFilter", "delete-protocol-filter"), Map.entry("ProtocolFinder", "delete-protocol-finder"), Map.entry("ProviderConfig", "delete-message-security-provider"), Map.entry("ResourceAdapterConfig", "delete-resource-adapter-config"), Map.entry("SecurityMap", "delete-connector-security-map"), Map.entry("Ssl", "delete-ssl"), Map.entry("Transport", "delete-transport"), Map.entry("ThreadPool", "delete-threadpool"), Map.entry("VirtualServer", "delete-virtual-server"), Map.entry("WorkSecurityMap", "delete-connector-work-security-map"));
    public static final Map<String, String> configBeanToPOSTCommand = Map.ofEntries(Map.entry("Application", "redeploy"), Map.entry("JavaConfig", "create-profiler"), Map.entry("ListAdminObjectResource", "create-admin-object"), Map.entry("ListApplication", "deploy"), Map.entry("ListApplicationRef", "create-application-ref"), Map.entry("ListAuditModule", "create-audit-module"), Map.entry("ListAuthRealm", "create-auth-realm"), Map.entry("ListCluster", "create-cluster"), Map.entry("ListConfig", "_create-config"), Map.entry("ListConnectorConnectionPool", "create-connector-connection-pool"), Map.entry("ListConnectorResource", "create-connector-resource"), Map.entry("ListCustomResource", "create-custom-resource"), Map.entry("ListExternalJndiResource", "create-jndi-resource"), Map.entry("ListHttpListener", "create-http-listener"), Map.entry("ListIiopListener", "create-iiop-listener"), Map.entry("ListJaccProvider", "create-jacc-provider"), Map.entry("ListJdbcConnectionPool", "create-jdbc-connection-pool"), Map.entry("ListJdbcResource", "create-jdbc-resource"), Map.entry("ListJmsHost", "create-jms-host"), Map.entry("ListLbConfig", "create-http-lb-config"), Map.entry("ListLoadBalancer", "create-http-lb"), Map.entry("ListMailResource", "create-mail-resource"), Map.entry("ListMessageSecurityConfig", "create-message-security-provider"), Map.entry("ListNetworkListener", "create-network-listener"), Map.entry("ListProtocol", "create-protocol"), Map.entry("ListResourceAdapterConfig", "create-resource-adapter-config"), Map.entry("ListResourceRef", "create-resource-ref"), Map.entry("ListSystemProperty", "create-system-properties"), Map.entry("ListThreadPool", "create-threadpool"), Map.entry("ListTransport", "create-transport"), Map.entry("ListVirtualServer", "create-virtual-server"), Map.entry("ListWorkSecurityMap", "create-connector-work-security-map"), Map.entry("ProtocolFilter", "create-protocol-filter"), Map.entry("ProtocolFinder", "create-protocol-finder"), Map.entry("ListSecurityMap", "create-connector-security-map"));
    public static final Map<String, CollectionLeafMetaData> configBeanToCollectionLeafMetaData = Map.ofEntries(Map.entry("JvmOptions", new CollectionLeafMetaData("create-jvm-options", "delete-jvm-options", "JvmOption")));

    public ResourcesGeneratorBase(ServiceLocator habitat) {
        this.habitat = habitat;
    }

    @Override
    public void generateSingle(ConfigModel model, DomDocument domDocument) {
        ClassWriter classWriter;
        this.configModelVisited(model);
        String serverConfigName = ResourceUtil.getUnqualifiedTypeName(model.targetTypeName);
        String beanName = ResourcesGeneratorBase.getBeanName(serverConfigName);
        String className = this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        String baseClassName = "TemplateRestResource";
        String resourcePath = null;
        if (beanName.equals("Domain")) {
            baseClassName = "org.glassfish.admin.rest.resources.GlassFishDomainResource";
            resourcePath = "domain";
        }
        if ((classWriter = this.getClassWriter(className, baseClassName, resourcePath)) != null) {
            this.generateCommandResources(beanName, classWriter);
            this.generateGetDeleteCommandMethod(beanName, classWriter);
            this.generateCustomResourceMapping(beanName, classWriter);
            for (String elementName : model.getElementNames()) {
                ConfigModel.Property childElement = model.getElement(elementName);
                if (elementName.equals("*")) {
                    ConfigModel.Node node = (ConfigModel.Node)childElement;
                    ConfigModel childModel = node.getModel();
                    List<ConfigModel> subChildConfigModels = ResourceUtil.getRealChildConfigModels(childModel, domDocument);
                    for (ConfigModel subChildConfigModel : subChildConfigModels) {
                        if (ResourceUtil.isOnlyATag(childModel) || ResourceUtil.isOnlyATag(subChildConfigModel) || subChildConfigModel.getAttributeNames().isEmpty() || this.hasSingletonAnnotation(subChildConfigModel)) {
                            String childResourceClassName = this.getClassName(ResourceUtil.getUnqualifiedTypeName(subChildConfigModel.targetTypeName));
                            String childPath = subChildConfigModel.getTagName();
                            classWriter.createGetChildResource(childPath, childResourceClassName);
                            this.generateSingle(subChildConfigModel, domDocument);
                            continue;
                        }
                        this.processNonLeafChildConfigModel(subChildConfigModel, childElement, domDocument, classWriter);
                    }
                    continue;
                }
                if (childElement.isLeaf()) {
                    String childResourceClassName;
                    String childResourceBeanName;
                    if (childElement.isCollection()) {
                        childResourceBeanName = ResourcesGeneratorBase.getBeanName(elementName);
                        childResourceClassName = this.getClassName(childResourceBeanName);
                        classWriter.createGetChildResource(elementName, childResourceClassName);
                        this.generateCollectionLeafResource(childResourceBeanName);
                        continue;
                    }
                    childResourceBeanName = ResourcesGeneratorBase.getBeanName(elementName);
                    childResourceClassName = this.getClassName(childResourceBeanName);
                    classWriter.createGetChildResource(elementName, childResourceClassName);
                    this.generateLeafResource(childResourceBeanName);
                    continue;
                }
                this.processNonLeafChildElement(elementName, childElement, domDocument, classWriter);
            }
            classWriter.done();
        }
    }

    public void generateList(ConfigModel model, DomDocument domDocument) {
        this.configModelVisited(model);
        String serverConfigName = ResourceUtil.getUnqualifiedTypeName(model.targetTypeName);
        String beanName = ResourcesGeneratorBase.getBeanName(serverConfigName);
        String className = "List" + this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        ClassWriter classWriter = this.getClassWriter(className, "TemplateListOfResource", null);
        if (classWriter != null) {
            String keyAttributeName = this.getKeyAttributeName(model);
            String childResourceClassName = this.getClassName(beanName);
            classWriter.createGetChildResourceForListResources(keyAttributeName, childResourceClassName);
            this.generateCommandResources("List" + beanName, classWriter);
            this.generateGetPostCommandMethod("List" + beanName, classWriter);
            classWriter.done();
            this.generateSingle(model, domDocument);
        }
    }

    public void configModelVisited(ConfigModel model) {
    }

    private void generateCollectionLeafResource(String beanName) {
        String className = this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        ClassWriter classWriter = this.getClassWriter(className, "CollectionLeafResource", null);
        if (classWriter != null) {
            CollectionLeafMetaData metaData = configBeanToCollectionLeafMetaData.get(beanName);
            if (metaData != null) {
                if (metaData.postCommandName != null && ResourceUtil.commandIsPresent(this.habitat, metaData.postCommandName)) {
                    classWriter.createGetPostCommandForCollectionLeafResource(metaData.postCommandName);
                }
                if (metaData.deleteCommandName != null && ResourceUtil.commandIsPresent(this.habitat, metaData.deleteCommandName)) {
                    classWriter.createGetDeleteCommandForCollectionLeafResource(metaData.deleteCommandName);
                }
                classWriter.createGetDisplayNameForCollectionLeafResource(metaData.displayName);
            }
            classWriter.done();
        }
    }

    private void generateLeafResource(String beanName) {
        String className = this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        ClassWriter classWriter = this.getClassWriter(className, "LeafResource", null);
        if (classWriter != null) {
            classWriter.done();
        }
    }

    private void processNonLeafChildElement(String elementName, ConfigModel.Property childElement, DomDocument domDocument, ClassWriter classWriter) {
        ConfigModel.Node node = (ConfigModel.Node)childElement;
        ConfigModel childModel = node.getModel();
        String beanName = ResourceUtil.getUnqualifiedTypeName(childModel.targetTypeName);
        if (beanName.equals("Property")) {
            classWriter.createGetChildResource("property", "PropertiesBagResource");
        } else {
            Object childResourceClassName = this.getClassName(beanName);
            if (childElement.isCollection()) {
                childResourceClassName = "List" + (String)childResourceClassName;
            }
            classWriter.createGetChildResource(elementName, (String)childResourceClassName);
        }
        if (childElement.isCollection()) {
            this.generateList(childModel, domDocument);
        } else {
            this.generateSingle(childModel, domDocument);
        }
    }

    private void processNonLeafChildConfigModel(ConfigModel childConfigModel, ConfigModel.Property childElement, DomDocument domDocument, ClassWriter classWriter) {
        String childResourceClassName = this.getClassName("List" + ResourceUtil.getUnqualifiedTypeName(childConfigModel.targetTypeName));
        String childPath = childConfigModel.getTagName();
        classWriter.createGetChildResource(childPath, childResourceClassName);
        if (childElement.isCollection()) {
            this.generateList(childConfigModel, domDocument);
        }
    }

    private void generateGetDeleteCommandMethod(String beanName, ClassWriter classWriter) {
        String commandName = configBeanToDELETECommand.get(beanName);
        if (commandName != null && ResourceUtil.commandIsPresent(this.habitat, commandName)) {
            classWriter.createGetDeleteCommand(commandName);
        }
    }

    private void generateCustomResourceMapping(String beanName, ClassWriter classWriter) {
        for (CommandResourceMetaData cmd : CommandResourceMetaData.getCustomResourceMapping(beanName)) {
            classWriter.createCustomResourceMapping(cmd.customClassName, cmd.resourcePath);
        }
    }

    void generateGetPostCommandMethod(String resourceName, ClassWriter classWriter) {
        String commandName = configBeanToPOSTCommand.get(resourceName);
        if (commandName != null && ResourceUtil.commandIsPresent(this.habitat, commandName)) {
            classWriter.createGetPostCommand(commandName);
        }
    }

    private void generateCommandResources(String parentBeanName, ClassWriter parentWriter) {
        List<CommandResourceMetaData> commandMetaData = CommandResourceMetaData.getMetaData(parentBeanName);
        if (commandMetaData.size() > 0) {
            for (CommandResourceMetaData metaData : commandMetaData) {
                if (!ResourceUtil.commandIsPresent(this.habitat, metaData.command)) continue;
                String commandResourceName = parentBeanName + ResourcesGeneratorBase.getBeanName(metaData.resourcePath);
                String commandResourceClassName = this.getClassName(commandResourceName);
                this.generateCommandResourceClass(parentBeanName, metaData);
                parentWriter.createGetCommandResource(commandResourceClassName, metaData.resourcePath);
            }
            parentWriter.createGetCommandResourcePaths(commandMetaData);
        }
    }

    private void generateCommandResourceClass(String parentBeanName, CommandResourceMetaData metaData) {
        String baseClassName;
        String commandResourceClassName = this.getClassName(parentBeanName + ResourcesGeneratorBase.getBeanName(metaData.resourcePath));
        if (this.alreadyGenerated(commandResourceClassName)) {
            return;
        }
        String commandName = metaData.command;
        String commandDisplayName = metaData.resourcePath;
        String httpMethod = metaData.httpMethod;
        String commandAction = metaData.displayName;
        if ("GET".equals(httpMethod)) {
            baseClassName = "org.glassfish.admin.rest.resources.TemplateCommandGetResource";
        } else if ("DELETE".equals(httpMethod)) {
            baseClassName = "org.glassfish.admin.rest.resources.TemplateCommandDeleteResource";
        } else if ("POST".equals(httpMethod)) {
            baseClassName = "org.glassfish.admin.rest.resources.TemplateCommandPostResource";
        } else {
            throw new GeneratorException("Invalid httpMethod specified: " + httpMethod);
        }
        ClassWriter classWriter = this.getClassWriter(commandResourceClassName, baseClassName, null);
        if (classWriter != null) {
            boolean isLinkedToParent = false;
            if (metaData.commandParams != null) {
                for (CommandResourceMetaData.ParameterMetaData parameterMetaData : metaData.commandParams) {
                    if (!"$parent".equals(parameterMetaData.value)) continue;
                    isLinkedToParent = true;
                    break;
                }
            }
            classWriter.createCommandResourceConstructor(commandResourceClassName, commandName, httpMethod, isLinkedToParent, metaData.commandParams, commandDisplayName, commandAction);
            classWriter.done();
        }
    }

    protected boolean alreadyGenerated(String className) {
        boolean retVal = true;
        if (!alreadyGenerated.contains(className)) {
            alreadyGenerated.add(className);
            retVal = false;
        }
        return retVal;
    }

    private String getClassName(String beanName) {
        return beanName + "Resource";
    }

    public static String getBeanName(String elementName) {
        StringBuilder ret = new StringBuilder();
        boolean nextIsUpper = true;
        for (int i = 0; i < elementName.length(); ++i) {
            if (nextIsUpper) {
                ret.append(elementName.substring(i, i + 1).toUpperCase(Locale.US));
                nextIsUpper = false;
                continue;
            }
            if (elementName.charAt(i) == '-') {
                nextIsUpper = true;
                continue;
            }
            if (elementName.charAt(i) == '/') {
                nextIsUpper = true;
                continue;
            }
            ret.append(elementName.charAt(i));
        }
        return ret.toString();
    }

    private String getKeyAttributeName(ConfigModel model) {
        String keyAttributeName = null;
        if (model.key == null) {
            for (String s : model.getAttributeNames()) {
                if (!s.equals("name")) continue;
                keyAttributeName = ResourcesGeneratorBase.getBeanName(s);
            }
            if (keyAttributeName == null) {
                Set<String> attributeNames = model.getAttributeNames();
                keyAttributeName = !attributeNames.isEmpty() ? ResourcesGeneratorBase.getBeanName(attributeNames.iterator().next()) : "ThisIsAModelBug:NoKeyAttr";
            }
        } else {
            int keyLength = model.key.length();
            String key = model.key.substring(1, model.key.endsWith(">") ? keyLength - 1 : keyLength);
            keyAttributeName = ResourcesGeneratorBase.getBeanName(key);
        }
        return keyAttributeName;
    }

    private boolean hasSingletonAnnotation(ConfigModel model) {
        try {
            Class<?> cbp = model.classLoaderHolder.loadClass(model.targetTypeName);
            if (cbp != null) {
                Singleton sing = cbp.getAnnotation(Singleton.class);
                return sing != null;
            }
        }
        catch (MultiException e) {
            e.printStackTrace();
        }
        return false;
    }
}

