/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite;

import com.sun.enterprise.v3.admin.AdminCommandJob;
import com.sun.enterprise.v3.common.ActionReporter;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.security.auth.Subject;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.RestResource;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.model.ResponseBody;
import org.glassfish.admin.rest.model.RestCollectionResponseBody;
import org.glassfish.admin.rest.model.RestModelResponseBody;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.utils.JobIdAsyncAdminCommandInvoker;
import org.glassfish.admin.rest.utils.JsonFilter;
import org.glassfish.admin.rest.utils.JsonUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.internal.api.Globals;
import org.glassfish.jersey.internal.util.collection.Ref;

@Produces(value={"application/vnd.oracle.glassfish+json"})
public abstract class CompositeResource
extends AbstractResource
implements RestResource {
    public static final String CONSUMES_TYPE = "application/vnd.oracle.glassfish+json";
    protected static final String DETACHED = "__detached";
    protected static final String DETACHED_DEFAULT = "false";
    protected static final String INCLUDE = "__includeFields";
    protected static final String EXCLUDE = "__excludeFields";
    protected static final int THREAD_POOL_CORE = 5;
    protected static final int THREAD_POOL_MAX = 10;
    protected CompositeUtil compositeUtil = CompositeUtil.instance();

    public void setSubjectRef(Ref<Subject> subjectRef) {
        this.subjectRef = subjectRef;
    }

    public CompositeUtil getCompositeUtil() {
        return this.compositeUtil;
    }

    public <T> T getSubResource(Class<T> clazz) {
        logger.log(Level.FINEST, () -> "Creating sub resource of " + String.valueOf(clazz));
        try {
            T resource = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            CompositeResource cr = (CompositeResource)resource;
            cr.locatorBridge = this.locatorBridge;
            cr.subjectRef = this.subjectRef;
            cr.uriInfo = this.uriInfo;
            cr.requestHeaders = this.requestHeaders;
            cr.serviceLocator = this.serviceLocator;
            return resource;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected <T> T newModel(Class<T> modelIface) {
        return this.getCompositeUtil().getModel(modelIface);
    }

    protected <T extends RestModel> T newTemplate(Class<T> modelIface) {
        RestModel template = (RestModel)this.newModel(modelIface);
        template.allFieldsSet();
        return (T)template;
    }

    protected <T extends RestModel> T getTypedModel(Class<T> modelIface, JSONObject jsonModel) throws Exception {
        if (jsonModel == null) {
            return null;
        }
        return (T)((RestModel)CompositeUtil.instance().unmarshallClass(this.getLocale(), modelIface, jsonModel));
    }

    protected JSONObject getJsonModel(RestModel typedModel) throws Exception {
        return (JSONObject)JsonUtil.getJsonObject(typedModel, false);
    }

    protected URI getChildItemUri(String name) {
        return this.getSubUri("id/" + name);
    }

    protected URI getUri(String path) {
        return this.uriInfo.getBaseUriBuilder().path(path).build(new Object[0]);
    }

    protected URI getSubUri(String name) {
        return this.uriInfo.getAbsolutePathBuilder().path(name).build(new Object[0]);
    }

    protected void addResourceLink(ResponseBody rb, String rel) throws Exception {
        rb.addResourceLink(rel, this.getSubUri(rel));
    }

    protected void addActionResourceLink(ResponseBody rb, String action) throws Exception {
        rb.addActionResourceLink(action, this.getSubUri(action));
    }

    protected boolean includeResourceLinks() {
        String hdr = this.requestHeaders.getRequestHeaders().getFirst("X-Skip-Metadata");
        boolean skip = "true".equalsIgnoreCase(hdr);
        return !skip;
    }

    protected URI getParentUri() throws Exception {
        return this.getParentUri(false);
    }

    protected URI getCollectionChildParentUri() throws Exception {
        return this.getParentUri(true);
    }

    private URI getParentUri(boolean isCollectionChild) throws Exception {
        List<PathSegment> pathSegments = this.uriInfo.getPathSegments();
        int count = pathSegments.size() - 1;
        if (isCollectionChild) {
            --count;
        }
        if (count <= 0) {
            return null;
        }
        UriBuilder bldr = this.uriInfo.getBaseUriBuilder();
        for (int i = 0; i < count; ++i) {
            bldr.path(pathSegments.get(i).getPath());
        }
        return bldr.build(new Object[0]);
    }

    protected ActionReporter executeReadCommand(String command, ParameterMap parameters) {
        return this.getCompositeUtil().executeCommand(this.getSubject(), command, parameters, Response.Status.NOT_FOUND, true, true);
    }

    protected String generateDefaultName(String namePrefix, Collection<String> usedNames) {
        for (int i = 1; i <= 100; ++i) {
            String name = namePrefix + "-" + i;
            if (usedNames.contains(name)) continue;
            return name;
        }
        return "";
    }

    protected Response created(String name, String message) throws Exception {
        return this.created(this.responseBody(), name, message);
    }

    protected Response created(ResponseBody rb, String name, String message) throws Exception {
        rb.addSuccess(message);
        return this.created(rb, name);
    }

    protected Response created(ResponseBody rb, String name) throws Exception {
        return this.created(rb, this.getChildItemUri(name));
    }

    protected Response created(ResponseBody rb, URI uri) throws Exception {
        return Response.created(uri).entity(rb).build();
    }

    protected Response updated(String message) {
        return this.updated(this.responseBody(), message);
    }

    protected Response updated(ResponseBody rb, String message) {
        rb.addSuccess(message);
        return this.updated(rb);
    }

    protected Response updated(ResponseBody rb) {
        return this.ok(rb);
    }

    protected Response deleted(String message) {
        return this.deleted(this.responseBody(), message);
    }

    protected Response deleted(ResponseBody rb, String message) {
        rb.addSuccess(message);
        return this.deleted(rb);
    }

    protected Response deleted(ResponseBody rb) {
        return this.ok(rb);
    }

    protected Response acted(String message) {
        return this.acted(this.responseBody(), message);
    }

    protected Response acted(ResponseBody rb, String message) {
        rb.addSuccess(message);
        return this.acted(rb);
    }

    protected Response acted(ResponseBody rb) {
        return this.ok(rb);
    }

    protected Response accepted(String message, URI jobUri, URI newItemUri) {
        return this.accepted(this.responseBody(), message, jobUri, newItemUri);
    }

    protected Response accepted(ResponseBody rb, String message, URI jobUri, URI newItemUri) {
        rb.addSuccess(message);
        return this.accepted(rb, jobUri, newItemUri);
    }

    protected Response accepted(ResponseBody rb, URI jobUri, URI newItemUri) {
        Response.ResponseBuilder bldr = Response.status(Response.Status.ACCEPTED).entity(rb);
        if (jobUri != null) {
            bldr.header("Location", jobUri);
        }
        if (newItemUri != null) {
            bldr.header("X-Location", newItemUri);
        }
        return bldr.build();
    }

    protected Response accepted(String command, ParameterMap parameters, URI childUri) {
        return this.accepted(this.responseBody(), this.launchDetachedCommand(command, parameters), childUri);
    }

    protected URI launchDetachedCommand(String command, ParameterMap parameters) {
        CommandRunner cr = Globals.getDefaultHabitat().getService(CommandRunner.class, new Annotation[0]);
        RestActionReporter ar = new RestActionReporter();
        CommandInvocation<AdminCommandJob> commandInvocation = cr.getCommandInvocation(command, ar, this.getSubject()).parameters(parameters);
        String jobId = new JobIdAsyncAdminCommandInvoker(commandInvocation).start();
        return this.getUri("jobs/id/" + jobId);
    }

    protected Response ok(ResponseBody rb) {
        return Response.ok(rb).build();
    }

    protected Response badRequest(ResponseBody rb, String message) {
        rb.addFailure(message);
        return this.badRequest(rb);
    }

    protected Response badRequest(ResponseBody rb) {
        return Response.status(Response.Status.BAD_REQUEST).entity(rb).build();
    }

    protected WebApplicationException badRequest(Throwable cause) {
        return new WebApplicationException(cause, Response.Status.BAD_REQUEST);
    }

    protected WebApplicationException badRequest(String message) {
        return new WebApplicationException(Response.status(Response.Status.BAD_REQUEST).entity(message).build());
    }

    protected WebApplicationException notFound(String message) {
        return new WebApplicationException(Response.status(Response.Status.NOT_FOUND).entity(message).build());
    }

    protected <T extends RestModel> RestCollectionResponseBody<T> restCollectionResponseBody(Class<T> modelIface, String collectionName, URI parentUri) {
        RestCollectionResponseBody<T> rb = this.restCollectionResponseBody(modelIface, collectionName);
        rb.addParentResourceLink(parentUri);
        return rb;
    }

    protected <T extends RestModel> RestCollectionResponseBody<T> restCollectionResponseBody(Class<T> modelIface, String collectionName) {
        return new RestCollectionResponseBody(this.includeResourceLinks(), this.uriInfo, collectionName);
    }

    protected <T extends RestModel> RestModelResponseBody<T> restModelResponseBody(Class<T> modelIface, URI parentUri, T entity) {
        RestModelResponseBody<T> rb = this.restModelResponseBody(modelIface, parentUri);
        rb.setEntity(entity);
        return rb;
    }

    protected <T extends RestModel> RestModelResponseBody<T> restModelResponseBody(Class<T> modelIface, URI parentUri) {
        RestModelResponseBody<T> rb = this.restModelResponseBody(modelIface);
        rb.addParentResourceLink(parentUri);
        return rb;
    }

    protected <T extends RestModel> RestModelResponseBody<T> restModelResponseBody(Class<T> modelIface) {
        return new RestModelResponseBody(this.includeResourceLinks());
    }

    protected ResponseBody responseBody() {
        return new ResponseBody(this.includeResourceLinks());
    }

    protected Response getResponse(ResponseBody responseBody) {
        return this.getResponse(Response.Status.OK, responseBody);
    }

    protected Response getResponse(Response.Status status, ResponseBody responseBody) {
        return Response.status(status).entity(responseBody).build();
    }

    protected JsonFilter getFilter(String include, String exclude) throws Exception {
        return new JsonFilter(this.getLocale(), include, exclude);
    }

    protected JsonFilter getFilter(String include, String exclude, String identityAttr) throws Exception {
        return new JsonFilter(this.getLocale(), include, exclude, identityAttr);
    }

    protected <T extends RestModel> T filterModel(Class<T> modelIface, T unfilteredModel, String include, String exclude) throws Exception {
        return this.filterModel(modelIface, unfilteredModel, this.getFilter(include, exclude));
    }

    protected <T extends RestModel> T filterModel(Class<T> modelIface, T unfilteredModel, String include, String exclude, String identityAttr) throws Exception {
        return this.filterModel(modelIface, unfilteredModel, this.getFilter(include, exclude, identityAttr));
    }

    protected <T extends RestModel> T filterModel(Class<T> modelIface, T unfilteredModel, JsonFilter filter) throws Exception {
        JSONObject unfilteredJson = (JSONObject)JsonUtil.getJsonObject(unfilteredModel, false);
        JSONObject filteredJson = filter.trim(unfilteredJson);
        T filteredModel = this.getTypedModel(modelIface, filteredJson);
        filteredModel.trimmed();
        return filteredModel;
    }

    protected Locale getLocale() {
        return CompositeUtil.instance().getLocale(this.requestHeaders);
    }

    protected String getPathParam(String name) {
        return this.uriInfo.getPathParameters().getFirst(name);
    }

    protected ParameterMap parameterMap() {
        return Util.parameterMap();
    }

    protected synchronized ExecutorService getExecutorService() {
        return ExecutorServiceHolder.INSTANCE;
    }

    private static class ExecutorServiceHolder {
        private static final ExecutorService INSTANCE = new ThreadPoolExecutor(5, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(10, true), new ThreadPoolExecutor.CallerRunsPolicy());

        private ExecutorServiceHolder() {
        }
    }

    public class CreateCommandInvoker
    extends CommandInvoker {
        private String newItemName;

        public CreateCommandInvoker(CompositeResource this$0) {
            super(this$0);
        }

        public CreateCommandInvoker(CompositeResource this$0, String command, ParameterMap params, String successMessage, String newItemName) {
            super(this$0, command, params, successMessage);
            this.setNewItemName(newItemName);
        }

        public void setNewItemName(String val) {
            this.newItemName = val;
        }

        public String getNewItemName() {
            return this.newItemName;
        }
    }

    private class CommandInvoker {
        private String command;
        private ParameterMap params;
        private String successMsg;

        public CommandInvoker(CompositeResource compositeResource) {
        }

        public CommandInvoker(CompositeResource compositeResource, String command, ParameterMap params, String successMessage) {
            this.setCommand(command);
            this.setParams(params);
            this.setSuccessMessage(successMessage);
        }

        public void setCommand(String val) {
            this.command = val;
        }

        public String getCommand() {
            return this.command;
        }

        public void setParams(ParameterMap val) {
            this.params = val;
        }

        public ParameterMap getParams() {
            return this.params;
        }

        public void setSuccessMessage(String val) {
            this.successMsg = val;
        }

        public String getSuccessMessage() {
            return this.successMsg;
        }

        public void setResult(Properties extraProperties) {
        }
    }
}

