/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.yasson.internal.DeserializationContextImpl;
import org.eclipse.yasson.internal.JsonbConfigProperties;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.JsonbDateFormatter;
import org.eclipse.yasson.internal.JsonbNumberFormatter;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.components.DeserializerBinding;
import org.eclipse.yasson.internal.deserializer.AdapterDeserializer;
import org.eclipse.yasson.internal.deserializer.ArrayDeserializer;
import org.eclipse.yasson.internal.deserializer.ArrayInstanceCreator;
import org.eclipse.yasson.internal.deserializer.CollectionDeserializer;
import org.eclipse.yasson.internal.deserializer.CollectionInstanceCreator;
import org.eclipse.yasson.internal.deserializer.ContextSwitcher;
import org.eclipse.yasson.internal.deserializer.CyclicReferenceDeserializer;
import org.eclipse.yasson.internal.deserializer.DefaultObjectInstanceCreator;
import org.eclipse.yasson.internal.deserializer.DeferredDeserializer;
import org.eclipse.yasson.internal.deserializer.InheritanceInstanceCreator;
import org.eclipse.yasson.internal.deserializer.JsonbCreatorDeserializer;
import org.eclipse.yasson.internal.deserializer.JustReturn;
import org.eclipse.yasson.internal.deserializer.MapDeserializer;
import org.eclipse.yasson.internal.deserializer.MapInstanceCreator;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;
import org.eclipse.yasson.internal.deserializer.NullCheckDeserializer;
import org.eclipse.yasson.internal.deserializer.ObjectDeserializer;
import org.eclipse.yasson.internal.deserializer.OptionalDeserializer;
import org.eclipse.yasson.internal.deserializer.PositionChecker;
import org.eclipse.yasson.internal.deserializer.RequiredCreatorParameter;
import org.eclipse.yasson.internal.deserializer.UserDefinedDeserializer;
import org.eclipse.yasson.internal.deserializer.ValueSetterDeserializer;
import org.eclipse.yasson.internal.deserializer.types.TypeDeserializers;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.CreatorModel;
import org.eclipse.yasson.internal.model.JsonbCreator;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.model.customization.ClassCustomization;
import org.eclipse.yasson.internal.model.customization.ComponentBoundCustomization;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.model.customization.PropertyCustomization;
import org.eclipse.yasson.internal.model.customization.TypeInheritanceConfiguration;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class DeserializationModelCreator {
    private static final ModelDeserializer<Object> NULL_PROVIDER = (value, context) -> null;
    private static final Map<Class<?>, ModelDeserializer<Object>> DEFAULT_CREATOR_VALUES;
    private static final Set<JsonParser.Event> MAP_KEY_EVENTS;
    private final Map<CachedItem, ModelDeserializer<JsonParser>> models = new ConcurrentHashMap<CachedItem, ModelDeserializer<JsonParser>>();
    private final JsonbContext jsonbContext;
    private final Map<Class<?>, Class<?>> userTypeMapping;

    public DeserializationModelCreator(JsonbContext jsonbContext) {
        this.jsonbContext = jsonbContext;
        this.userTypeMapping = jsonbContext.getConfigProperties().getUserTypeMapping();
    }

    public ModelDeserializer<JsonParser> deserializerChain(Type type2) {
        LinkedList<Type> chain = new LinkedList<Type>();
        ClassModel classModel = this.jsonbContext.getMappingContext().getOrCreateClassModel(ReflectionUtils.getRawType(type2));
        return this.deserializerChain(chain, type2, classModel.getClassCustomization(), classModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelDeserializer<JsonParser> deserializerChain(LinkedList<Type> chain, Type type2, Customization propertyCustomization, ClassModel classModel) {
        if (chain.contains(type2)) {
            return new CyclicReferenceDeserializer(type2);
        }
        try {
            chain.add(type2);
            ModelDeserializer<JsonParser> modelDeserializer = this.deserializerChainInternal(chain, type2, propertyCustomization, classModel);
            return modelDeserializer;
        }
        finally {
            chain.removeLast();
        }
    }

    private ModelDeserializer<JsonParser> deserializerChainInternal(LinkedList<Type> chain, Type type2, Customization propertyCustomization, ClassModel classModel) {
        Class<?> rawType = classModel.getType();
        CachedItem cachedItem = this.createCachedItem(type2, propertyCustomization);
        if (this.models.containsKey(cachedItem)) {
            return this.models.get(cachedItem);
        }
        if (this.userTypeMapping.containsKey(rawType)) {
            Class<?> userTypeRaw = this.userTypeMapping.get(rawType);
            ModelDeserializer<JsonParser> deserializer = this.deserializerChain(userTypeRaw);
            this.models.put(cachedItem, deserializer);
            return deserializer;
        }
        Optional<AdapterBinding> adapterBinding = this.adapterBinding(type2, (ComponentBoundCustomization)((Object)propertyCustomization));
        if (adapterBinding.isPresent()) {
            ClassModel targetModel;
            AdapterBinding adapter = adapterBinding.get();
            Class<?> toType = ReflectionUtils.getRawType(adapter.getToType());
            ModelDeserializer<JsonParser> typeDeserializer = this.typeDeserializer(toType, (targetModel = this.jsonbContext.getMappingContext().getOrCreateClassModel(toType)).getClassCustomization(), JustReturn.instance());
            if (typeDeserializer == null) {
                typeDeserializer = this.deserializerChain(adapter.getToType());
            }
            ModelDeserializer<JsonParser> targetAdapterModel = typeDeserializer;
            AdapterDeserializer adapterDeserializer = new AdapterDeserializer(adapter, JustReturn.instance());
            ModelDeserializer<JsonParser> adapterDeser = (parser, context) -> {
                Object fromJson = targetAdapterModel.deserialize((JsonParser)parser, context);
                return adapterDeserializer.deserialize(fromJson, context);
            };
            this.models.put(cachedItem, adapterDeser);
            return adapterDeser;
        }
        ModelDeserializer<JsonParser> typeDeserializer = this.typeDeserializer(rawType, propertyCustomization, JustReturn.instance());
        if (typeDeserializer != null) {
            this.models.put(cachedItem, typeDeserializer);
            return typeDeserializer;
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            return this.createCollectionDeserializer(cachedItem, rawType, chain, propertyCustomization);
        }
        if (Map.class.isAssignableFrom(rawType)) {
            return this.createMapDeserializer(cachedItem, rawType, chain, propertyCustomization);
        }
        if (rawType.isArray()) {
            return this.createArrayDeserializer(cachedItem, rawType, chain, propertyCustomization);
        }
        if (type2 instanceof GenericArrayType) {
            return this.createGenericArray(cachedItem, rawType, chain, propertyCustomization);
        }
        if (Optional.class.isAssignableFrom(rawType)) {
            return this.createOptionalDeserializer(chain, type2, propertyCustomization, cachedItem);
        }
        return this.createObjectDeserializer(chain, type2, propertyCustomization, classModel, rawType, cachedItem);
    }

    private ModelDeserializer<JsonParser> createObjectDeserializer(LinkedList<Type> chain, Type type2, Customization propertyCustomization, ClassModel classModel, Class<?> rawType, CachedItem cachedItem) {
        ModelDeserializer<JsonParser> instanceCreator;
        ClassCustomization classCustomization = classModel.getClassCustomization();
        Optional<DeserializerBinding<?>> deserializerBinding = this.userDeserializer(type2, (ComponentBoundCustomization)((Object)propertyCustomization));
        if (deserializerBinding.isPresent()) {
            UserDefinedDeserializer user = new UserDefinedDeserializer(deserializerBinding.get().getJsonbDeserializer(), JustReturn.instance(), type2, classCustomization);
            this.models.put(cachedItem, user);
            return user;
        }
        JsonbCreator creator = classCustomization.getCreator();
        boolean hasCreator = creator != null;
        List<String> params = hasCreator ? this.creatorParamsList(creator) : Collections.emptyList();
        Function<String, String> renamer = this.propertyRenamer();
        LinkedHashMap<String, ModelDeserializer<JsonParser>> processors = new LinkedHashMap<String, ModelDeserializer<JsonParser>>();
        HashMap<String, ModelDeserializer<Object>> defaultCreatorValues = new HashMap<String, ModelDeserializer<Object>>();
        for (PropertyModel propertyModel : classModel.getSortedProperties()) {
            if (!propertyModel.isWritable() || params.contains(propertyModel.getReadName())) continue;
            ModelDeserializer<JsonParser> modelDeserializer = this.memberTypeProcessor(chain, propertyModel, hasCreator);
            processors.put(renamer.apply(propertyModel.getReadName()), modelDeserializer);
        }
        for (String s : params) {
            CreatorModel creatorModel = creator.findByName(s);
            ModelDeserializer<JsonParser> modelDeserializer = this.typeProcessor(chain, creatorModel.getType(), creatorModel.getCustomization(), JustReturn.instance());
            String parameterName = renamer.apply(creatorModel.getName());
            processors.put(parameterName, modelDeserializer);
            if (creatorModel.getCustomization().isRequired()) {
                defaultCreatorValues.put(parameterName, new RequiredCreatorParameter(parameterName));
                continue;
            }
            Class<?> rawParamType = ReflectionUtils.getRawType(creatorModel.getType());
            defaultCreatorValues.put(parameterName, DEFAULT_CREATOR_VALUES.getOrDefault(rawParamType, NULL_PROVIDER));
        }
        TypeInheritanceConfiguration typeInheritanceConfiguration = classCustomization.getPolymorphismConfig();
        Set<String> ignoredProperties = this.collectIgnoredProperties(typeInheritanceConfiguration);
        boolean failOnUnknownProperties = this.jsonbContext.getConfigProperties().getConfigFailOnUnknownProperties();
        if (hasCreator) {
            instanceCreator = new JsonbCreatorDeserializer(processors, defaultCreatorValues, creator, rawType, renamer, failOnUnknownProperties, ignoredProperties);
        } else {
            ObjectDeserializer typeWrapper = new ObjectDeserializer(processors, renamer, rawType, failOnUnknownProperties, ignoredProperties);
            instanceCreator = new DefaultObjectInstanceCreator(typeWrapper, rawType, classModel.getDefaultConstructor());
        }
        PositionChecker positionChecker = new PositionChecker(instanceCreator, rawType, JsonParser.Event.START_OBJECT);
        if (typeInheritanceConfiguration != null && !typeInheritanceConfiguration.isInherited()) {
            instanceCreator = new InheritanceInstanceCreator(rawType, this, typeInheritanceConfiguration, positionChecker);
            positionChecker = new PositionChecker(instanceCreator, rawType, JsonParser.Event.START_OBJECT);
        }
        NullCheckDeserializer nullChecker = new NullCheckDeserializer(positionChecker, JustReturn.instance());
        this.models.put(cachedItem, nullChecker);
        return nullChecker;
    }

    private ModelDeserializer<JsonParser> createCollectionDeserializer(CachedItem cachedItem, Class<?> rawType, LinkedList<Type> chain, Customization propertyCustomization) {
        Type type2 = cachedItem.type;
        Object colType = type2 instanceof ParameterizedType ? ((ParameterizedType)type2).getActualTypeArguments()[0] : Object.class;
        colType = ReflectionUtils.resolveType(chain, colType);
        ClassModel classModel = this.jsonbContext.getMappingContext().getOrCreateClassModel(ReflectionUtils.getRawType((Type)colType));
        ModelDeserializer<JsonParser> typeProcessor = this.typeProcessor(chain, (Type)colType, classModel.getClassCustomization(), JustReturn.instance());
        CollectionDeserializer collectionDeserializer = new CollectionDeserializer(typeProcessor);
        CollectionInstanceCreator instanceDeserializer = new CollectionInstanceCreator(collectionDeserializer, type2);
        PositionChecker positionChecker = new PositionChecker((ModelDeserializer<JsonParser>)instanceDeserializer, rawType, JsonParser.Event.START_ARRAY);
        NullCheckDeserializer nullChecker = new NullCheckDeserializer(positionChecker, JustReturn.instance());
        this.models.put(cachedItem, nullChecker);
        return nullChecker;
    }

    private ModelDeserializer<JsonParser> createMapDeserializer(CachedItem cachedItem, Class<?> rawType, LinkedList<Type> chain, Customization propertyCustomization) {
        Type type2 = cachedItem.type;
        Class<Object> keyType = type2 instanceof ParameterizedType ? ((ParameterizedType)type2).getActualTypeArguments()[0] : Object.class;
        Class<Object> valueType = type2 instanceof ParameterizedType ? ((ParameterizedType)type2).getActualTypeArguments()[1] : Object.class;
        ModelDeserializer<JsonParser> keyProcessor = this.typeProcessor(chain, (Type)((Object)keyType), ClassCustomization.empty(), JustReturn.instance(), MAP_KEY_EVENTS);
        ModelDeserializer<JsonParser> valueProcessor = this.typeProcessor(chain, (Type)((Object)valueType), propertyCustomization, JustReturn.instance());
        MapDeserializer mapDeserializer = new MapDeserializer(keyProcessor, valueProcessor);
        MapInstanceCreator mapInstanceCreator = new MapInstanceCreator(mapDeserializer, this.jsonbContext.getConfigProperties(), rawType);
        PositionChecker positionChecker = new PositionChecker((ModelDeserializer<JsonParser>)mapInstanceCreator, rawType, PositionChecker.Checker.CONTAINER);
        NullCheckDeserializer nullChecker = new NullCheckDeserializer(positionChecker, JustReturn.instance());
        this.models.put(cachedItem, nullChecker);
        return nullChecker;
    }

    private ModelDeserializer<JsonParser> createArrayDeserializer(CachedItem cachedItem, Class<?> rawType, LinkedList<Type> chain, Customization propertyCustomization) {
        JsonbConfigProperties configProperties = this.jsonbContext.getConfigProperties();
        if (rawType.equals(byte[].class) && !configProperties.getBinaryDataStrategy().equals("BYTE")) {
            String strategy = configProperties.getBinaryDataStrategy();
            ModelDeserializer<JsonParser> typeProcessor = this.typeProcessor(chain, (Type)((Object)String.class), propertyCustomization, JustReturn.instance());
            ModelDeserializer<JsonParser> base64Deserializer = ArrayInstanceCreator.createBase64Deserializer(strategy, typeProcessor);
            NullCheckDeserializer nullChecker = new NullCheckDeserializer(base64Deserializer, JustReturn.instance());
            this.models.put(cachedItem, nullChecker);
            return nullChecker;
        }
        Class<?> arrayType = rawType.getComponentType();
        ModelDeserializer<JsonParser> typeProcessor = this.typeProcessor(chain, arrayType, propertyCustomization, JustReturn.instance());
        return this.createArrayCommonDeserializer(cachedItem, rawType, arrayType, typeProcessor);
    }

    private ModelDeserializer<JsonParser> createGenericArray(CachedItem cachedItem, Class<?> rawType, LinkedList<Type> chain, Customization propertyCustomization) {
        GenericArrayType type2 = (GenericArrayType)cachedItem.type;
        Class<?> component = ReflectionUtils.getRawType(type2.getGenericComponentType());
        ModelDeserializer<JsonParser> typeProcessor = this.typeProcessor(chain, type2.getGenericComponentType(), propertyCustomization, JustReturn.instance());
        return this.createArrayCommonDeserializer(cachedItem, rawType, component, typeProcessor);
    }

    private ModelDeserializer<JsonParser> createArrayCommonDeserializer(CachedItem cachedItem, Class<?> rawType, Class<?> component, ModelDeserializer<JsonParser> typeProcessor) {
        ArrayDeserializer arrayDeserializer = new ArrayDeserializer(typeProcessor);
        ArrayInstanceCreator arrayInstanceCreator = ArrayInstanceCreator.create(rawType, component, arrayDeserializer);
        PositionChecker positionChecker = new PositionChecker((ModelDeserializer<JsonParser>)arrayInstanceCreator, rawType, JsonParser.Event.START_ARRAY);
        NullCheckDeserializer nullChecker = new NullCheckDeserializer(positionChecker, JustReturn.instance());
        this.models.put(cachedItem, nullChecker);
        return nullChecker;
    }

    private OptionalDeserializer createOptionalDeserializer(LinkedList<Type> chain, Type type2, Customization propertyCustomization, CachedItem cachedItem) {
        Class<Object> colType = type2 instanceof ParameterizedType ? ((ParameterizedType)type2).getActualTypeArguments()[0] : Object.class;
        ModelDeserializer<JsonParser> typeProcessor = this.typeProcessor(chain, (Type)((Object)colType), propertyCustomization, JustReturn.instance());
        OptionalDeserializer optionalDeserializer = new OptionalDeserializer(typeProcessor, JustReturn.instance());
        this.models.put(cachedItem, optionalDeserializer);
        return optionalDeserializer;
    }

    private Set<String> collectIgnoredProperties(TypeInheritanceConfiguration typeInheritanceConfiguration) {
        HashSet<String> ignoredProperties = new HashSet<String>();
        if (typeInheritanceConfiguration != null) {
            for (TypeInheritanceConfiguration current = typeInheritanceConfiguration; current != null; current = current.getParentConfig()) {
                ignoredProperties.add(current.getFieldName());
            }
        }
        return ignoredProperties;
    }

    private Function<String, String> propertyRenamer() {
        boolean isCaseInsensitive = this.jsonbContext.getConfig().getProperty("jsonb.property-naming-strategy").filter(prop -> prop.equals("CASE_INSENSITIVE")).isPresent();
        return isCaseInsensitive ? String::toLowerCase : value -> value;
    }

    private Optional<AdapterBinding> adapterBinding(Type type2, ComponentBoundCustomization classCustomization) {
        return this.jsonbContext.getComponentMatcher().getDeserializeAdapterBinding(type2, classCustomization);
    }

    private Optional<DeserializerBinding<?>> userDeserializer(Type type2, ComponentBoundCustomization classCustomization) {
        return this.jsonbContext.getComponentMatcher().getDeserializerBinding(type2, classCustomization);
    }

    private List<String> creatorParamsList(JsonbCreator creator) {
        return Arrays.stream(creator.getParams()).map(CreatorModel::getName).collect(Collectors.toList());
    }

    private ModelDeserializer<JsonParser> memberTypeProcessor(LinkedList<Type> chain, PropertyModel propertyModel, boolean hasCreator) {
        Type type2 = propertyModel.getPropertyDeserializationType();
        ModelDeserializer<Object> memberDeserializer = new ValueSetterDeserializer(propertyModel.getSetValueHandle());
        if (hasCreator) {
            memberDeserializer = new DeferredDeserializer(memberDeserializer);
        }
        return this.typeProcessor(chain, type2, propertyModel.getCustomization(), memberDeserializer);
    }

    private ModelDeserializer<JsonParser> typeProcessor(LinkedList<Type> chain, Type type2, Customization customization, ModelDeserializer<Object> memberDeserializer) {
        return this.typeProcessor(chain, type2, customization, memberDeserializer, PositionChecker.Checker.VALUES.getEvents());
    }

    private ModelDeserializer<JsonParser> typeProcessor(LinkedList<Type> chain, Type type2, Customization customization, ModelDeserializer<Object> memberDeserializer, Set<JsonParser.Event> events) {
        Type resolved = ReflectionUtils.resolveType(chain, type2);
        Class<?> rawType = ReflectionUtils.getRawType(resolved);
        Optional<DeserializerBinding<?>> deserializerBinding = this.userDeserializer(resolved, (ComponentBoundCustomization)((Object)customization));
        if (deserializerBinding.isPresent()) {
            return new UserDefinedDeserializer(deserializerBinding.get().getJsonbDeserializer(), memberDeserializer, resolved, customization);
        }
        Optional<AdapterBinding> adapterBinding = this.adapterBinding(resolved, (ComponentBoundCustomization)((Object)customization));
        if (adapterBinding.isPresent()) {
            AdapterBinding adapter = adapterBinding.get();
            ModelDeserializer<JsonParser> typeDeserializer = this.typeDeserializer(ReflectionUtils.getRawType(adapter.getToType()), customization, JustReturn.instance(), events);
            if (typeDeserializer == null) {
                typeDeserializer = this.deserializerChain(adapter.getToType());
            }
            ModelDeserializer<JsonParser> targetAdapterModel = typeDeserializer;
            AdapterDeserializer adapterDeserializer = new AdapterDeserializer(adapter, memberDeserializer);
            return (parser, context) -> {
                DeserializationContextImpl newContext = new DeserializationContextImpl(context);
                Object fromJson = targetAdapterModel.deserialize((JsonParser)parser, newContext);
                return adapterDeserializer.deserialize(fromJson, context);
            };
        }
        ModelDeserializer<JsonParser> typeDeserializer = this.typeDeserializer(rawType, customization, memberDeserializer, events);
        if (typeDeserializer == null) {
            Class<?> implClass = this.resolveImplClass(rawType, customization);
            return this.createNewChain(chain, memberDeserializer, implClass, resolved, customization);
        }
        return typeDeserializer;
    }

    private ModelDeserializer<JsonParser> createNewChain(LinkedList<Type> chain, ModelDeserializer<Object> memberDeserializer, Class<?> rawType, Type type2, Customization propertyCustomization) {
        ClassModel classModel = this.jsonbContext.getMappingContext().getOrCreateClassModel(rawType);
        ModelDeserializer<JsonParser> modelDeserializer = this.deserializerChain(chain, type2, propertyCustomization, classModel);
        return new ContextSwitcher(memberDeserializer, modelDeserializer);
    }

    private ModelDeserializer<JsonParser> typeDeserializer(Class<?> rawType, Customization customization, ModelDeserializer<Object> delegate) {
        return this.typeDeserializer(rawType, customization, delegate, PositionChecker.Checker.VALUES.getEvents());
    }

    private ModelDeserializer<JsonParser> typeDeserializer(Class<?> rawType, Customization customization, ModelDeserializer<Object> delegate, Set<JsonParser.Event> events) {
        return TypeDeserializers.getTypeDeserializer(rawType, customization, this.jsonbContext.getConfigProperties(), delegate, events);
    }

    private Class<?> resolveImplClass(Class<?> rawType, Customization customization) {
        if (rawType.isInterface()) {
            Class<?> implementationClass = null;
            if (customization instanceof PropertyCustomization) {
                implementationClass = ((PropertyCustomization)customization).getImplementationClass();
            }
            if (implementationClass == null) {
                implementationClass = this.jsonbContext.getConfigProperties().getUserTypeMapping().get(rawType);
            }
            if (implementationClass != null) {
                if (!rawType.isAssignableFrom(implementationClass)) {
                    throw new JsonbException(Messages.getMessage(MessageKeys.IMPL_CLASS_INCOMPATIBLE, implementationClass, rawType));
                }
                return implementationClass;
            }
        }
        return rawType;
    }

    private CachedItem createCachedItem(Type type2, Customization customization) {
        return new CachedItem(type2, customization.getDeserializeNumberFormatter(), customization.getDeserializeDateFormatter());
    }

    static {
        MAP_KEY_EVENTS = new HashSet<JsonParser.Event>();
        MAP_KEY_EVENTS.add(JsonParser.Event.KEY_NAME);
        MAP_KEY_EVENTS.addAll(PositionChecker.Checker.VALUES.getEvents());
        HashMap<Class<Object>, ModelDeserializer<Object>> tmpValuesMap = new HashMap<Class<Object>, ModelDeserializer<Object>>();
        tmpValuesMap.put(Byte.TYPE, (value, context) -> (byte)0);
        tmpValuesMap.put(Short.TYPE, (value, context) -> (short)0);
        tmpValuesMap.put(Integer.TYPE, (value, context) -> 0);
        tmpValuesMap.put(Long.TYPE, (value, context) -> 0L);
        tmpValuesMap.put(Float.TYPE, (value, context) -> Float.valueOf(0.0f));
        tmpValuesMap.put(Double.TYPE, (value, context) -> 0.0);
        tmpValuesMap.put(Character.TYPE, (value, context) -> Character.valueOf('\u0000'));
        tmpValuesMap.put(Boolean.TYPE, (value, context) -> false);
        tmpValuesMap.put(Optional.class, (value, context) -> Optional.empty());
        tmpValuesMap.put(OptionalInt.class, (value, context) -> OptionalInt.empty());
        tmpValuesMap.put(OptionalLong.class, (value, context) -> OptionalLong.empty());
        tmpValuesMap.put(OptionalDouble.class, (value, context) -> OptionalDouble.empty());
        DEFAULT_CREATOR_VALUES = Map.copyOf(tmpValuesMap);
    }

    private static final class CachedItem {
        private final Type type;
        private final JsonbNumberFormatter numberFormatter;
        private final JsonbDateFormatter dateFormatter;

        CachedItem(Type type2, JsonbNumberFormatter numberFormatter, JsonbDateFormatter dateFormatter) {
            this.type = type2;
            this.numberFormatter = numberFormatter;
            this.dateFormatter = dateFormatter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedItem that = (CachedItem)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.numberFormatter, that.numberFormatter) && Objects.equals(this.dateFormatter, that.dateFormatter);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.numberFormatter, this.dateFormatter);
        }

        public String toString() {
            return "CachedItem{type=" + this.type + ", numberFormatter=" + this.numberFormatter + ", dateFormatter=" + this.dateFormatter + "}";
        }
    }
}

