/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer;

import jakarta.json.stream.JsonParser;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.yasson.internal.DeserializationContextImpl;
import org.eclipse.yasson.internal.InstanceCreator;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.deserializer.CollectionDeserializer;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;

class CollectionInstanceCreator
implements ModelDeserializer<JsonParser> {
    private final CollectionDeserializer delegate;
    private final Type type;
    private final Class<?> clazz;
    private final boolean isEnumSet;

    CollectionInstanceCreator(CollectionDeserializer delegate, Type type2) {
        this.delegate = delegate;
        this.clazz = this.implementationClass(ReflectionUtils.getRawType(type2));
        this.isEnumSet = EnumSet.class.isAssignableFrom(this.clazz);
        this.type = this.isEnumSet ? ((ParameterizedType)type2).getActualTypeArguments()[0] : type2;
    }

    @Override
    public Object deserialize(JsonParser value, DeserializationContextImpl context) {
        Object instance = this.isEnumSet ? EnumSet.noneOf((Class)this.type) : InstanceCreator.createInstance(this.clazz);
        context.setInstance(instance);
        return this.delegate.deserialize(value, context);
    }

    private Class<?> implementationClass(Class<?> type2) {
        if (type2.isInterface()) {
            return this.createInterfaceInstance(type2);
        }
        return type2;
    }

    private Class<?> createInterfaceInstance(Class<?> ifcType) {
        if (List.class.isAssignableFrom(ifcType)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(ifcType)) {
            if (SortedSet.class.isAssignableFrom(ifcType)) {
                return TreeSet.class;
            }
            return HashSet.class;
        }
        if (Queue.class.isAssignableFrom(ifcType)) {
            return ArrayDeque.class;
        }
        if (Collection.class == ifcType) {
            return ArrayList.class;
        }
        return ifcType;
    }
}

