/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.transaction.AbstractSynchronizationListener;
import org.eclipse.persistence.transaction.AbstractTransactionController;
import org.eclipse.persistence.transaction.JTASynchronizationListener;

public class JTATransactionController
extends AbstractTransactionController {
    static final String JNDI_TRANSACTION_MANAGER_NAME = "java:comp/TransactionManager";
    protected static TransactionManager defaultTransactionManager;
    protected TransactionManager transactionManager;
    static String[] codes;

    public JTATransactionController() {
        this.listenerFactory = new JTASynchronizationListener();
        try {
            this.transactionManager = this.acquireTransactionManager();
        }
        catch (Exception ex) {
            throw TransactionException.errorObtainingTransactionManager(ex);
        }
    }

    public JTATransactionController(TransactionManager transactionManager) {
        this.listenerFactory = new JTASynchronizationListener();
        this.transactionManager = transactionManager;
    }

    @Override
    protected void registerSynchronization_impl(AbstractSynchronizationListener listener, Object txn) throws Exception {
        ((Transaction)txn).registerSynchronization(listener);
    }

    @Override
    protected Object getTransaction_impl() throws Exception {
        return this.getTransactionManager().getTransaction();
    }

    @Override
    protected Object getTransactionKey_impl(Object transaction) throws Exception {
        return transaction;
    }

    @Override
    protected Object getTransactionStatus_impl() throws Exception {
        return this.getTransactionManager().getStatus();
    }

    @Override
    protected void beginTransaction_impl() throws Exception {
        this.getTransactionManager().begin();
    }

    @Override
    protected void commitTransaction_impl() throws Exception {
        this.getTransactionManager().commit();
    }

    @Override
    protected void rollbackTransaction_impl() throws Exception {
        this.getTransactionManager().rollback();
    }

    @Override
    protected void markTransactionForRollback_impl() throws Exception {
        this.getTransactionManager().setRollbackOnly();
    }

    @Override
    protected boolean canBeginTransaction_impl(Object status) {
        return this.getIntStatus(status) == 6;
    }

    @Override
    protected boolean canCommitTransaction_impl(Object status) {
        return this.getIntStatus(status) == 0;
    }

    @Override
    protected boolean canRollbackTransaction_impl(Object status) {
        return this.getIntStatus(status) == 0;
    }

    @Override
    protected boolean canIssueSQLToDatabase_impl(Object status) {
        int stat = this.getIntStatus(status);
        return stat == 0 || stat == 7;
    }

    @Override
    protected boolean canMergeUnitOfWork_impl(Object status) {
        return this.getIntStatus(status) == 3;
    }

    @Override
    public boolean isRolledBack_impl(Object status) {
        return this.getIntStatus(status) == 4;
    }

    protected TransactionManager acquireTransactionManager() throws Exception {
        if (defaultTransactionManager != null) {
            return defaultTransactionManager;
        }
        try {
            return (TransactionManager)this.jndiLookup(JNDI_TRANSACTION_MANAGER_NAME);
        }
        catch (TransactionException ex) {
            AbstractSessionLog.getLog().log(6, "transaction", "jta_tm_lookup_failure", (Object)ex.getLocalizedMessage());
            return null;
        }
    }

    protected int getIntStatus(Object status) {
        return (Integer)status;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager mgr) {
        this.transactionManager = mgr;
    }

    @Override
    protected String statusToString_impl(Object status) {
        int statusCode = this.getIntStatus(status);
        return codes[statusCode];
    }

    public static TransactionManager getDefaultTransactionManager() {
        return defaultTransactionManager;
    }

    public static void setDefaultTransactionManager(TransactionManager defaultTransactionManager) {
        JTATransactionController.defaultTransactionManager = defaultTransactionManager;
    }

    static {
        codes = new String[]{"STATUS_ACTIVE", "MARKED_ROLLBACK", "PREPARED", "COMMITTED", "ROLLEDBACK", "UNKNOWN", "NO_TRANSACTION", "PREPARING", "COMMITTING", "ROLLING_BACK"};
    }
}

