/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.util.List;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

public abstract class TableValidationException
extends Exception {
    private final String table;
    private final ValidationFailure failure;

    private TableValidationException(String message, String table, ValidationFailure type2) {
        super(message);
        this.table = table;
        this.failure = type2;
    }

    public String getTable() {
        return this.table;
    }

    public ValidationFailure getFailure() {
        return this.failure;
    }

    public abstract <T extends TableValidationException> T unwrap(Class<T> var1);

    public static enum ValidationFailure {
        MISSING_TABLE(MissingTable.class),
        MISSING_COLUMNS(MissingColumns.class),
        SURPLUS_COLUMNS(SurplusColumns.class),
        DIFFERENT_COLUMNS(DifferentColumns.class);

        private final Class<? extends TableValidationException> exceptionClass;

        private ValidationFailure(Class<? extends TableValidationException> exceptionClass) {
            this.exceptionClass = exceptionClass;
        }

        public Class<? extends TableValidationException> exceptionClass() {
            return this.exceptionClass;
        }
    }

    public static final class DifferentColumns
    extends TableValidationException {
        private final List<Difference> differences;

        DifferentColumns(String table, List<Difference> columns) {
            super(ExceptionLocalization.buildMessage("schema_validation_table_different_columns", new String[]{table}), table, ValidationFailure.DIFFERENT_COLUMNS);
            this.differences = columns;
        }

        public List<Difference> getDifferences() {
            return this.differences;
        }

        @Override
        public <T extends TableValidationException> T unwrap(Class<T> cls) {
            if (cls == DifferentColumns.class) {
                return (T)((TableValidationException)cls.cast(this));
            }
            throw new IllegalArgumentException(String.format("Cannot cast this TableValidationException.DifferentColumns implementation as %s", cls.getName()));
        }

        public static enum Type {
            TYPE_DIFFERENCE(TypeDifference.class),
            NULLABLE_DIFFERENCE(NullableDifference.class);

            private final Class<? extends Difference> differenceClass;

            private Type(Class<? extends Difference> differenceClass) {
                this.differenceClass = differenceClass;
            }

            public Class<? extends Difference> differenceClass() {
                return this.differenceClass;
            }
        }

        public static class NullableDifference
        extends Difference {
            private final boolean modelNullable;
            private final boolean dbNullable;

            NullableDifference(String columnName, boolean modelNullable, boolean dbNullable) {
                super(columnName, Type.NULLABLE_DIFFERENCE);
                this.dbNullable = dbNullable;
                this.modelNullable = modelNullable;
            }

            @Override
            public <T extends Difference> T unwrap(Class<T> cls) {
                if (cls == NullableDifference.class) {
                    return (T)((Difference)cls.cast(this));
                }
                throw new IllegalArgumentException(String.format("Cannot cast this Difference.NullableDifference implementation as %s", cls.getName()));
            }

            public boolean isDbNullable() {
                return this.dbNullable;
            }

            public boolean isModelNullable() {
                return this.modelNullable;
            }
        }

        public static class TypeDifference
        extends Difference {
            private final String modelValue;
            private final String dbValue;

            TypeDifference(String columnName, String modelValue, String dbValue) {
                super(columnName, Type.TYPE_DIFFERENCE);
                this.dbValue = dbValue;
                this.modelValue = modelValue;
            }

            @Override
            public <T extends Difference> T unwrap(Class<T> cls) {
                if (cls == TypeDifference.class) {
                    return (T)((Difference)cls.cast(this));
                }
                throw new IllegalArgumentException(String.format("Cannot cast this Difference.TypeDifference implementation as %s", cls.getName()));
            }

            public String getDbValue() {
                return this.dbValue;
            }

            public String getModelValue() {
                return this.modelValue;
            }
        }

        public static abstract class Difference {
            private final String columnName;
            private final Type type;

            private Difference(String columnName, Type type2) {
                this.columnName = columnName;
                this.type = type2;
            }

            public abstract <T extends Difference> T unwrap(Class<T> var1);

            public String getColumnName() {
                return this.columnName;
            }

            public Type getType() {
                return this.type;
            }
        }
    }

    public static final class SurplusColumns
    extends TableValidationException {
        private final List<String> columns;

        SurplusColumns(String table, List<String> columns) {
            super(ExceptionLocalization.buildMessage("schema_validation_table_surplus_columns", new String[]{table}), table, ValidationFailure.SURPLUS_COLUMNS);
            this.columns = columns;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        @Override
        public <T extends TableValidationException> T unwrap(Class<T> cls) {
            if (cls == SurplusColumns.class) {
                return (T)((TableValidationException)cls.cast(this));
            }
            throw new IllegalArgumentException(String.format("Cannot cast this TableValidationException.SurplusColumns implementation as %s", cls.getName()));
        }
    }

    public static final class MissingColumns
    extends TableValidationException {
        private final List<String> columns;

        MissingColumns(String table, List<String> columns) {
            super(ExceptionLocalization.buildMessage("schema_validation_table_missing_columns", new String[]{table}), table, ValidationFailure.MISSING_COLUMNS);
            this.columns = columns;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        @Override
        public <T extends TableValidationException> T unwrap(Class<T> cls) {
            if (cls == MissingColumns.class) {
                return (T)((TableValidationException)cls.cast(this));
            }
            throw new IllegalArgumentException(String.format("Cannot cast this TableValidationException.MissingColumns implementation as %s", cls.getName()));
        }
    }

    public static final class MissingTable
    extends TableValidationException {
        MissingTable(String table) {
            super(ExceptionLocalization.buildMessage("schema_validation_missing_table", new String[]{table}), table, ValidationFailure.MISSING_TABLE);
        }

        @Override
        public <T extends TableValidationException> T unwrap(Class<T> cls) {
            if (cls == MissingTable.class) {
                return (T)((TableValidationException)cls.cast(this));
            }
            throw new IllegalArgumentException(String.format("Cannot cast this TableValidationException.MissingTable implementation as %s", cls.getName()));
        }
    }
}

