/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class FieldDefinition
implements Serializable,
Cloneable {
    protected String name;
    protected Class<?> type;
    protected String typeName;
    protected DatabaseField field;
    protected String typeDefinition;
    protected int size;
    protected int subSize;
    protected boolean shouldAllowNull;
    protected boolean isIdentity;
    protected boolean isPrimaryKey;
    protected boolean isUnique;
    protected String additional;
    protected String constraint;
    protected String foreignKeyFieldName;
    protected String comment;

    public FieldDefinition() {
        this.name = "";
        this.size = 0;
        this.subSize = 0;
        this.shouldAllowNull = true;
        this.isIdentity = false;
        this.isPrimaryKey = false;
        this.isUnique = false;
    }

    public FieldDefinition(String name, Class<?> type2) {
        this.name = name;
        this.type = type2;
        this.size = 0;
        this.subSize = 0;
        this.shouldAllowNull = true;
        this.isIdentity = false;
        this.isPrimaryKey = false;
        this.isUnique = false;
    }

    public FieldDefinition(String name, Class<?> type2, int size) {
        this();
        this.name = name;
        this.type = type2;
        this.size = size;
    }

    public FieldDefinition(String name, Class<?> type2, int size, int subSize) {
        this();
        this.name = name;
        this.type = type2;
        this.size = size;
        this.subSize = subSize;
    }

    public FieldDefinition(String name, String typeName) {
        this();
        this.name = name;
        this.typeName = typeName;
    }

    public void appendDBCreateString(Writer writer, AbstractSession session, TableDefinition table) {
        this.appendDBString(writer, session, table, null);
    }

    public boolean shouldPrintFieldNullClause(FieldTypeDefinition fieldType) {
        return this.shouldAllowNull && fieldType.shouldAllowNull();
    }

    private void appendDBString(Writer writer, AbstractSession session, TableDefinition table, String alterKeyword) throws ValidationException {
        try {
            writer.write(this.name);
            writer.write(" ");
            if (alterKeyword != null) {
                writer.write(alterKeyword);
                writer.write(" ");
            }
            if (this.getTypeDefinition() != null) {
                writer.write(this.typeDefinition);
            } else {
                DatabasePlatform platform = session.getPlatform();
                FieldTypeDefinition fieldType = DatabaseObjectDefinition.getFieldTypeDefinition(platform, this.type, this.typeName);
                String qualifiedName = table.getFullName() + "." + this.name;
                boolean shouldPrintFieldIdentityClause = this.isIdentity && platform.shouldPrintFieldIdentityClause(session, qualifiedName);
                platform.printFieldTypeSize(writer, this, fieldType, shouldPrintFieldIdentityClause);
                if (shouldPrintFieldIdentityClause) {
                    platform.printFieldIdentityClause(writer);
                }
                if (this.shouldPrintFieldNullClause(fieldType)) {
                    platform.printFieldNullClause(writer);
                } else {
                    platform.printFieldNotNullClause(writer);
                }
                if (this.isUnique) {
                    if (platform.supportsUniqueColumns()) {
                        if (!this.isPrimaryKey || table.getPrimaryKeyFieldNames().size() > 1) {
                            platform.printFieldUnique(writer, shouldPrintFieldIdentityClause);
                        } else {
                            this.setUnique(false);
                            session.log(6, "ddl", "removing_unique_constraint", qualifiedName);
                        }
                    } else {
                        this.setUnique(false);
                        String constraintName = table.buildUniqueKeyConstraintName(table.getName(), table.getFields().indexOf(this), platform.getMaxUniqueKeyNameSize());
                        table.addUniqueKeyConstraint(constraintName, this.name);
                    }
                }
                if (this.constraint != null) {
                    writer.write(" " + this.constraint);
                }
                if (this.additional != null) {
                    writer.write(" " + this.additional);
                }
            }
            if (this.comment != null) {
                writer.write(" /* ");
                writer.write(this.comment);
                writer.write(" */ ");
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void appendTypeString(Writer writer, AbstractSession session) throws ValidationException {
        FieldTypeDefinition fieldType = DatabaseObjectDefinition.getFieldTypeDefinition(session, this.type, this.typeName);
        try {
            writer.write(this.name);
            writer.write(" ");
            writer.write(fieldType.getName());
            if (fieldType.isSizeAllowed() && (this.size != 0 || fieldType.isSizeRequired())) {
                writer.write("(");
                if (this.size == 0) {
                    writer.write(Integer.toString(fieldType.getDefaultSize()));
                } else {
                    writer.write(Integer.toString(this.size));
                }
                if (this.subSize != 0) {
                    writer.write(",");
                    writer.write(Integer.toString(this.subSize));
                } else if (fieldType.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(Integer.toString(fieldType.getDefaultSubSize()));
                }
                writer.write(")");
            }
            if (this.additional != null) {
                writer.write(" " + this.additional);
            }
            if (this.comment != null) {
                writer.write(" /* ");
                writer.write(this.comment);
                writer.write(" */ ");
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
    }

    public String getAdditional() {
        return this.additional;
    }

    public String getComment() {
        return this.comment;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getForeignKeyFieldName() {
        return this.foreignKeyFieldName;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseField getDatabaseField() {
        return this.field;
    }

    public int getSize() {
        return this.size;
    }

    public int getSubSize() {
        return this.subSize;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setAdditional(String string) {
        this.additional = string;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setConstraint(String string) {
        this.constraint = string;
    }

    public void setForeignKeyFieldName(String foreignKeyFieldName) {
        this.foreignKeyFieldName = foreignKeyFieldName;
    }

    public void setIsIdentity(boolean value) {
        this.isIdentity = value;
        if (value) {
            this.setShouldAllowNull(false);
        }
    }

    public void setIsPrimaryKey(boolean value) {
        this.isPrimaryKey = value;
        if (value) {
            this.setShouldAllowNull(false);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDatabaseField(DatabaseField field) {
        this.field = field;
    }

    public void setShouldAllowNull(boolean value) {
        this.shouldAllowNull = value;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSubSize(int subSize) {
        this.subSize = subSize;
    }

    public void setType(Class<?> type2) {
        this.type = type2;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setTypeDefinition(String typeDefinition) {
        this.typeDefinition = typeDefinition;
    }

    public void setUnique(boolean value) {
        this.isUnique = value;
    }

    public boolean shouldAllowNull() {
        return this.shouldAllowNull;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + "(" + String.valueOf(this.getType()) + "))";
    }
}

