/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionPair;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.AbstractUnmarshalRecord;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

public class XMLField
extends DatabaseField
implements Field<XMLConversionManager, NamespaceResolver> {
    private NamespaceResolver namespaceResolver;
    private QName schemaType;
    private XPathFragment xPathFragment;
    private XPathFragment lastXPathFragment;
    private boolean isCDATA = false;
    private boolean isRequired = false;
    private boolean isInitialized = false;
    private boolean nestedArray = false;
    private boolean usesSingleNode;
    protected HashMap userXMLTypes;
    protected HashMap userJavaTypes;
    protected boolean isTypedTextField = false;
    protected QName leafElementType;

    public XMLField() {
    }

    public XMLField(String xPath) {
        super(xPath, new DatabaseTable());
    }

    @Override
    public void initialize() {
        if (null != this.xPathFragment) {
            this.initializeXPathFragment(this.xPathFragment);
        }
        this.isInitialized = true;
    }

    private void initializeXPathFragment(XPathFragment xPathFragment) {
        XPathFragment nextXPathFragment;
        String localName;
        XPathPredicate predicate = xPathFragment.getPredicate();
        if (null != predicate) {
            this.initializeXPathFragment(predicate.getXPathFragment());
        }
        if ((localName = xPathFragment.getLocalName()) != null && !localName.equals("") && null == xPathFragment.getNamespaceURI()) {
            if (xPathFragment.hasNamespace()) {
                if (null == this.namespaceResolver) {
                    throw XMLMarshalException.namespaceNotFound(xPathFragment.getShortName());
                }
                String uri = this.namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
                if (null == uri && null != xPathFragment.getPrefix()) {
                    throw XMLMarshalException.namespaceNotFound(xPathFragment.getShortName());
                }
                xPathFragment.setNamespaceURI(uri);
            } else if (!xPathFragment.isAttribute() && null != this.namespaceResolver) {
                xPathFragment.setNamespaceURI(this.namespaceResolver.getDefaultNamespaceURI());
            }
        }
        if (null != (nextXPathFragment = xPathFragment.getNextFragment())) {
            this.initializeXPathFragment(nextXPathFragment);
        }
    }

    @Override
    public String getXPath() {
        return this.getName();
    }

    @Override
    public void setXPath(String xPath) {
        this.setName(xPath);
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    @Override
    public void setNamespaceResolver(NamespaceResolver newNamespaceResolver) {
        this.namespaceResolver = newNamespaceResolver;
    }

    @Override
    public void setUsesSingleNode(boolean usesSingleNode) {
        this.usesSingleNode = usesSingleNode;
    }

    @Override
    public boolean usesSingleNode() {
        return this.usesSingleNode;
    }

    @Override
    public void setSchemaType(QName value) {
        this.schemaType = value;
    }

    @Override
    public QName getSchemaType() {
        return this.schemaType;
    }

    @Override
    public boolean isTypedTextField() {
        return this.isTypedTextField;
    }

    @Override
    public void setIsTypedTextField(boolean value) {
        this.isTypedTextField = value;
    }

    @Override
    public boolean isSelfField() {
        if (null == this.xPathFragment) {
            return false;
        }
        return this.xPathFragment.isSelfFragment();
    }

    @Override
    public boolean isUnionField() {
        return false;
    }

    @Override
    public void setName(String xPath, String startDelimiter, String endDelimiter) {
        super.setName(xPath, null, null);
        if (this.hasPath(xPath)) {
            this.buildFragments(xPath);
        } else {
            XPathFragment<XMLField> xPathFragment = new XPathFragment<XMLField>(xPath.intern());
            xPathFragment.setXMLField(this);
            this.setXPathFragment(xPathFragment);
            this.setLastXPathFragment(xPathFragment);
        }
    }

    @Override
    public void setName(String xPath) {
        this.setName(xPath, null, null);
    }

    private boolean hasPath(String xpathString) {
        return xpathString != null && xpathString.indexOf(47) != -1;
    }

    private void buildFragments(String xpathString) {
        StringTokenizer st = new StringTokenizer(xpathString, "/", true);
        int i = 0;
        XPathFragment<XMLField> currentXPathFragment = null;
        XPathFragment<XMLField> nextXPathFragment = null;
        while (st.hasMoreTokens()) {
            Object next = st.nextToken();
            if (null != next) {
                if ("/".equals(next)) {
                    if (false != i) continue;
                    next = "/" + st.nextToken();
                }
                if (((String)next).contains("[") && !((String)next).contains("]")) {
                    StringBuilder sb = new StringBuilder((String)next);
                    while (st.hasMoreTokens()) {
                        String more = st.nextToken();
                        sb.append(more);
                        if (!more.contains("]")) continue;
                    }
                    next = sb.toString().intern();
                } else {
                    next = ((String)next).intern();
                }
                nextXPathFragment = new XPathFragment<XMLField>((String)next);
                if (0 == i) {
                    this.setXPathFragment(nextXPathFragment);
                } else {
                    currentXPathFragment.setNextFragment(nextXPathFragment);
                    if (nextXPathFragment.isAttribute() || nextXPathFragment.nameIsText()) {
                        currentXPathFragment.setHasText(true);
                    }
                }
                nextXPathFragment.setXMLField(this);
                currentXPathFragment = nextXPathFragment;
                ++i;
            }
            this.setLastXPathFragment(currentXPathFragment);
        }
    }

    @Override
    public XPathFragment getXPathFragment() {
        return this.xPathFragment;
    }

    public void setXPathFragment(XPathFragment xPathFragment) {
        this.xPathFragment = xPathFragment;
    }

    @Override
    public XPathFragment getLastXPathFragment() {
        return this.lastXPathFragment;
    }

    public void setLastXPathFragment(XPathFragment lastXPathFragment) {
        this.lastXPathFragment = lastXPathFragment;
    }

    public Class<?> getJavaClass(QName qname) {
        return this.getJavaClass(qname, XMLConversionManager.getDefaultXMLManager());
    }

    @Override
    public Class<?> getJavaClass(QName qname, ConversionManager conversionManager) {
        Class theClass;
        if (this.userXMLTypes != null && (theClass = (Class)this.userXMLTypes.get(qname)) != null) {
            return theClass;
        }
        return conversionManager.javaType(qname);
    }

    public QName getXMLType(Class<?> javaClass) {
        return this.getXMLType(javaClass, XMLConversionManager.getDefaultXMLManager());
    }

    @Override
    public QName getXMLType(Class<?> javaClass, ConversionManager conversionManager) {
        QName theQName;
        if (this.userJavaTypes != null && (theQName = (QName)this.userJavaTypes.get(javaClass)) != null) {
            return theQName;
        }
        return conversionManager.schemaType(javaClass);
    }

    private HashMap getUserJavaTypes() {
        if (this.userJavaTypes == null) {
            this.userJavaTypes = new HashMap();
        }
        return this.userJavaTypes;
    }

    private HashMap getUserXMLTypes() {
        if (this.userXMLTypes == null) {
            this.userXMLTypes = new HashMap();
        }
        return this.userXMLTypes;
    }

    public ArrayList getUserXMLTypesForDeploymentXML() {
        if (this.userXMLTypes != null) {
            ArrayList<XMLConversionPair> types = new ArrayList<XMLConversionPair>(this.userXMLTypes.size());
            for (Map.Entry entry : this.userXMLTypes.entrySet()) {
                XMLConversionPair pair = new XMLConversionPair((QName)entry.getKey(), ((Class)entry.getValue()).getName());
                types.add(pair);
            }
            return types;
        }
        return null;
    }

    public void setUserXMLTypesForDeploymentXML(ArrayList pairs) throws Exception {
        if (!pairs.isEmpty()) {
            this.userXMLTypes = new HashMap();
            for (XMLConversionPair pair : pairs) {
                if (pair.getXmlType() == null || pair.getJavaType() == null) continue;
                this.userXMLTypes.put(pair.getXmlType(), Class.forName(pair.getJavaType()));
            }
        }
    }

    public ArrayList getUserJavaTypesForDeploymentXML() {
        if (this.userJavaTypes != null) {
            ArrayList<XMLConversionPair> types = new ArrayList<XMLConversionPair>(this.userJavaTypes.size());
            for (Map.Entry entry : this.userJavaTypes.entrySet()) {
                XMLConversionPair pair = new XMLConversionPair((QName)entry.getValue(), ((Class)entry.getKey()).getName());
                types.add(pair);
            }
            return types;
        }
        return null;
    }

    public void setUserJavaTypesForDeploymentXML(ArrayList pairs) throws Exception {
        if (!pairs.isEmpty()) {
            this.userJavaTypes = new HashMap();
            for (XMLConversionPair pair : pairs) {
                if (pair.getXmlType() == null || pair.getJavaType() == null) continue;
                this.userJavaTypes.put(Class.forName(pair.getJavaType()), pair.getXmlType());
            }
        }
    }

    @Override
    public Object convertValueBasedOnSchemaType(Object value, XMLConversionManager xmlConversionManager, AbstractUnmarshalRecord record) {
        if (this.schemaType != null) {
            if (XMLConstants.QNAME_QNAME.equals(this.schemaType)) {
                return xmlConversionManager.buildQNameFromString((String)value, record);
            }
            Class<?> fieldType = this.getType();
            if (fieldType == null) {
                fieldType = this.getJavaClass(this.schemaType, xmlConversionManager);
            }
            return xmlConversionManager.convertObject(value, fieldType, this.schemaType);
        }
        return value;
    }

    public void addXMLConversion(QName qname, Class<?> javaClass) {
        this.getUserXMLTypes().put(qname, javaClass);
    }

    public void addJavaConversion(Class<?> javaClass, QName qname) {
        this.getUserJavaTypes().put(javaClass, qname);
    }

    public void addConversion(QName qname, Class<?> javaClass) {
        this.addJavaConversion(javaClass, qname);
        this.addXMLConversion(qname, javaClass);
    }

    public void removeXMLConversion(QName qname) {
        this.getUserXMLTypes().remove(qname);
    }

    public void removeJavaConversion(Class<?> javaClass) {
        this.getUserJavaTypes().remove(javaClass);
    }

    public void removeConversion(QName qname, Class<?> javaClass) {
        this.removeJavaConversion(javaClass);
        this.removeXMLConversion(qname);
    }

    public void setLeafElementType(QName type2) {
        this.leafElementType = type2;
        if (this.hasLastXPathFragment()) {
            this.getLastXPathFragment().setLeafElementType(type2);
        }
    }

    @Override
    public QName getLeafElementType() {
        if (this.lastXPathFragment != null) {
            return this.lastXPathFragment.getLeafElementType();
        }
        return this.leafElementType;
    }

    @Override
    public boolean hasLastXPathFragment() {
        return this.lastXPathFragment != null;
    }

    @Override
    public QName getSchemaTypeForValue(Object value, CoreAbstractSession session) {
        if (this.leafElementType != null) {
            return this.leafElementType;
        }
        if (this.isTypedTextField) {
            if (CoreClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(value.getClass())) {
                return ((XMLGregorianCalendar)value).getXMLSchemaType();
            }
            if (CoreClassConstants.DURATION.isAssignableFrom(value.getClass())) {
                ConversionManager conversionManager = (ConversionManager)session.getDatasourcePlatform().getConversionManager();
                return this.getXMLType(CoreClassConstants.DURATION, conversionManager);
            }
            ConversionManager conversionManager = (ConversionManager)session.getDatasourcePlatform().getConversionManager();
            return this.getXMLType(value.getClass(), conversionManager);
        }
        return this.schemaType;
    }

    @Override
    public void setIsCDATA(boolean CDATA) {
        this.isCDATA = CDATA;
    }

    @Override
    public boolean isCDATA() {
        return this.isCDATA;
    }

    @Override
    public boolean isSchemaType(QName schemaType) {
        if (this.getSchemaType() == null) {
            return false;
        }
        return this.getSchemaType().equals(schemaType);
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public boolean equals(Object object) {
        try {
            if (!this.isInitialized) {
                return super.equals(object);
            }
            if (this == object) {
                return true;
            }
            XMLField xmlField = (XMLField)object;
            if (!this.xPathFragment.equals(xmlField.getXPathFragment())) {
                return false;
            }
            XPathFragment xpf = this.xPathFragment;
            XPathFragment xpf2 = xmlField.getXPathFragment();
            while (xpf.getNextFragment() != null) {
                if ((xpf = xpf.getNextFragment()).equals(xpf2 = xpf2.getNextFragment())) continue;
                return false;
            }
            return null == xpf2.getNextFragment();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public void setNestedArray(boolean nestedArray) {
        this.nestedArray = nestedArray;
    }

    @Override
    public boolean isNestedArray() {
        return this.nestedArray;
    }

    @Override
    public int hashCode() {
        if (null == this.xPathFragment && null == this.xPathFragment.getXPath()) {
            return 1;
        }
        return this.xPathFragment.getXPath().replace((CharSequence)(this.xPathFragment.getPrefix() != null ? this.xPathFragment.getPrefix() + this.xPathFragment.getNamespaceSeparator() : ""), "").hashCode();
    }
}

