/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.persistence.jpa.jpql.tools.NumericTypeComparator;
import org.eclipse.persistence.jpa.jpql.tools.TypeHelper;
import org.eclipse.persistence.jpa.jpql.tools.resolver.Resolver;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;

public class NumericResolver
extends Resolver {
    private final Collection<Resolver> resolvers;

    public NumericResolver(Resolver parent, Collection<Resolver> typeResolvers) {
        super(parent);
        this.resolvers = typeResolvers;
    }

    public NumericResolver(Resolver parent, Resolver resolver) {
        this(parent, Collections.singleton(resolver));
    }

    @Override
    protected IType buildType() {
        ArrayList<IType> types = new ArrayList<IType>(this.resolvers.size());
        TypeHelper helper = this.getTypeHelper();
        IType unresolvableType = helper.unknownType();
        for (Resolver typeResolver : this.resolvers) {
            IType type2 = typeResolver.getType();
            if (type2 == unresolvableType) continue;
            if (!helper.isNumericType(type2)) {
                type2 = helper.objectType();
            }
            types.add(type2);
        }
        if (types.isEmpty()) {
            return helper.unknownType();
        }
        types.sort(new NumericTypeComparator(helper));
        return (IType)types.get(0);
    }

    @Override
    protected ITypeDeclaration buildTypeDeclaration() {
        return this.getType().getTypeDeclaration();
    }
}

