/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ValueReadQuery;

public abstract class QueryHandler {
    protected DatabaseQuery databaseQuery;

    public DatabaseQuery getDatabaseQuery() {
        return this.databaseQuery;
    }

    public void setDatabaseQuery(DatabaseQuery databaseQuery) {
        this.databaseQuery = databaseQuery;
    }

    public void validate(XRServiceAdapter xrService, QueryOperation queryOperation) {
    }

    public void initialize(XRServiceAdapter xrService, QueryOperation queryOperation) {
        this.initializeDatabaseQuery(xrService, queryOperation);
        this.initializeCall(xrService, queryOperation, this.getDatabaseQuery());
        this.initializeArguments(xrService, queryOperation, this.getDatabaseQuery());
    }

    public void initializeDatabaseQuery(XRServiceAdapter xrService, QueryOperation queryOperation) {
        DatabaseQuery databaseQueryToInitialize;
        if (queryOperation.hasResponse()) {
            QName type2 = queryOperation.getResult().getType();
            databaseQueryToInitialize = queryOperation.isCollection() ? (queryOperation.isSimpleXMLFormat() || xrService.descriptorsByQName.containsKey(type2) && xrService.getORSession().getClassDescriptorForAlias(xrService.descriptorsByQName.get(type2).getAlias()).isAggregateDescriptor() && !xrService.getORSession().getClassDescriptorForAlias(xrService.descriptorsByQName.get(type2).getAlias()).isObjectRelationalDataTypeDescriptor() ? new DataReadQuery() : (!xrService.descriptorsByQName.containsKey(type2) ? new DataReadQuery() : new ReadAllQuery(xrService.getTypeClass(type2)))) : (queryOperation.isSimpleXMLFormat() || xrService.descriptorsByQName.containsKey(type2) && xrService.getORSession().getClassDescriptorForAlias(xrService.descriptorsByQName.get(type2).getAlias()).isAggregateDescriptor() && !xrService.getORSession().getClassDescriptorForAlias(xrService.descriptorsByQName.get(type2).getAlias()).isObjectRelationalDataTypeDescriptor() ? new DataReadQuery() : (!xrService.descriptorsByQName.containsKey(type2) ? new ValueReadQuery() : new ReadObjectQuery(xrService.getTypeClass(type2))));
        } else {
            databaseQueryToInitialize = new DataModifyQuery();
        }
        databaseQueryToInitialize.bindAllParameters();
        this.setDatabaseQuery(databaseQueryToInitialize);
    }

    public void initializeCall(XRServiceAdapter xrService, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
    }

    public void initializeArguments(XRServiceAdapter xrService, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
        for (int i = 0; i < queryOperation.getParameters().size(); ++i) {
            Parameter p;
            String name;
            Parameter o = queryOperation.getParameters().get(i);
            if (o instanceof Parameter && (name = (p = o).getName()) != null && !name.isEmpty()) {
                databaseQuery.addArgument(name);
                continue;
            }
            String s = Integer.toString(i + 1);
            databaseQuery.addArgument(s);
        }
    }
}

