/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.platform.database.oracle;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import oracle.sql.TIMESTAMPLTZ;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.PlatformWrapper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPHelper;

public class TIMESTAMPLTZWrapper
implements Serializable,
PlatformWrapper {
    final ZonedDateTime zonedDateTime;
    final boolean isLtzTimestampInGmt;
    private final Map<Class<?>, Function<TIMESTAMPLTZWrapper, ?>> UNWRAP = this.initUnwrappers();

    public TIMESTAMPLTZWrapper(ZonedDateTime zonedDateTime, boolean isLtzTimestampInGmt) throws SQLException {
        this.zonedDateTime = zonedDateTime;
        this.isLtzTimestampInGmt = isLtzTimestampInGmt;
    }

    public TIMESTAMPLTZ builtTimestampLtz(Connection connection) {
        try {
            return new TIMESTAMPLTZ(connection, this.zonedDateTime);
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception);
        }
    }

    public LocalTime toLocalTime() {
        return this.zonedDateTime.toLocalTime();
    }

    public LocalDate toLocalDate() {
        return this.zonedDateTime.toLocalDate();
    }

    public LocalDateTime toLocalDateTime() {
        return this.zonedDateTime.toLocalDateTime();
    }

    public OffsetTime toOffsetTime() {
        return this.zonedDateTime.toOffsetDateTime().toOffsetTime();
    }

    public OffsetDateTime toOffsetDateTime() {
        return this.zonedDateTime.toOffsetDateTime();
    }

    public Calendar toCalendar() {
        return TIMESTAMPHelper.buildCalendar(this);
    }

    public Timestamp getTimestamp() {
        return Timestamp.valueOf(this.zonedDateTime.toLocalDateTime());
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.zonedDateTime.getZone());
    }

    public ZoneId getZoneId() {
        return this.zonedDateTime.getZone();
    }

    public boolean isLtzTimestampInGmt() {
        return this.isLtzTimestampInGmt;
    }

    Map<Class<?>, Function<TIMESTAMPLTZWrapper, ?>> initUnwrappers() {
        HashMap unwrappers = new HashMap();
        unwrappers.put(TIMESTAMPLTZWrapper.class, wrapper -> wrapper);
        unwrappers.put(LocalDate.class, TIMESTAMPLTZWrapper::toLocalDate);
        unwrappers.put(LocalTime.class, TIMESTAMPLTZWrapper::toLocalTime);
        unwrappers.put(LocalDateTime.class, TIMESTAMPLTZWrapper::toLocalDateTime);
        unwrappers.put(OffsetTime.class, TIMESTAMPLTZWrapper::toOffsetTime);
        unwrappers.put(OffsetDateTime.class, TIMESTAMPLTZWrapper::toOffsetDateTime);
        unwrappers.put(Timestamp.class, TIMESTAMPLTZWrapper::getTimestamp);
        unwrappers.put(TimeZone.class, TIMESTAMPLTZWrapper::getTimeZone);
        unwrappers.put(ZoneId.class, TIMESTAMPLTZWrapper::getZoneId);
        unwrappers.put(Calendar.class, TIMESTAMPLTZWrapper::toCalendar);
        return unwrappers;
    }

    public <T> T unwrap(Class<T> type2) {
        Function<TIMESTAMPLTZWrapper, ?> unwrapper = this.UNWRAP.get(type2);
        if (unwrapper != null) {
            return type2.cast(unwrapper.apply(this));
        }
        throw new IllegalArgumentException("Unwrapping of TIMESTAMPLTZWrapper as " + type2.getName() + " is not supported");
    }
}

