/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DOMUnmarshaller
implements PlatformUnmarshaller {
    private XMLParser parser;
    private XMLUnmarshaller xmlUnmarshaller;
    private boolean isResultAlwaysXMLRoot;
    private boolean disableSecureProcessing = false;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private Map<String, Boolean> parserFeatures;
    private boolean isWhitespacePreserving;
    private int validationMode = 0;
    private Schema schema;
    private Object[] schemas;
    private boolean shouldReset = true;

    public DOMUnmarshaller(XMLUnmarshaller xmlUnmarshaller, Map<String, Boolean> parserFeatures) {
        this.parserFeatures = parserFeatures == null ? new HashMap() : parserFeatures;
        this.xmlUnmarshaller = xmlUnmarshaller;
    }

    private XMLParser getParser() {
        if (this.parser == null || this.shouldReset) {
            XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            xmlPlatform.setDisableSecureProcessing(this.isSecureProcessingDisabled());
            this.parser = xmlPlatform.newXMLParser(this.parserFeatures);
            this.parser.setNamespaceAware(true);
            if (this.errorHandler != null) {
                this.parser.setErrorHandler(this.errorHandler);
            }
            if (this.entityResolver != null) {
                this.parser.setEntityResolver(this.entityResolver);
            }
            if (this.schemas != null) {
                try {
                    this.parser.setXMLSchemas(this.schemas);
                }
                catch (XMLPlatformException e) {
                    throw XMLMarshalException.errorSettingSchemas(e, this.schemas);
                }
            }
            if (this.schema != null) {
                this.parser.setXMLSchema(this.schema);
            }
            this.parser.setValidationMode(this.validationMode);
            this.parser.setWhitespacePreserving(this.isWhitespacePreserving);
            this.shouldReset = false;
        }
        return this.parser;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        if (this.parser != null) {
            this.parser.setEntityResolver(entityResolver);
        }
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        if (this.parser != null) {
            this.parser.setErrorHandler(errorHandler);
        }
    }

    @Override
    public int getValidationMode() {
        return this.validationMode;
    }

    @Override
    public void setValidationMode(int validationMode) {
        this.validationMode = validationMode;
        if (this.parser != null) {
            this.parser.setValidationMode(validationMode);
        }
    }

    @Override
    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.isWhitespacePreserving = isWhitespacePreserving;
        if (this.parser != null) {
            this.parser.setWhitespacePreserving(isWhitespacePreserving);
        }
    }

    @Override
    public void setSchemas(Object[] schemas) {
        this.schemas = schemas;
        if (this.parser != null) {
            try {
                this.parser.setXMLSchemas(schemas);
            }
            catch (XMLPlatformException e) {
                throw XMLMarshalException.errorSettingSchemas(e, schemas);
            }
        }
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
        if (this.parser != null) {
            this.parser.setXMLSchema(schema);
        }
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Object unmarshal(File file) {
        return this.unmarshal(file, null);
    }

    @Override
    public Object unmarshal(File file, Class<?> clazz) {
        if (!this.xmlUnmarshaller.isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.getParser().parse(file);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputStream inputStream) {
        return this.unmarshal(inputStream, null);
    }

    @Override
    public Object unmarshal(InputStream inputStream, Class<?> clazz) {
        return this.unmarshal(new InputSource(inputStream), clazz);
    }

    @Override
    public Object unmarshal(InputSource inputSource) {
        return this.unmarshal(inputSource, null);
    }

    @Override
    public Object unmarshal(InputSource inputSource, Class<?> clazz) {
        if (!this.xmlUnmarshaller.isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.getParser().parse(inputSource);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Node node) {
        return this.unmarshal(node, null);
    }

    @Override
    public Object unmarshal(Node node, Class<?> clazz) {
        if (!this.xmlUnmarshaller.isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element), clazz);
    }

    @Override
    public Object unmarshal(Reader reader) {
        return this.unmarshal(reader, null);
    }

    @Override
    public Object unmarshal(Reader reader, Class<?> clazz) {
        return this.unmarshal(new InputSource(reader), clazz);
    }

    @Override
    public Object unmarshal(Source source) {
        return this.unmarshal(source, null);
    }

    @Override
    public Object unmarshal(Source source, Class<?> clazz) {
        if (!this.xmlUnmarshaller.isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.getParser().parse(source);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(URL url) {
        return this.unmarshal(url, null);
    }

    @Override
    public Object unmarshal(URL url, Class<?> clazz) {
        if (!this.xmlUnmarshaller.isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.getParser().parse(url);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(XMLReader xmlReader, InputSource inputSource) {
        return this.unmarshal(xmlReader, inputSource, null);
    }

    @Override
    public Object unmarshal(XMLReader xmlReader, InputSource inputSource, Class<?> clazz) {
        if (!this.xmlUnmarshaller.isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
            xmlReader.setContentHandler(saxDocumentBuilder);
            xmlReader.parse(inputSource);
            Object object = this.xmlToObject(new DOMRecord(saxDocumentBuilder.getDocument()), clazz);
            return object;
        }
        catch (IOException | SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    public Object xmlToObject(DOMRecord xmlRecord) throws XMLMarshalException {
        return this.xmlToObject(xmlRecord, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object xmlToObject(DOMRecord xmlRow, Class<?> referenceClass) throws XMLMarshalException {
        try {
            Object object;
            String xmlEncoding = "UTF-8";
            String xmlVersion = "1.0";
            try {
                xmlEncoding = xmlRow.getDocument().getXmlEncoding() != null ? xmlRow.getDocument().getXmlEncoding() : xmlEncoding;
                xmlVersion = xmlRow.getDocument().getXmlVersion() != null ? xmlRow.getDocument().getXmlVersion() : xmlVersion;
            }
            catch (Exception exception) {
                // empty catch block
            }
            XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
            if (referenceClass != null && (XMLConversionManager.getDefaultJavaTypes().get(referenceClass) != null || CoreClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(referenceClass) || CoreClassConstants.DURATION.isAssignableFrom(referenceClass))) {
                String nodeVal;
                try {
                    Text rootTxt = (Text)xmlRow.getDOM().getFirstChild();
                    nodeVal = rootTxt.getNodeValue();
                }
                catch (Exception ex) {
                    nodeVal = null;
                }
                Object obj = ((DatabaseSession)xmlContext.getSession()).getDatasourcePlatform().getConversionManager().convertObject(nodeVal, referenceClass);
                XMLRoot xmlRoot = new XMLRoot();
                xmlRoot.setObject(obj);
                String lName = xmlRow.getDOM().getLocalName();
                if (lName == null) {
                    lName = xmlRow.getDOM().getNodeName();
                }
                xmlRoot.setLocalName(lName);
                xmlRoot.setNamespaceURI(xmlRow.getDOM().getNamespaceURI());
                xmlRoot.setEncoding(xmlEncoding);
                xmlRoot.setVersion(xmlVersion);
                XMLRoot xMLRoot = xmlRoot;
                return xMLRoot;
            }
            Descriptor descriptor = null;
            CoreAbstractSession readSession = null;
            boolean shouldWrap = true;
            if (referenceClass == null) {
                QName rootQName = new QName(xmlRow.getNamespaceURI(), xmlRow.getLocalName());
                descriptor = xmlContext.getDescriptor(rootQName);
                if (null == descriptor) {
                    String type2 = ((Element)xmlRow.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    if (null != type2) {
                        XPathFragment typeFragment = new XPathFragment(type2);
                        namespaceURI = xmlRow.resolveNamespacePrefix(typeFragment.getPrefix());
                        typeFragment.setNamespaceURI(namespaceURI);
                        descriptor = xmlContext.getDescriptorByGlobalType(typeFragment);
                    }
                } else if (null != descriptor.getDefaultRootElementField() && !descriptor.isResultAlwaysXMLRoot() && !this.xmlUnmarshaller.isResultAlwaysXMLRoot()) {
                    String descLocalName = descriptor.getDefaultRootElementField().getXPathFragment().getLocalName();
                    String localName = xmlRow.getDOM().getLocalName();
                    if (localName == null) {
                        localName = xmlRow.getDOM().getNodeName();
                    }
                    namespaceURI = xmlRow.getDOM().getNamespaceURI();
                    if (descLocalName != null && descLocalName.equals(localName)) {
                        String descUri = descriptor.getDefaultRootElementField().getXPathFragment().getNamespaceURI();
                        if (namespaceURI == null && descUri == null || namespaceURI != null && namespaceURI.isEmpty() && descUri == null || namespaceURI != null && namespaceURI.equals(descUri)) {
                            shouldWrap = false;
                        }
                    }
                }
                if (null == descriptor) {
                    throw XMLMarshalException.noDescriptorWithMatchingRootElement(rootQName.toString());
                }
                readSession = xmlContext.getSession(descriptor.getJavaClass());
            } else {
                readSession = xmlContext.getSession((Class)referenceClass);
                descriptor = (Descriptor)readSession.getDescriptor(referenceClass);
                if (descriptor == null) {
                    throw XMLMarshalException.descriptorNotFoundInProject(referenceClass.getName());
                }
            }
            Object object2 = null;
            if (null == xmlRow.getDOM().getAttributes().getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "nil")) {
                xmlRow.setUnmarshaller(this.xmlUnmarshaller);
                xmlRow.setDocPresPolicy(xmlContext.getDocumentPreservationPolicy((AbstractSession)readSession));
                XMLObjectBuilder objectBuilder = (XMLObjectBuilder)descriptor.getObjectBuilder();
                ReadObjectQuery query = new ReadObjectQuery();
                query.setReferenceClass(referenceClass);
                query.setSession((AbstractSession)readSession);
                object2 = objectBuilder.buildObject(query, xmlRow, null);
                xmlRow.resolveReferences(readSession, this.xmlUnmarshaller.getIDResolver());
            }
            String elementNamespaceUri = xmlRow.getDOM().getNamespaceURI();
            String elementLocalName = xmlRow.getDOM().getLocalName();
            if (elementLocalName == null) {
                elementLocalName = xmlRow.getDOM().getNodeName();
            }
            String elementPrefix = xmlRow.getDOM().getPrefix();
            if (shouldWrap || descriptor.isResultAlwaysXMLRoot() || this.isResultAlwaysXMLRoot) {
                object = descriptor.wrapObjectInXMLRoot(object2, elementNamespaceUri, elementLocalName, elementPrefix, xmlEncoding, xmlVersion, this.isResultAlwaysXMLRoot, true, this.xmlUnmarshaller);
                return object;
            }
            object = object2;
            return object;
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    @Override
    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.isResultAlwaysXMLRoot = alwaysReturnRoot;
    }

    @Override
    public void mediaTypeChanged() {
    }

    @Override
    public final boolean isSecureProcessingDisabled() {
        return this.disableSecureProcessing;
    }

    @Override
    public final void setDisableSecureProcessing(boolean disableSecureProcessing) {
        this.shouldReset = this.disableSecureProcessing ^ disableSecureProcessing;
        this.disableSecureProcessing = disableSecureProcessing;
    }
}

