/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.LogicalOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.MapKeyNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class DotNode
extends LogicalOperatorNode
implements AliasableNode {
    private Object enumConstant;

    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.addAttribute(this.resolveAttribute(), this.generateExpression(context));
            reportQuery.dontRetrievePrimaryKeys();
        }
    }

    @Override
    public Node qualifyAttributeAccess(ParseTreeContext context) {
        if (this.getLeft() != null) {
            this.setLeft(this.getLeft().qualifyAttributeAccess(context));
        }
        return this;
    }

    @Override
    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        String name = ((AttributeNode)this.right).getAttributeName();
        Node leftMost = this.getLeftMostNode();
        if (this.isDeclaredVariable(leftMost, context)) {
            Node path;
            this.left.validate(context);
            this.checkNavigation(this.left, context);
            Object type2 = null;
            if (this.left.isVariableNode() && (path = context.pathForVariable(((VariableNode)this.left).getVariableName())) != null) {
                type2 = path.getType();
                type2 = typeHelper.resolveAttribute(type2, name);
            }
            if (type2 == null) {
                type2 = typeHelper.resolveAttribute(this.left.getType(), name);
            }
            if (type2 == null) {
                throw JPQLException.unknownAttribute(context.getQueryInfo(), this.right.getLine(), this.right.getColumn(), name, typeHelper.getTypeName(this.left.getType()));
            }
            if (this.right.isAttributeNode()) {
                type2 = ((AttributeNode)this.right).computeActualType(type2, typeHelper);
                ((AttributeNode)this.right).checkForQueryKey(this.left.getType(), typeHelper);
            }
            this.setType(type2);
            this.right.setType(type2);
        } else {
            String typeName = this.left.getAsString();
            Object type3 = this.resolveEnumTypeName(typeName, typeHelper);
            if (type3 != null && typeHelper.isEnumType(type3)) {
                this.enumConstant = typeHelper.resolveEnumConstant(type3, name);
                if (this.enumConstant == null) {
                    throw JPQLException.invalidEnumLiteral(context.getQueryInfo(), this.right.getLine(), this.right.getColumn(), typeName, name);
                }
            } else {
                throw JPQLException.aliasResolutionException(context.getQueryInfo(), leftMost.getLine(), leftMost.getColumn(), leftMost.getAsString());
            }
            this.setType(type3);
            this.right.setType(type3);
        }
    }

    private void checkNavigation(Node node, ParseTreeContext context) {
        Object type2;
        TypeHelper typeHelper = context.getTypeHelper();
        if (!(typeHelper.isEntityClass(type2 = node.getType()) || typeHelper.isEmbeddable(type2) || typeHelper.isEnumType(type2))) {
            throw JPQLException.invalidNavigation(context.getQueryInfo(), node.getLine(), node.getColumn(), this.getAsString(), node.getAsString(), typeHelper.getTypeName(type2));
        }
        if (node.isDotNode()) {
            Node left = node.getLeft();
            AttributeNode right = (AttributeNode)node.getRight();
            if (typeHelper.isCollectionValuedRelationship(left.getType(), right.getAttributeName())) {
                throw JPQLException.invalidCollectionNavigation(context.getQueryInfo(), right.getLine(), right.getColumn(), this.getAsString(), right.getAttributeName());
            }
        }
    }

    private boolean isDeclaredVariable(Node node, ParseTreeContext context) {
        if (node.isVariableNode()) {
            String name = ((VariableNode)node).getCanonicalVariableName();
            return context.isVariable(name);
        }
        return false;
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        Node right = this.getRight();
        if (this.enumConstant != null) {
            return new ConstantExpression(this.enumConstant, new ExpressionBuilder());
        }
        Expression whereClause = this.getLeft().generateExpression(context);
        if (right.isAttributeNode()) {
            ((AttributeNode)right).setMapping(this.resolveMapping(context));
        }
        whereClause = right.addToExpression(whereClause, context);
        if (this.alias != null) {
            context.addExpression(whereClause, this.alias);
        }
        return whereClause;
    }

    @Override
    public boolean isDotNode() {
        return true;
    }

    public boolean endsWithDirectToField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        return mapping != null && mapping.isDirectToFieldMapping();
    }

    public Class<?> getTypeOfDirectToField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        if (mapping != null && mapping.isDirectToFieldMapping()) {
            return mapping.getAttributeClassification();
        }
        return null;
    }

    public Object getTypeForMapKey(ParseTreeContext context) {
        Object type2 = null;
        String name = ((AttributeNode)this.right).getAttributeName();
        Node leftMost = this.getLeftMostNode();
        if (this.isDeclaredVariable(leftMost, context)) {
            type2 = context.getTypeHelper().resolveMapKey(this.left.getType(), name);
        }
        return type2;
    }

    public boolean endsWithCollectionField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        return mapping != null && mapping.isCollectionMapping();
    }

    @Override
    public String resolveAttribute() {
        return ((AttributeNode)this.getRight()).getAttributeName();
    }

    @Override
    public DatabaseMapping resolveMapping(GenerationContext context) {
        Class<?> leftClass = this.getLeft().resolveClass(context);
        return this.getRight().resolveMapping(context, leftClass);
    }

    @Override
    public Class<?> resolveClass(GenerationContext context) {
        Class<?> leftClass = this.getLeft().resolveClass(context);
        return this.getRight().resolveClass(context, leftClass);
    }

    @Override
    public String getAsString() {
        return this.left.getAsString() + "." + this.right.getAsString();
    }

    public Node getLeftMostNode() {
        if (this.left.isDotNode()) {
            return ((DotNode)this.left).getLeftMostNode();
        }
        if (this.left.isMapKeyNode()) {
            return ((MapKeyNode)this.left).getLeftMostNode();
        }
        return this.left;
    }

    public Node getRightMostNode() {
        if (this.right.isDotNode()) {
            return ((DotNode)this.right).getRightMostNode();
        }
        return this.right;
    }

    private Object resolveEnumTypeName(String name, TypeHelper helper) {
        int index;
        Object type2 = helper.resolveTypeName((String)name);
        if (type2 == null && (index = ((String)name).lastIndexOf(46)) != -1) {
            name = ((String)name).substring(0, index) + "$" + ((String)name).substring(index + 1);
            type2 = helper.resolveTypeName((String)name);
        }
        return type2;
    }

    @Override
    public boolean isAliasableNode() {
        return true;
    }
}

