/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.tables.CheckConstraintMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.IndexMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.UniqueConstraintMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class TableMetadata
extends ORMetadata {
    private DatabaseTable m_databaseTable = new DatabaseTable();
    private List<IndexMetadata> m_indexes = new ArrayList<IndexMetadata>();
    private List<UniqueConstraintMetadata> m_uniqueConstraints = new ArrayList<UniqueConstraintMetadata>();
    private List<CheckConstraintMetadata> m_checkConstraints = new ArrayList<CheckConstraintMetadata>();
    private String m_name;
    private String m_schema;
    private String m_catalog;
    private String m_creationSuffix;
    private String m_comment;
    private String m_options;

    public TableMetadata() {
        super("<table>");
    }

    public TableMetadata(MetadataAnnotation table, MetadataAccessor accessor) {
        super(table, accessor);
        if (table != null) {
            this.m_name = table.getAttributeString("name");
            this.m_schema = table.getAttributeString("schema");
            this.m_catalog = table.getAttributeString("catalog");
            this.m_comment = table.getAttributeString("comment");
            this.m_options = table.getAttributeString("options");
            for (Object uniqueConstraint : table.getAttributeArray("uniqueConstraints")) {
                this.m_uniqueConstraints.add(new UniqueConstraintMetadata((MetadataAnnotation)uniqueConstraint, accessor));
            }
            for (Object index : table.getAttributeArray("indexes")) {
                this.m_indexes.add(new IndexMetadata((MetadataAnnotation)index, accessor));
            }
            for (Object checkConstraint : table.getAttributeArray("check")) {
                this.m_checkConstraints.add(new CheckConstraintMetadata((MetadataAnnotation)checkConstraint, accessor));
            }
        }
    }

    protected TableMetadata(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof TableMetadata) {
            TableMetadata table = (TableMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, table.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_schema, table.getSchema())) {
                return false;
            }
            if (!this.valuesMatch(this.m_catalog, table.getCatalog())) {
                return false;
            }
            if (!this.valuesMatch(this.m_creationSuffix, table.getCreationSuffix())) {
                return false;
            }
            if (!this.valuesMatch(this.m_indexes, table.getIndexes())) {
                return false;
            }
            if (!this.valuesMatch(this.m_comment, table.getComment())) {
                return false;
            }
            if (!this.valuesMatch(this.m_options, table.getOptions())) {
                return false;
            }
            if (!this.valuesMatch(this.m_checkConstraints, table.getCheckConstraints())) {
                return false;
            }
            return this.valuesMatch(this.m_uniqueConstraints, table.getUniqueConstraints());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_indexes != null ? this.m_indexes.hashCode() : 0);
        result = 31 * result + (this.m_uniqueConstraints != null ? this.m_uniqueConstraints.hashCode() : 0);
        result = 31 * result + (this.m_checkConstraints != null ? this.m_checkConstraints.hashCode() : 0);
        result = 31 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        result = 31 * result + (this.m_comment != null ? this.m_comment.hashCode() : 0);
        result = 31 * result + (this.m_options != null ? this.m_options.hashCode() : 0);
        result = 31 * result + (this.m_schema != null ? this.m_schema.hashCode() : 0);
        result = 31 * result + (this.m_catalog != null ? this.m_catalog.hashCode() : 0);
        result = 31 * result + (this.m_creationSuffix != null ? this.m_creationSuffix.hashCode() : 0);
        return result;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getCatalogContext() {
        return "metadata_default_table_catalog";
    }

    public String getCreationSuffix() {
        return this.m_creationSuffix;
    }

    public List<CheckConstraintMetadata> getCheckConstraints() {
        return this.m_checkConstraints;
    }

    public String getComment() {
        return this.m_comment;
    }

    public DatabaseTable getDatabaseTable() {
        return this.m_databaseTable;
    }

    public List<IndexMetadata> getIndexes() {
        return this.m_indexes;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNameContext() {
        return "metadata_default_table_name";
    }

    public String getOptions() {
        return this.m_options;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getSchemaContext() {
        return "metadata_default_table_schema";
    }

    public List<UniqueConstraintMetadata> getUniqueConstraints() {
        return this.m_uniqueConstraints;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_indexes, accessibleObject);
        this.initXMLObjects(this.m_uniqueConstraints, accessibleObject);
        this.initXMLObjects(this.m_checkConstraints, accessibleObject);
    }

    public void processCheckConstraints() {
        for (CheckConstraintMetadata checkConstraint : this.m_checkConstraints) {
            checkConstraint.process(this.m_databaseTable);
        }
    }

    public void processComment() {
        this.m_databaseTable.setComment(this.m_comment);
    }

    public void processCreationSuffix() {
        this.m_databaseTable.setCreationSuffix(this.m_creationSuffix);
    }

    public void processIndexes() {
        for (IndexMetadata index : this.m_indexes) {
            index.process(this.m_databaseTable);
        }
    }

    public void processForeignKey() {
    }

    public void processOptions() {
        if (this.m_creationSuffix == null || this.m_creationSuffix.isEmpty()) {
            this.m_databaseTable.setCreationSuffix(this.m_options);
        }
    }

    public void processUniqueConstraints() {
        for (UniqueConstraintMetadata uniqueConstraint : this.m_uniqueConstraints) {
            if (uniqueConstraint.hasName() && this.m_databaseTable.getUniqueConstraints().containsKey(uniqueConstraint.getName())) {
                throw ValidationException.multipleUniqueConstraintsWithSameNameSpecified(uniqueConstraint.getName(), this.getName(), this.getLocation());
            }
            this.m_databaseTable.addUniqueConstraints(uniqueConstraint.getName(), uniqueConstraint.getColumnNames());
        }
    }

    public void setFullyQualifiedTableName(String fullyQualifiedTableName) {
        this.m_databaseTable.setPossiblyQualifiedName(fullyQualifiedTableName, Helper.getDefaultStartDatabaseDelimiter(), Helper.getDefaultEndDatabaseDelimiter());
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void setCreationSuffix(String creationSuffix) {
        this.m_creationSuffix = creationSuffix;
    }

    public void setCheckConstraints(List<CheckConstraintMetadata> checkConstraints) {
        this.m_checkConstraints = checkConstraints;
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    public void setDatabaseTable(DatabaseTable databaseTable) {
        this.m_databaseTable = databaseTable;
    }

    public void setIndexes(List<IndexMetadata> indexes) {
        this.m_indexes = indexes;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setOptions(String options) {
        this.m_options = options;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setUniqueConstraints(List<UniqueConstraintMetadata> uniqueConstraints) {
        this.m_uniqueConstraints = uniqueConstraints;
    }

    public void setUseDelimiters(boolean useDelimiters) {
        this.m_databaseTable.setUseDelimiters(useDelimiters);
    }
}

