/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.PersistenceException;
import jakarta.persistence.SchemaManager;
import jakarta.persistence.SchemaValidationException;
import java.util.Locale;
import java.util.Map;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.ValidationFailure;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.tools.schemaframework.TableValidationException;

class SchemaManagerImpl
implements SchemaManager {
    private final org.eclipse.persistence.tools.schemaframework.SchemaManager schemaManager;
    final Map<String, ?> props;

    SchemaManagerImpl(DatabaseSessionImpl session, Map<String, ?> props) {
        this.schemaManager = new org.eclipse.persistence.tools.schemaframework.SchemaManager(session);
        this.props = props;
    }

    @Override
    public void create(boolean createSchemas) {
        if (createSchemas) {
            this.schemaManager.createDefaultTables(true);
        }
    }

    @Override
    public void drop(boolean dropSchemas) {
        if (dropSchemas) {
            this.schemaManager.dropDefaultTables();
        }
    }

    @Override
    public void validate() throws SchemaValidationException {
        ValidationFailure failures = new ValidationFailure();
        String mode = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.schema-validation.mode", this.props, "simple").toLowerCase(Locale.ROOT);
        boolean full = "full".equals(mode);
        if (!this.schemaManager.validateDefaultTables(failures, true, full)) {
            throw new SchemaValidationException(ExceptionLocalization.buildMessage("schema_validation_failed"), failures.result().toArray(new TableValidationException[0]));
        }
    }

    @Override
    public void truncate() {
        try {
            this.schemaManager.truncateDefaultTables(false);
        }
        catch (EclipseLinkException ex) {
            throw new PersistenceException(ex.getMessage(), ex);
        }
    }
}

