/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FindOption;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.eclipse.persistence.internal.jpa.OptionUtils;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

class FindOptionUtils
extends OptionUtils {
    FindOptionUtils() {
    }

    static OptionUtils.Options parse(FindOption ... options) {
        return OptionsBuilder.build(null, options);
    }

    static OptionUtils.Options parse(Map<String, Object> properties, FindOption ... options) {
        return OptionsBuilder.build(properties, options);
    }

    private static final class OptionsBuilder
    extends OptionUtils.OptionsBuilder {
        private static final Map<Class<? extends FindOption>, BiConsumer<OptionsBuilder, FindOption>> ACTIONS = OptionsBuilder.initActions();

        private static Map<Class<? extends FindOption>, BiConsumer<OptionsBuilder, FindOption>> initActions() {
            HashMap<Class<? extends FindOption>, BiConsumer<OptionsBuilder, FindOption>> actions2 = new HashMap<Class<? extends FindOption>, BiConsumer<OptionsBuilder, FindOption>>(8);
            actions2.put(LockModeType.class, OptionsBuilder::lockModeType);
            actions2.put(CacheRetrieveMode.class, OptionsBuilder::cacheRetrieveMode);
            actions2.put(CacheStoreMode.class, OptionsBuilder::cacheStoreMode);
            actions2.put(PessimisticLockScope.class, OptionsBuilder::pessimisticLockScope);
            actions2.put(Timeout.class, OptionsBuilder::timeout);
            return actions2;
        }

        private OptionsBuilder(Map<String, Object> properties) {
            super(properties);
        }

        private static void lockModeType(OptionsBuilder builder, FindOption lockModeType) {
            builder.setLockModeType((LockModeType)lockModeType);
        }

        private static void cacheRetrieveMode(OptionsBuilder builder, FindOption cacheRetrieveMode) {
            builder.putProperty("jakarta.persistence.cache.retrieveMode", cacheRetrieveMode);
        }

        private static void cacheStoreMode(OptionsBuilder builder, FindOption cacheStoreMode) {
            builder.putProperty("jakarta.persistence.cache.storeMode", cacheStoreMode);
        }

        private static void pessimisticLockScope(OptionsBuilder builder, FindOption cacheStoreMode) {
            builder.putProperty("jakarta.persistence.lock.scope", cacheStoreMode);
        }

        private static void timeout(OptionsBuilder builder, FindOption timeout) {
            builder.putProperty("eclipselink.query.timeout.unit", (Object)TimeUnit.MILLISECONDS);
            builder.putProperty("jakarta.persistence.query.timeout", ((Timeout)timeout).milliseconds());
        }

        private static OptionUtils.Options build(Map<String, Object> properties, FindOption ... options) {
            OptionsBuilder builder = new OptionsBuilder(properties);
            for (FindOption option : options) {
                BiConsumer<OptionsBuilder, FindOption> action = ACTIONS.get(option.getClass());
                if (action != null) {
                    action.accept(builder, option);
                    continue;
                }
                if (option instanceof Timeout) {
                    OptionsBuilder.timeout(builder, option);
                    continue;
                }
                throw new PersistenceException(ExceptionLocalization.buildMessage("find_option_class_unknown", new String[]{option.getClass().getName()}));
            }
            return new OptionUtils.Options(builder.getLockModeType(), Collections.unmodifiableMap(builder.getProperties()));
        }
    }
}

