/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dbws;

import jakarta.activation.DataHandler;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.dbws.DBWSAdapter;
import org.eclipse.persistence.internal.dbws.SOAPAttachmentHandler;
import org.eclipse.persistence.internal.dbws.SOAPResponse;
import org.eclipse.persistence.internal.dbws.SOAPResponseClassLoader;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.foundation.AbstractColumnMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.w3c.dom.Node;

public class SOAPResponseWriter {
    protected DBWSAdapter dbwsAdapter;
    protected Map<String, XMLDescriptor> resultDescriptors = new HashMap<String, XMLDescriptor>();
    public static final QName RECEIVER_QNAME = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver");
    public static final QName SERVER_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");

    public SOAPResponseWriter(DBWSAdapter dbwsAdapter) {
        this.dbwsAdapter = dbwsAdapter;
    }

    public void initialize() {
        SOAPResponseClassLoader loader = new SOAPResponseClassLoader(Thread.currentThread().getContextClassLoader());
        NamespaceResolver nr = new NamespaceResolver();
        nr.put("srvc", this.dbwsAdapter.getExtendedSchema().getTargetNamespace());
        for (Operation op : this.dbwsAdapter.getOperationsList()) {
            String className = op.getName() + "_Response";
            Class<?> opClass = loader.buildClass(className);
            XMLDescriptor descriptor = new XMLDescriptor();
            descriptor.setDefaultRootElement("srvc:" + op.getName() + "Response");
            descriptor.setNamespaceResolver(nr);
            descriptor.setJavaClass(opClass);
            if (op instanceof QueryOperation) {
                QueryOperation queryOperation = (QueryOperation)op;
                if (queryOperation.isSimpleXMLFormat()) {
                    XMLAnyObjectMapping mapping = new XMLAnyObjectMapping();
                    mapping.setUseXMLRoot(true);
                    mapping.setAttributeName("result");
                    mapping.setXPath("srvc:result");
                    descriptor.addMapping(mapping);
                    mapping.initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                } else if (queryOperation.isAttachment()) {
                    Attachment attachment = queryOperation.getResult().getAttachment();
                    XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
                    mapping.setAttributeName("result");
                    mapping.setXPath("srvc:result");
                    mapping.setSwaRef(true);
                    mapping.setShouldInlineBinaryData(false);
                    mapping.setMimeType(attachment.getMimeType());
                    descriptor.addMapping(mapping);
                } else {
                    XMLDescriptor typeDescriptor;
                    QName type2 = queryOperation.getResult().getType();
                    String localElement = type2.getLocalPart();
                    Set<Map.Entry<String, ComplexType>> entrySet = this.dbwsAdapter.getSchema().getTopLevelComplexTypes().entrySet();
                    for (Map.Entry<String, ComplexType> me : entrySet) {
                        if (!me.getValue().getName().equals(type2.getLocalPart())) continue;
                        localElement = me.getKey();
                        break;
                    }
                    if ((typeDescriptor = this.dbwsAdapter.getDescriptorsByQName().get(type2)) != null) {
                        if (queryOperation.isCollection()) {
                            mapping = new XMLCompositeCollectionMapping();
                            mapping.setAttributeName("result");
                            ((AggregateMapping)mapping).setReferenceClass(typeDescriptor.getJavaClass());
                            ((AbstractCompositeCollectionMapping)mapping).useCollectionClass(ArrayList.class);
                            ((XMLCompositeCollectionMapping)mapping).setXPath("srvc:result/" + localElement);
                            descriptor.getNamespaceResolver().setDefaultNamespaceURI(typeDescriptor.getNamespaceResolver().getDefaultNamespaceURI());
                            descriptor.addMapping(mapping);
                            ((XMLCompositeCollectionMapping)mapping).initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                        } else {
                            mapping = new XMLCompositeObjectMapping();
                            mapping.setAttributeName("result");
                            ((AggregateMapping)mapping).setReferenceClass(typeDescriptor.getJavaClass());
                            ((XMLCompositeObjectMapping)mapping).setXPath("srvc:result/" + localElement);
                            descriptor.getNamespaceResolver().setDefaultNamespaceURI(typeDescriptor.getNamespaceResolver().getDefaultNamespaceURI());
                            descriptor.addMapping(mapping);
                            ((XMLCompositeObjectMapping)mapping).initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                        }
                    } else if (type2.equals(new QName("http://www.w3.org/2001/XMLSchema", "any"))) {
                        mapping = new XMLAnyObjectMapping();
                        mapping.setAttributeName("result");
                        ((XMLAnyObjectMapping)mapping).setXPath("srvc:result");
                        descriptor.addMapping(mapping);
                    } else if (type2.equals(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"))) {
                        mapping = new XMLBinaryDataMapping();
                        mapping.setAttributeName("result");
                        ((XMLBinaryDataMapping)mapping).setXPath("srvc:result");
                        ((XMLBinaryDataMapping)mapping).setShouldInlineBinaryData(true);
                        ((XMLField)((AbstractColumnMapping)mapping).getField()).setSchemaType(type2);
                        descriptor.addMapping(mapping);
                    } else {
                        mapping = new XMLDirectMapping();
                        mapping.setAttributeName("result");
                        ((XMLDirectMapping)mapping).setXPath("srvc:result/text()");
                        descriptor.addMapping(mapping);
                    }
                }
            }
            this.dbwsAdapter.getOXSession().getProject().addDescriptor(descriptor);
            ((DatabaseSessionImpl)this.dbwsAdapter.getOXSession()).initializeDescriptorIfSessionAlive(descriptor);
            this.dbwsAdapter.getXMLContext().storeXMLDescriptorByQName(descriptor);
            this.resultDescriptors.put(op.getName(), descriptor);
        }
    }

    public SOAPMessage generateResponse(Operation op, boolean useSOAP12, Exception e) throws SOAPException {
        MessageFactory messageFactory = null;
        messageFactory = useSOAP12 ? MessageFactory.newInstance((String)"SOAP 1.2 Protocol") : MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage();
        message.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        message.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        SOAPBody body = message.getSOAPPart().getEnvelope().getBody();
        QName faultCodeQName = null;
        faultCodeQName = useSOAP12 ? RECEIVER_QNAME : SERVER_QNAME;
        body.addFault(faultCodeQName, op.getName() + " failed: " + String.valueOf(e));
        return message;
    }

    public SOAPMessage generateResponse(Operation op, boolean useSOAP12, Object result) throws SOAPException {
        MessageFactory messageFactory = null;
        messageFactory = useSOAP12 ? MessageFactory.newInstance((String)"SOAP 1.2 Protocol") : MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage();
        message.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        message.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        SOAPBody body = message.getSOAPPart().getEnvelope().getBody();
        XMLDescriptor descriptor = this.resultDescriptors.get(op.getName());
        SOAPResponse response = null;
        try {
            Class cls = descriptor.getJavaClass();
            response = (SOAPResponse)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ie) {
            throw new SOAPException((Throwable)ie);
        }
        response.setResult(result);
        SOAPAttachmentHandler attachmentHandler = new SOAPAttachmentHandler();
        XMLMarshaller marshaller = this.dbwsAdapter.getXMLContext().createMarshaller();
        marshaller.setAttachmentMarshaller(attachmentHandler);
        marshaller.marshal((Object)response, (Node)body);
        if (attachmentHandler.hasAttachments()) {
            for (String id : attachmentHandler.getAttachments().keySet()) {
                DataHandler attachment = attachmentHandler.getAttachments().get(id);
                AttachmentPart part = message.createAttachmentPart(attachment);
                part.setContentType(attachment.getContentType());
                String contentId = "<" + id.substring(4) + ">";
                part.setContentId(contentId);
                part.setMimeHeader("Content-Transfer-Encoding", "binary");
                message.addAttachmentPart(part);
            }
        }
        message.saveChanges();
        return message;
    }
}

