/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LogFacade;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.glassfish.main.jdke.props.SystemProperties;

public final class Tool {
    private static boolean ant = false;
    private static String catalinaHome = System.getProperty("catalina.home");
    private static boolean common = false;
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static boolean server = false;
    private static boolean shared = false;

    public static void main(String[] args) {
        if (catalinaHome == null) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00470");
            System.exit(1);
        }
        int index = 0;
        while (true) {
            if (index == args.length) {
                Tool.usage();
                System.exit(1);
            }
            if ("-ant".equals(args[index])) {
                ant = true;
            } else if ("-common".equals(args[index])) {
                common = true;
            } else if ("-server".equals(args[index])) {
                server = true;
            } else {
                if (!"-shared".equals(args[index])) break;
                shared = true;
            }
            ++index;
        }
        if (index > args.length) {
            Tool.usage();
            System.exit(1);
        }
        if (ant) {
            SystemProperties.setProperty("ant.home", catalinaHome, true);
        }
        ClassLoader classLoader = null;
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Constructing class loader");
                ClassLoaderFactory.setDebug(1);
            }
            ArrayList<File> packed = new ArrayList<File>();
            ArrayList<File> unpacked = new ArrayList<File>();
            unpacked.add(new File(catalinaHome, "classes"));
            packed.add(new File(catalinaHome, "lib"));
            if (common) {
                unpacked.add(new File(catalinaHome, "common" + File.separator + "classes"));
                packed.add(new File(catalinaHome, "common" + File.separator + "lib"));
            }
            if (server) {
                unpacked.add(new File(catalinaHome, "server" + File.separator + "classes"));
                packed.add(new File(catalinaHome, "server" + File.separator + "lib"));
            }
            if (shared) {
                unpacked.add(new File(catalinaHome, "shared" + File.separator + "classes"));
                packed.add(new File(catalinaHome, "shared" + File.separator + "lib"));
            }
            classLoader = ClassLoaderFactory.createClassLoader(unpacked.toArray(new File[unpacked.size()]), packed.toArray(new File[packed.size()]), null);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00398", t);
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        Class<?> clazz = null;
        String className = args[index++];
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Loading application class " + className);
            }
            clazz = classLoader.loadClass(className);
        }
        catch (Throwable t) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00472"), className);
            log.log(Level.SEVERE, msg, t);
            System.exit(1);
        }
        Method method = null;
        String[] params = new String[args.length - index];
        System.arraycopy(args, index, params, 0, params.length);
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Identifying main() method");
            }
            String methodName = "main";
            Class[] paramTypes = new Class[]{params.getClass()};
            method = clazz.getMethod(methodName, paramTypes);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00473", t);
            System.exit(1);
        }
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Calling main() method");
            }
            Object[] paramValues = new Object[]{params};
            method.invoke(null, paramValues);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00474", t);
            System.exit(1);
        }
    }

    private static void usage() {
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "AS-WEB-CORE-00475");
        }
    }
}

