/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIMediator;
import org.glassfish.web.util.HtmlEntityEncoder;

public final class SSIInclude
implements SSICommand {
    @Override
    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) {
        long lastModified = 0L;
        String configErrMsg = null;
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            String substitutedValue = ssiMediator.substituteVariables(paramValue);
            try {
                if (paramName.equalsIgnoreCase("file") || paramName.equalsIgnoreCase("virtual")) {
                    boolean virtual = paramName.equalsIgnoreCase("virtual");
                    lastModified = ssiMediator.getFileLastModified(substitutedValue, virtual);
                    String text = ssiMediator.getFileText(substitutedValue, virtual);
                    writer.write(text);
                    continue;
                }
                ssiMediator.log("#include--Invalid attribute: " + paramName);
                if (configErrMsg == null) {
                    configErrMsg = this.getEncodedConfigErrorMessage(ssiMediator);
                }
                writer.write(configErrMsg);
                continue;
            }
            catch (IOException e) {
                ssiMediator.log("#include--Couldn't include file: " + substitutedValue, e);
                if (configErrMsg == null) {
                    configErrMsg = this.getEncodedConfigErrorMessage(ssiMediator);
                }
                writer.write(configErrMsg);
            }
        }
        return lastModified;
    }

    private String getEncodedConfigErrorMessage(SSIMediator ssiMediator) {
        String errorMessage = ssiMediator.getConfigErrMsg();
        return HtmlEntityEncoder.encodeXSS(errorMessage);
    }
}

