/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.logging.LogCleanerUtil;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Pipeline;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.web.valve.GlassFishValve;

public class StandardHost
extends ContainerBase
implements Deployer,
Host {
    protected String[] aliases = new String[0];
    private String appBase = ".";
    private boolean autoDeploy = true;
    private NotificationBroadcasterSupport broadcaster = null;
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private String defaultContextXmlLocation;
    private String defaultWebXmlLocation;
    private Deployer deployer = null;
    private boolean deployOnStartup = true;
    private boolean deployXML = true;
    private String errorReportValveClass = "org.apache.catalina.valves.ErrorReportValve";
    private static final String info = "org.apache.catalina.core.StandardHost/1.0";
    private boolean unpackWARs = true;
    private String workDir = null;
    private boolean xmlValidation = false;
    private boolean xmlNamespaceAware = false;
    private HashMap<Integer, ErrorPage> statusPages = new HashMap();
    private String[] networkListenerNames = new String[0];
    private boolean securePagesWithPragma = true;
    private SingleSignOn sso;
    private long sequenceNumber = 0L;
    static String STANDARD_HOST_DEPLOYER = "org.apache.catalina.core.StandardHostDeployer";

    public StandardHost() {
        this.pipeline.setBasic(new StandardHostValve());
    }

    public void setPipeline(Pipeline pl) {
        StandardHostValve shValve = new StandardHostValve();
        this.configureStandardHostValve(shValve);
        pl.setBasic(shValve);
        this.pipeline = pl;
        this.hasCustomPipeline = true;
    }

    @Override
    public String getAppBase() {
        return this.appBase;
    }

    @Override
    public void setAppBase(String appBase) {
        String oldAppBase = this.appBase;
        this.appBase = appBase;
        this.support.firePropertyChange("appBase", oldAppBase, this.appBase);
    }

    @Override
    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    @Override
    public void setAutoDeploy(boolean autoDeploy) {
        boolean oldAutoDeploy = this.autoDeploy;
        this.autoDeploy = autoDeploy;
        this.support.firePropertyChange("autoDeploy", oldAutoDeploy, this.autoDeploy);
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        String oldConfigClass = this.configClass;
        this.configClass = configClass;
        this.support.firePropertyChange("configClass", oldConfigClass, this.configClass);
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        String oldContextClass = this.contextClass;
        this.contextClass = contextClass;
        this.support.firePropertyChange("contextClass", oldContextClass, this.contextClass);
    }

    @Override
    public boolean getDeployOnStartup() {
        return this.deployOnStartup;
    }

    @Override
    public void setDeployOnStartup(boolean deployOnStartup) {
        boolean oldDeployOnStartup = this.deployOnStartup;
        this.deployOnStartup = deployOnStartup;
        this.support.firePropertyChange("deployOnStartup", oldDeployOnStartup, this.deployOnStartup);
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public String getErrorReportValveClass() {
        return this.errorReportValveClass;
    }

    public void setErrorReportValveClass(String errorReportValveClass) {
        String oldErrorReportValveClassClass = this.errorReportValveClass;
        this.errorReportValveClass = errorReportValveClass;
        this.support.firePropertyChange("errorReportValveClass", oldErrorReportValveClassClass, this.errorReportValveClass);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00198"));
        }
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    @Override
    public void setXmlValidation(boolean xmlValidation) {
        this.xmlValidation = xmlValidation;
    }

    @Override
    public boolean getXmlValidation() {
        return this.xmlValidation;
    }

    @Override
    public boolean getXmlNamespaceAware() {
        return this.xmlNamespaceAware;
    }

    @Override
    public void setXmlNamespaceAware(boolean xmlNamespaceAware) {
        this.xmlNamespaceAware = xmlNamespaceAware;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    @Override
    public void setNetworkListenerNames(String[] networkListenerNames) {
        String[] oldListenerNames = this.networkListenerNames;
        this.networkListenerNames = (String[])networkListenerNames.clone();
        this.support.firePropertyChange("ports", oldListenerNames, this.networkListenerNames);
    }

    @Override
    public String[] getNetworkListenerNames() {
        return (String[])this.networkListenerNames.clone();
    }

    public String getNetworkListeners() {
        List<String> list = Arrays.asList(this.networkListenerNames);
        Object listeners = null;
        if (list.size() > 0) {
            listeners = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                listeners = list.get(i) + "," + (String)listeners;
            }
        }
        return listeners;
    }

    public String getDefaultContextXmlLocation() {
        return this.defaultContextXmlLocation;
    }

    public void setDefaultContextXmlLocation(String defaultContextXmlLocation) {
        this.defaultContextXmlLocation = defaultContextXmlLocation;
    }

    public String getDefaultWebXmlLocation() {
        return this.defaultWebXmlLocation;
    }

    public void setDefaultWebXmlLocation(String defaultWebXmlLocation) {
        this.defaultWebXmlLocation = defaultWebXmlLocation;
    }

    @Override
    public void addAlias(String alias) {
        for (String name : this.aliases) {
            if (!name.equals(alias)) continue;
            return;
        }
        String[] newAliases = new String[this.aliases.length + 1];
        for (int i = 0; i < this.aliases.length; ++i) {
            newAliases[i] = this.aliases[i];
        }
        newAliases[this.aliases.length] = alias;
        this.aliases = newAliases;
        this.fireContainerEvent("addAlias", alias);
    }

    @Override
    public void addChild(Container child) {
        if (!(child instanceof Context)) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00199"));
        }
        super.addChild(child);
    }

    @Override
    public Container findChild(String contextRoot) {
        return super.findChild(RequestUtil.urlDecode(contextRoot, "UTF-8"));
    }

    @Override
    public String[] findAliases() {
        return this.aliases;
    }

    public Host findMappingObject() {
        return (Host)this.getMappingObject();
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public Context map(String uri) {
        int slash;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Mapping request URI '" + LogCleanerUtil.neutralizeForLog(uri) + "'");
        }
        if (uri == null) {
            return null;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Trying the longest context path prefix");
        }
        Context context = null;
        String mapuri = uri;
        while ((context = (Context)this.findChild(mapuri)) == null && (slash = mapuri.lastIndexOf(47)) >= 0) {
            mapuri = mapuri.substring(0, slash);
        }
        if (context == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Trying the default context");
            }
            context = (Context)this.findChild("");
        }
        if (context == null) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00200", uri);
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " Mapped to context '" + LogCleanerUtil.neutralizeForLog(context.getPath()) + "'");
        }
        return context;
    }

    @Override
    public void removeAlias(String alias) {
        int n = -1;
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!this.aliases[i].equals(alias)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        String[] results = new String[this.aliases.length - 1];
        for (int i = 0; i < this.aliases.length; ++i) {
            if (i == n) continue;
            results[j++] = this.aliases[i];
        }
        this.aliases = results;
        this.fireContainerEvent("removeAlias", alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorPage(ErrorPage errorPage) {
        if (errorPage == null) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00201"));
        }
        HashMap<Integer, ErrorPage> hashMap = this.statusPages;
        synchronized (hashMap) {
            this.statusPages.put(errorPage.getErrorCode(), errorPage);
        }
        this.fireContainerEvent("addErrorPage", errorPage);
    }

    public ErrorPage findErrorPage(int errorCode) {
        return this.statusPages.get(errorCode);
    }

    public void configureSingleSignOnCookieSecure(Cookie cookie, HttpServletRequest hreq) {
        cookie.setSecure(hreq.isSecure());
    }

    public void configureSingleSignOnCookieHttpOnly(Cookie cookie) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardHost[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        this.configureStandardHostValve((StandardHostValve)this.pipeline.getBasic());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "AS-WEB-CORE-00202");
        }
        super.start();
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        super.stop();
        if (this.oname != null) {
            Notification notification = new Notification("j2ee.object.deleted", this, this.sequenceNumber++);
            this.sendNotification(notification);
        }
    }

    public void sendNotification(Notification notification) {
        if (this.broadcaster == null) {
            this.broadcaster = ((StandardEngine)this.getParent()).getService().getBroadcaster();
        }
        if (this.broadcaster != null) {
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    public void install(String contextPath, URL war) throws IOException {
        this.getDeployer().install(contextPath, war);
    }

    @Override
    public synchronized void install(URL config, URL war) throws IOException {
        this.getDeployer().install(config, war);
    }

    @Override
    public Context findDeployedApp(String contextPath) {
        return this.getDeployer().findDeployedApp(contextPath);
    }

    @Override
    public String[] findDeployedApps() {
        return this.getDeployer().findDeployedApps();
    }

    @Override
    public void remove(String contextPath) throws IOException {
        this.getDeployer().remove(contextPath);
    }

    @Override
    public void remove(String contextPath, boolean undeploy) throws IOException {
        this.getDeployer().remove(contextPath, undeploy);
    }

    @Override
    public void start(String contextPath) throws IOException {
        this.getDeployer().start(contextPath);
    }

    @Override
    public void stop(String contextPath) throws IOException {
        this.getDeployer().stop(contextPath);
    }

    public boolean isSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        boolean oldSecurePagesWithPragma = this.securePagesWithPragma;
        this.securePagesWithPragma = securePagesWithPragma;
        this.support.firePropertyChange("securePagesWithPragma", (Object)oldSecurePagesWithPragma, (Object)this.securePagesWithPragma);
    }

    @Override
    public void addValve(GlassFishValve valve) {
        super.addValve(valve);
        if (valve instanceof SingleSignOn) {
            this.sso = (SingleSignOn)valve;
        }
    }

    @Override
    public void removeValve(GlassFishValve valve) {
        super.removeValve(valve);
        if (valve instanceof SingleSignOn) {
            this.sso = null;
        }
    }

    public SingleSignOn getSingleSignOn() {
        return this.sso;
    }

    public Deployer getDeployer() {
        if (this.deployer != null) {
            return this.deployer;
        }
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "AS-WEB-CORE-00203");
        }
        try {
            Class<?> c = Class.forName(STANDARD_HOST_DEPLOYER);
            this.deployer = (Deployer)c.newInstance();
            Method m = c.getMethod("setHost", Host.class);
            m.invoke((Object)this.deployer, this);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00204", t);
        }
        return this.deployer;
    }

    public void setDeployer(Deployer d) {
        this.deployer = d;
    }

    public String[] getValveNames() throws Exception {
        GlassFishValve[] valves = this.getValves();
        String[] mbeanNames = new String[valves.length];
        for (int i = 0; i < valves.length; ++i) {
            if (valves[i] == null || ((ValveBase)valves[i]).getObjectName() == null) continue;
            mbeanNames[i] = ((ValveBase)valves[i]).getObjectName().toString();
        }
        return mbeanNames;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        if (this.oname == null) {
            try {
                StandardEngine engine = (StandardEngine)this.parent;
                this.domain = engine.getName();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, LogCleanerUtil.neutralizeForLog("Registering host " + this.getName() + " with domain " + this.domain));
                }
                this.controller = this.oname = new ObjectName(this.domain + ":type=Host,host=" + this.getName());
                Notification notification = new Notification("j2ee.object.created", this, this.sequenceNumber++);
                this.sendNotification(notification);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00205"), this.getName());
                log.log(Level.SEVERE, msg, t);
            }
        }
        this.initialized = true;
    }

    @Override
    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogCleanerUtil.neutralizeForLog("Create ObjectName " + domain + " " + String.valueOf(parent)));
        }
        return new ObjectName(domain + ":type=Host,host=" + this.getName());
    }

    protected Object loadInstance(String className) throws Exception {
        return Class.forName(className).newInstance();
    }

    private void configureStandardHostValve(StandardHostValve host) {
        if (this.errorReportValveClass != null && !"".equals(this.errorReportValveClass)) {
            try {
                GlassFishValve valve = (GlassFishValve)this.loadInstance(this.errorReportValveClass);
                host.setErrorReportValve(valve);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00206"), this.errorReportValveClass);
                log.log(Level.SEVERE, msg, t);
            }
        }
    }
}

