/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.logging.LogCleanerUtil;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardEngineValve;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.realm.JAASRealm;

public class StandardEngine
extends ContainerBase
implements Engine {
    private String defaultHost = null;
    private static final String info = "org.apache.catalina.core.StandardEngine/1.0";
    private Service service = null;
    private String baseDir = null;
    private String jvmRouteId;

    public StandardEngine() {
        this.pipeline.setBasic(new StandardEngineValve());
        try {
            this.setJvmRoute(System.getProperty("jvmRoute"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.backgroundProcessorDelay = 10;
    }

    @Override
    public Realm getRealm() {
        Realm configured = super.getRealm();
        if (configured == null) {
            configured = new JAASRealm();
            this.setRealm(configured);
        }
        return configured;
    }

    @Override
    public String getDefaultHost() {
        return this.defaultHost;
    }

    @Override
    public void setDefaultHost(String host) {
        String oldDefaultHost = this.defaultHost;
        this.defaultHost = host == null ? null : host;
        this.support.firePropertyChange("defaultHost", oldDefaultHost, this.defaultHost);
    }

    @Override
    public void setName(String name) {
        if (this.domain != null) {
            super.setName(this.domain);
            return;
        }
        this.domain = name;
        super.setName(name);
    }

    @Override
    public void setJvmRoute(String routeId) {
        this.jvmRouteId = routeId;
    }

    @Override
    public String getJvmRoute() {
        return this.jvmRouteId;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public String getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.base");
        }
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.home");
        }
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void addChild(Container child) {
        if (!(child instanceof Host)) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00194"));
        }
        super.addChild(child);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setParent(Container container) {
        throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00195"));
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        if (this.oname == null) {
            try {
                if (this.domain == null) {
                    this.domain = this.getName();
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Register " + LogCleanerUtil.neutralizeForLog(this.domain));
                }
                this.controller = this.oname = new ObjectName(this.domain + ":type=Engine");
            }
            catch (Throwable t) {
                log.log(Level.INFO, "AS-WEB-CORE-00196", t);
            }
        }
        if (this.service == null) {
            try {
                this.service = new StandardService();
                this.service.setContainer(this);
                this.service.initialize();
                this.service.setName(this.getName());
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, t.toString());
            }
        }
        this.initialized = true;
    }

    @Override
    public void destroy() throws Exception {
        if (!this.initialized) {
            return;
        }
        super.destroy();
        ((StandardService)this.service).destroy();
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Starting Servlet Engine");
        }
        super.start();
    }

    @Override
    public void stop() throws LifecycleException {
        super.stop();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardEngine[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public ObjectName getParentName() throws MalformedObjectNameException {
        if (this.getService() == null) {
            return null;
        }
        String name = this.getService().getName();
        ObjectName serviceName = new ObjectName(this.domain + ":type=Service,serviceName=" + name);
        return serviceName;
    }

    @Override
    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Create ObjectName " + domain + " " + String.valueOf(parent));
        }
        return new ObjectName(domain + ":type=Engine");
    }

    @Override
    public String getDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        return this.getName();
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }
}

