/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.util;

import jakarta.activation.DataSource;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import jakarta.mail.util.SharedByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private int len = -1;
    private String type;
    private String name = "";

    public ByteArrayDataSource(InputStream is, String type2) throws IOException {
        int len;
        DSByteArrayOutputStream os = new DSByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((len = is.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        this.data = os.getBuf();
        this.len = os.getCount();
        if (this.data.length - this.len > 262144) {
            this.data = os.toByteArray();
            this.len = this.data.length;
        }
        this.type = type2;
    }

    public ByteArrayDataSource(byte[] data, String type2) {
        this.data = data;
        this.type = type2;
    }

    public ByteArrayDataSource(String data, String type2) throws IOException {
        String charset = null;
        try {
            ContentType ct = new ContentType(type2);
            charset = ct.getParameter("charset");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        charset = MimeUtility.javaCharset(charset);
        if (charset == null) {
            charset = MimeUtility.getDefaultJavaCharset();
        }
        this.data = data.getBytes(charset);
        this.type = type2;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        if (this.len < 0) {
            this.len = this.data.length;
        }
        return new SharedByteArrayInputStream(this.data, 0, this.len);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static class DSByteArrayOutputStream
    extends ByteArrayOutputStream {
        DSByteArrayOutputStream() {
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

