/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELManager;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ELProcessor {
    private ELManager elManager = new ELManager();
    private ExpressionFactory factory = ELManager.getExpressionFactory();

    public ELManager getELManager() {
        return this.elManager;
    }

    public <T> T eval(String expression) {
        Object result = this.getValue(expression, Object.class);
        return (T)result;
    }

    public <T> T getValue(String expression, Class<T> expectedType) {
        ValueExpression exp = this.factory.createValueExpression(this.elManager.getELContext(), this.bracket(expression), expectedType);
        return exp.getValue(this.elManager.getELContext());
    }

    public void setValue(String expression, Object value) {
        ValueExpression exp = this.factory.createValueExpression(this.elManager.getELContext(), this.bracket(expression), Object.class);
        exp.setValue(this.elManager.getELContext(), value);
    }

    public void setVariable(String var, String expression) {
        ValueExpression exp = this.factory.createValueExpression(this.elManager.getELContext(), this.bracket(expression), Object.class);
        this.elManager.setVariable(var, exp);
    }

    public void defineFunction(String prefix, String function, String className, String method) throws ClassNotFoundException, NoSuchMethodException {
        if (prefix == null || function == null || className == null || method == null) {
            throw new NullPointerException("Null argument for defineFunction");
        }
        Method meth = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        Class<?> klass = Class.forName(className, false, loader);
        int j = method.indexOf(40);
        if (j < 0) {
            for (Method m : klass.getDeclaredMethods()) {
                if (!m.getName().equals(method)) continue;
                meth = m;
            }
            if (meth == null) {
                throw new NoSuchMethodException("Bad method name: " + method);
            }
        } else {
            int p = method.indexOf(32);
            if (p < 0) {
                throw new NoSuchMethodException("Bad method signature: " + method);
            }
            String methodName = method.substring(p + 1, j).trim();
            p = method.indexOf(41, j + 1);
            if (p < 0) {
                throw new NoSuchMethodException("Bad method signature: " + method);
            }
            String[] params = method.substring(j + 1, p).split(",");
            Class[] paramTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramTypes[i] = ELProcessor.toClass(params[i], loader);
            }
            meth = klass.getDeclaredMethod(methodName, paramTypes);
        }
        if (!Modifier.isStatic(meth.getModifiers())) {
            throw new NoSuchMethodException("The method specified in defineFunction must be static: " + meth);
        }
        if (function.equals("")) {
            function = method;
        }
        this.elManager.mapFunction(prefix, function, meth);
    }

    public void defineFunction(String prefix, String function, Method method) throws NoSuchMethodException {
        if (prefix == null || function == null || method == null) {
            throw new NullPointerException("Null argument for defineFunction");
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("The method specified in defineFunction must be static: " + method);
        }
        if (function.equals("")) {
            function = method.getName();
        }
        this.elManager.mapFunction(prefix, function, method);
    }

    public void defineBean(String name, Object bean) {
        this.elManager.defineBean(name, bean);
    }

    private static Class<?> toClass(String type2, ClassLoader loader) throws ClassNotFoundException {
        Class<Serializable> c = null;
        int i0 = type2.indexOf(91);
        int dims = 0;
        if (i0 > 0) {
            for (int i = 0; i < type2.length(); ++i) {
                if (type2.charAt(i) != '[') continue;
                ++dims;
            }
            type2 = type2.substring(0, i0);
        }
        c = "boolean".equals(type2) ? Boolean.TYPE : ("char".equals(type2) ? Character.TYPE : ("byte".equals(type2) ? Byte.TYPE : ("short".equals(type2) ? Short.TYPE : ("int".equals(type2) ? Integer.TYPE : ("long".equals(type2) ? Long.TYPE : ("float".equals(type2) ? Float.TYPE : ("double".equals(type2) ? Double.TYPE : loader.loadClass(type2))))))));
        if (dims == 0) {
            return c;
        }
        if (dims == 1) {
            return Array.newInstance(c, 1).getClass();
        }
        return Array.newInstance(c, new int[dims]).getClass();
    }

    private String bracket(String expression) {
        return "${" + expression + "}";
    }
}

