/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.ActivationPhase;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceRegistryConfigBlueprint;
import io.helidon.service.registry.ServiceRegistryConfigSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.service.registry.ServiceRegistryConfigBlueprint")
public interface ServiceRegistryConfig
extends ServiceRegistryConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceRegistryConfig instance) {
        return (Builder)ServiceRegistryConfig.builder().from(instance);
    }

    public static ServiceRegistryConfig create() {
        return ServiceRegistryConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ServiceRegistryConfig>
    implements io.helidon.common.Builder<Builder, ServiceRegistryConfig> {
        private Builder() {
        }

        @Override
        public ServiceRegistryConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ServiceRegistryConfigImpl(this);
        }

        @Override
        public ServiceRegistryConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ServiceRegistryConfig>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<ServiceDescriptor<?>> serviceDescriptors = new ArrayList();
        private final List<Double> runLevels = new ArrayList<Double>();
        private final Map<ServiceDescriptor<?>, Object> serviceInstances = new LinkedHashMap();
        private ActivationPhase limitActivationPhase = ActivationPhase.ACTIVE;
        private boolean allowLateBinding = true;
        private boolean discoverServices = true;
        private boolean discoverServicesFromServiceLoader = true;
        private boolean interceptionEnabled = true;
        private boolean isRunLevelsMutated;
        private boolean isServiceDescriptorsMutated;
        private boolean lookupCacheEnabled;
        private boolean useBinding = true;
        private double maxRunLevel = Double.MAX_VALUE;
        private int lookupCacheSize = 10000;

        protected BuilderBase() {
        }

        public BUILDER from(ServiceRegistryConfig prototype) {
            this.discoverServices(prototype.discoverServices());
            this.discoverServicesFromServiceLoader(prototype.discoverServicesFromServiceLoader());
            this.allowLateBinding(prototype.allowLateBinding());
            if (!this.isServiceDescriptorsMutated) {
                this.serviceDescriptors.clear();
            }
            this.addServiceDescriptors(prototype.serviceDescriptors());
            this.addServiceInstances(prototype.serviceInstances());
            this.lookupCacheEnabled(prototype.lookupCacheEnabled());
            this.lookupCacheSize(prototype.lookupCacheSize());
            this.interceptionEnabled(prototype.interceptionEnabled());
            this.limitActivationPhase(prototype.limitActivationPhase());
            this.useBinding(prototype.useBinding());
            this.maxRunLevel(prototype.maxRunLevel());
            if (!this.isRunLevelsMutated) {
                this.runLevels.clear();
            }
            this.addRunLevels(prototype.runLevels());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.discoverServices(builder.discoverServices());
            this.discoverServicesFromServiceLoader(builder.discoverServicesFromServiceLoader());
            this.allowLateBinding(builder.allowLateBinding());
            if (this.isServiceDescriptorsMutated) {
                if (builder.isServiceDescriptorsMutated) {
                    this.addServiceDescriptors(builder.serviceDescriptors);
                }
            } else {
                this.serviceDescriptors.clear();
                this.addServiceDescriptors(builder.serviceDescriptors);
            }
            this.addServiceInstances(builder.serviceInstances);
            this.lookupCacheEnabled(builder.lookupCacheEnabled());
            this.lookupCacheSize(builder.lookupCacheSize());
            this.interceptionEnabled(builder.interceptionEnabled());
            this.limitActivationPhase(builder.limitActivationPhase());
            this.useBinding(builder.useBinding());
            this.maxRunLevel(builder.maxRunLevel());
            if (this.isRunLevelsMutated) {
                if (builder.isRunLevelsMutated) {
                    this.addRunLevels(builder.runLevels);
                }
            } else {
                this.runLevels.clear();
                this.addRunLevels(builder.runLevels);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putContractInstance(TypeName contract, Object instance) {
            ServiceRegistryConfigSupport.CustomMethods.putContractInstance(this, contract, instance);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putContractInstance(Class<?> contract, Object instance) {
            ServiceRegistryConfigSupport.CustomMethods.putContractInstance(this, contract, instance);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER discoverServices(boolean discoverServices) {
            this.discoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER discoverServicesFromServiceLoader(boolean discoverServicesFromServiceLoader) {
            this.discoverServicesFromServiceLoader = discoverServicesFromServiceLoader;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER allowLateBinding(boolean allowLateBinding) {
            this.allowLateBinding = allowLateBinding;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceDescriptors(List<ServiceDescriptor<?>> serviceDescriptors) {
            Objects.requireNonNull(serviceDescriptors);
            this.isServiceDescriptorsMutated = true;
            this.serviceDescriptors.clear();
            this.serviceDescriptors.addAll(serviceDescriptors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addServiceDescriptors(List<ServiceDescriptor<?>> serviceDescriptors) {
            Objects.requireNonNull(serviceDescriptors);
            this.isServiceDescriptorsMutated = true;
            this.serviceDescriptors.addAll(serviceDescriptors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addServiceDescriptor(ServiceDescriptor<?> serviceDescriptor) {
            Objects.requireNonNull(serviceDescriptor);
            this.serviceDescriptors.add(serviceDescriptor);
            this.isServiceDescriptorsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceInstances(Map<ServiceDescriptor<?>, ?> serviceInstances) {
            Objects.requireNonNull(serviceInstances);
            this.serviceInstances.clear();
            this.serviceInstances.putAll(serviceInstances);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addServiceInstances(Map<ServiceDescriptor<?>, ?> serviceInstances) {
            Objects.requireNonNull(serviceInstances);
            this.serviceInstances.putAll(serviceInstances);
            return (BUILDER)((BuilderBase)this.self());
        }

        public <TYPE> BUILDER putServiceInstance(ServiceDescriptor<TYPE> key, TYPE serviceInstance) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(serviceInstance);
            this.serviceInstances.put(key, serviceInstance);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER lookupCacheEnabled(boolean lookupCacheEnabled) {
            this.lookupCacheEnabled = lookupCacheEnabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER lookupCacheSize(int lookupCacheSize) {
            this.lookupCacheSize = lookupCacheSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER interceptionEnabled(boolean interceptionEnabled) {
            this.interceptionEnabled = interceptionEnabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER limitActivationPhase(ActivationPhase limitActivationPhase) {
            Objects.requireNonNull(limitActivationPhase);
            this.limitActivationPhase = limitActivationPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER useBinding(boolean useBinding) {
            this.useBinding = useBinding;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxRunLevel(double maxRunLevel) {
            this.maxRunLevel = maxRunLevel;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER runLevels(List<Double> runLevels) {
            Objects.requireNonNull(runLevels);
            this.isRunLevelsMutated = true;
            this.runLevels.clear();
            this.runLevels.addAll(runLevels);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRunLevels(List<Double> runLevels) {
            Objects.requireNonNull(runLevels);
            this.isRunLevelsMutated = true;
            this.runLevels.addAll(runLevels);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRunLevel(Double runLevel) {
            Objects.requireNonNull(runLevel);
            this.runLevels.add(runLevel);
            this.isRunLevelsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean discoverServices() {
            return this.discoverServices;
        }

        public boolean discoverServicesFromServiceLoader() {
            return this.discoverServicesFromServiceLoader;
        }

        public boolean allowLateBinding() {
            return this.allowLateBinding;
        }

        public List<ServiceDescriptor<?>> serviceDescriptors() {
            return this.serviceDescriptors;
        }

        public Map<ServiceDescriptor<?>, Object> serviceInstances() {
            return this.serviceInstances;
        }

        public boolean lookupCacheEnabled() {
            return this.lookupCacheEnabled;
        }

        public int lookupCacheSize() {
            return this.lookupCacheSize;
        }

        public boolean interceptionEnabled() {
            return this.interceptionEnabled;
        }

        public ActivationPhase limitActivationPhase() {
            return this.limitActivationPhase;
        }

        public boolean useBinding() {
            return this.useBinding;
        }

        public double maxRunLevel() {
            return this.maxRunLevel;
        }

        public List<Double> runLevels() {
            return this.runLevels;
        }

        public String toString() {
            return "ServiceRegistryConfigBuilder{discoverServices=" + this.discoverServices + ",discoverServicesFromServiceLoader=" + this.discoverServicesFromServiceLoader + ",allowLateBinding=" + this.allowLateBinding + ",serviceDescriptors=" + String.valueOf(this.serviceDescriptors) + ",serviceInstances=" + String.valueOf(this.serviceInstances) + ",lookupCacheEnabled=" + this.lookupCacheEnabled + ",lookupCacheSize=" + this.lookupCacheSize + ",interceptionEnabled=" + this.interceptionEnabled + ",limitActivationPhase=" + String.valueOf((Object)this.limitActivationPhase) + ",useBinding=" + this.useBinding + ",maxRunLevel=" + this.maxRunLevel + ",runLevels=" + String.valueOf(this.runLevels) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class ServiceRegistryConfigImpl
        implements ServiceRegistryConfig {
            private final ActivationPhase limitActivationPhase;
            private final boolean allowLateBinding;
            private final boolean discoverServices;
            private final boolean discoverServicesFromServiceLoader;
            private final boolean interceptionEnabled;
            private final boolean lookupCacheEnabled;
            private final boolean useBinding;
            private final double maxRunLevel;
            private final int lookupCacheSize;
            private final List<ServiceDescriptor<?>> serviceDescriptors;
            private final List<Double> runLevels;
            private final Map<ServiceDescriptor<?>, Object> serviceInstances;

            protected ServiceRegistryConfigImpl(BuilderBase<?, ?> builder) {
                this.discoverServices = builder.discoverServices();
                this.discoverServicesFromServiceLoader = builder.discoverServicesFromServiceLoader();
                this.allowLateBinding = builder.allowLateBinding();
                this.serviceDescriptors = List.copyOf(builder.serviceDescriptors());
                this.serviceInstances = Collections.unmodifiableMap(new LinkedHashMap(builder.serviceInstances()));
                this.lookupCacheEnabled = builder.lookupCacheEnabled();
                this.lookupCacheSize = builder.lookupCacheSize();
                this.interceptionEnabled = builder.interceptionEnabled();
                this.limitActivationPhase = builder.limitActivationPhase();
                this.useBinding = builder.useBinding();
                this.maxRunLevel = builder.maxRunLevel();
                this.runLevels = List.copyOf(builder.runLevels());
            }

            @Override
            public boolean discoverServices() {
                return this.discoverServices;
            }

            @Override
            public boolean discoverServicesFromServiceLoader() {
                return this.discoverServicesFromServiceLoader;
            }

            @Override
            public boolean allowLateBinding() {
                return this.allowLateBinding;
            }

            @Override
            public List<ServiceDescriptor<?>> serviceDescriptors() {
                return this.serviceDescriptors;
            }

            @Override
            public Map<ServiceDescriptor<?>, Object> serviceInstances() {
                return this.serviceInstances;
            }

            @Override
            public boolean lookupCacheEnabled() {
                return this.lookupCacheEnabled;
            }

            @Override
            public int lookupCacheSize() {
                return this.lookupCacheSize;
            }

            @Override
            public boolean interceptionEnabled() {
                return this.interceptionEnabled;
            }

            @Override
            public ActivationPhase limitActivationPhase() {
                return this.limitActivationPhase;
            }

            @Override
            public boolean useBinding() {
                return this.useBinding;
            }

            @Override
            public double maxRunLevel() {
                return this.maxRunLevel;
            }

            @Override
            public List<Double> runLevels() {
                return this.runLevels;
            }

            public String toString() {
                return "ServiceRegistryConfig{discoverServices=" + this.discoverServices + ",discoverServicesFromServiceLoader=" + this.discoverServicesFromServiceLoader + ",allowLateBinding=" + this.allowLateBinding + ",serviceDescriptors=" + String.valueOf(this.serviceDescriptors) + ",serviceInstances=" + String.valueOf(this.serviceInstances) + ",lookupCacheEnabled=" + this.lookupCacheEnabled + ",lookupCacheSize=" + this.lookupCacheSize + ",interceptionEnabled=" + this.interceptionEnabled + ",limitActivationPhase=" + String.valueOf((Object)this.limitActivationPhase) + ",useBinding=" + this.useBinding + ",maxRunLevel=" + this.maxRunLevel + ",runLevels=" + String.valueOf(this.runLevels) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceRegistryConfig)) {
                    return false;
                }
                ServiceRegistryConfig other = (ServiceRegistryConfig)o;
                return this.discoverServices == other.discoverServices() && this.discoverServicesFromServiceLoader == other.discoverServicesFromServiceLoader() && this.allowLateBinding == other.allowLateBinding() && Objects.equals(this.serviceDescriptors, other.serviceDescriptors()) && Objects.equals(this.serviceInstances, other.serviceInstances()) && this.lookupCacheEnabled == other.lookupCacheEnabled() && this.lookupCacheSize == other.lookupCacheSize() && this.interceptionEnabled == other.interceptionEnabled() && Objects.equals((Object)this.limitActivationPhase, (Object)other.limitActivationPhase()) && this.useBinding == other.useBinding() && this.maxRunLevel == other.maxRunLevel() && Objects.equals(this.runLevels, other.runLevels());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.discoverServices, this.discoverServicesFromServiceLoader, this.allowLateBinding, this.serviceDescriptors, this.serviceInstances, this.lookupCacheEnabled, this.lookupCacheSize, this.interceptionEnabled, this.limitActivationPhase, this.useBinding, this.maxRunLevel, this.runLevels});
            }
        }
    }
}

