/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.ResolvedType;
import io.helidon.service.registry.ActivationRequest;
import io.helidon.service.registry.Contracts;
import io.helidon.service.registry.CoreServiceRegistry;
import io.helidon.service.registry.InterceptionMetadata;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.ServiceDescriptor;
import java.util.Objects;
import java.util.Set;

class ServiceProvider<T> {
    private final ServiceDescriptor<T> descriptor;
    private final ActivationRequest activationRequest;
    private final InterceptionMetadata interceptionMetadata;
    private final Contracts.ContractLookup contracts;

    ServiceProvider(CoreServiceRegistry serviceRegistry, ServiceDescriptor<T> descriptor) {
        Objects.requireNonNull(serviceRegistry);
        Objects.requireNonNull(descriptor);
        this.interceptionMetadata = serviceRegistry.interceptionMetadata();
        this.activationRequest = serviceRegistry.activationRequest();
        this.descriptor = descriptor;
        this.contracts = Contracts.create(descriptor);
    }

    public String toString() {
        return "ServiceProvider for " + this.descriptor.serviceType().fqName();
    }

    ServiceDescriptor<T> descriptor() {
        return this.descriptor;
    }

    InterceptionMetadata interceptionMetadata() {
        return this.interceptionMetadata;
    }

    Set<ResolvedType> contracts(Lookup lookup) {
        return this.contracts.contracts(lookup);
    }

    ActivationRequest activationRequest() {
        return this.activationRequest;
    }
}

