/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.LazyValue;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.DependencyContext;
import io.helidon.service.registry.InterceptionMetadata;
import io.helidon.service.registry.ServiceDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public abstract class ServiceLoader__ServiceDescriptor
implements ServiceDescriptor<Object> {
    private static final TypeName DESCRIPTOR_TYPE = TypeName.create(ServiceLoader__ServiceDescriptor.class);
    private static final Map<ProviderKey, ServiceLoader__ServiceDescriptor> INSTANCE_CACHE = new HashMap<ProviderKey, ServiceLoader__ServiceDescriptor>();
    private static final ReentrantLock LOCK = new ReentrantLock();

    private ServiceLoader__ServiceDescriptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceDescriptor<Object> create(TypeName providerInterface, ServiceLoader.Provider<Object> provider, double weight) {
        LOCK.lock();
        try {
            TypeName providerImpl = TypeName.create(provider.type());
            ProviderKey key = new ProviderKey(providerInterface, providerImpl);
            ServiceLoader__ServiceDescriptor descriptor = INSTANCE_CACHE.get(key);
            if (descriptor == null) {
                descriptor = new ServiceProviderDescriptor(providerInterface, providerImpl, provider, weight);
                INSTANCE_CACHE.put(key, descriptor);
            }
            ServiceLoader__ServiceDescriptor serviceLoader__ServiceDescriptor = descriptor;
            return serviceLoader__ServiceDescriptor;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static <T> ServiceDescriptor<Object> create(TypeName providerInterface, Class<T> implType, Supplier<T> instanceSupplier, double weight) {
        return ServiceLoader__ServiceDescriptor.create(providerInterface, new ProviderImpl(implType, instanceSupplier), weight);
    }

    @Override
    public TypeName descriptorType() {
        return DESCRIPTOR_TYPE;
    }

    public abstract TypeName providerInterface();

    private record ProviderKey(TypeName providerInterface, TypeName providerImpl) {
    }

    private static class ServiceProviderDescriptor
    extends ServiceLoader__ServiceDescriptor {
        private final TypeName providerInterface;
        private final Set<ResolvedType> contracts;
        private final TypeName providerImpl;
        private final double weight;
        private final LazyValue<Object> instance;

        private ServiceProviderDescriptor(TypeName providerInterface, TypeName providerImpl, ServiceLoader.Provider<Object> provider, double weight) {
            this.providerInterface = providerInterface;
            this.contracts = Set.of(ResolvedType.create(providerInterface));
            this.providerImpl = providerImpl;
            this.weight = weight;
            this.instance = LazyValue.create(provider);
        }

        public String toString() {
            return String.valueOf(this.providerInterface) + "/" + String.valueOf(this.providerImpl) + "(" + this.weight + ")";
        }

        @Override
        public TypeName serviceType() {
            return this.providerImpl;
        }

        @Override
        public Set<ResolvedType> contracts() {
            return this.contracts;
        }

        @Override
        public Object instantiate(DependencyContext ctx, InterceptionMetadata metadata) {
            return this.instance.get();
        }

        @Override
        public double weight() {
            return this.weight;
        }

        @Override
        public TypeName providerInterface() {
            return this.providerInterface;
        }
    }

    private static class ProviderImpl
    implements ServiceLoader.Provider<Object> {
        private final Class<?> implType;
        private final Supplier<?> instanceSupplier;

        private ProviderImpl(Class<?> implType, Supplier<?> instanceSupplier) {
            this.implType = implType;
            this.instanceSupplier = instanceSupplier;
        }

        @Override
        public Class<?> type() {
            return this.implType;
        }

        @Override
        public Object get() {
            return this.instanceSupplier.get();
        }
    }
}

