/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.builder.api.Prototype;
import io.helidon.common.GenericType;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Dependency;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import java.util.Optional;
import java.util.Set;

final class LookupSupport {
    private LookupSupport() {
    }

    static class GenericTypeDecorator
    implements Prototype.OptionDecorator<Lookup.BuilderBase<?, ?>, Optional<GenericType<?>>> {
        GenericTypeDecorator() {
        }

        @Override
        public void decorate(Lookup.BuilderBase<?, ?> builder, Optional<GenericType<?>> optionValue) {
            if (optionValue.isEmpty()) {
                return;
            }
            builder.addContract(ResolvedType.create(optionValue.get()));
        }
    }

    static final class DependencyDecorator
    implements Prototype.OptionDecorator<Lookup.BuilderBase<?, ?>, Optional<Dependency>> {
        DependencyDecorator() {
        }

        @Override
        public void decorate(Lookup.BuilderBase<?, ?> builder, Optional<Dependency> dependency) {
            if (dependency.isPresent()) {
                Dependency value = dependency.get();
                builder.qualifiers(value.qualifiers());
                if (!GenericType.OBJECT.equals(value.contractType())) {
                    ((Lookup.BuilderBase)builder.contractType(value.contractType())).addContract(ResolvedType.create(value.contract()));
                }
            } else {
                builder.dependency().ifPresent(existing -> {
                    boolean shouldClear = builder.qualifiers().equals(existing.qualifiers());
                    if (!builder.contracts().contains(ResolvedType.create(existing.contract())) || builder.contracts().size() != 1) {
                        shouldClear = false;
                    }
                    if (shouldClear) {
                        builder.qualifiers(Set.of());
                        builder.contracts(Set.of());
                        builder.clearContractType();
                    }
                });
            }
        }
    }

    static final class CustomMethods {
        @Prototype.Constant
        static final Lookup EMPTY = CustomMethods.createEmpty();

        private CustomMethods() {
        }

        @Prototype.FactoryMethod
        static Lookup create(Dependency dependency) {
            return ((Lookup.Builder)Lookup.builder().dependency(dependency)).build();
        }

        @Prototype.FactoryMethod
        static Lookup create(Class<?> contract) {
            return ((Lookup.Builder)Lookup.builder().addContract(contract)).build();
        }

        @Prototype.FactoryMethod
        static Lookup create(TypeName contract) {
            return ((Lookup.Builder)Lookup.builder().addContract(ResolvedType.create(contract))).build();
        }

        @Prototype.BuilderMethod
        static void addContract(Lookup.BuilderBase<?, ?> builder, Class<?> contract) {
            builder.addContract(ResolvedType.create(contract));
        }

        @Prototype.BuilderMethod
        static void addContract(Lookup.BuilderBase<?, ?> builder, TypeName contract) {
            builder.addContract(ResolvedType.create(contract));
        }

        @Prototype.BuilderMethod
        static void serviceType(Lookup.BuilderBase<?, ?> builder, Class<?> contract) {
            builder.serviceType(TypeName.create(contract));
        }

        @Prototype.BuilderMethod
        static void named(Lookup.BuilderBase<?, ?> builder, String name) {
            builder.addQualifier(Qualifier.createNamed(name));
        }

        @Prototype.BuilderMethod
        static void named(Lookup.BuilderBase<?, ?> builder, Class<?> clazz) {
            builder.addQualifier(Qualifier.createNamed(clazz));
        }

        private static Lookup createEmpty() {
            return Lookup.builder().build();
        }
    }
}

