/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.GenericType;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Dependency;
import io.helidon.service.registry.FactoryType;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.LookupSupport;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Qualifiers;
import io.helidon.service.registry.ServiceInfo;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Prototype.Blueprint(createEmptyPublic=false)
@Prototype.CustomMethods(value=LookupSupport.CustomMethods.class)
interface LookupBlueprint {
    public Optional<TypeName> serviceType();

    @Option.Singular
    public Set<TypeName> scopes();

    @Option.Singular
    public Set<Qualifier> qualifiers();

    @Option.Singular
    public Set<ResolvedType> contracts();

    @Option.Decorator(value=LookupSupport.GenericTypeDecorator.class)
    public Optional<GenericType<?>> contractType();

    public Optional<Double> runLevel();

    public Optional<Double> weight();

    @Option.DefaultBoolean(value={false})
    public boolean includeAbstract();

    @Option.Decorator(value=LookupSupport.DependencyDecorator.class)
    public Optional<Dependency> dependency();

    @Option.Singular
    public Set<FactoryType> factoryTypes();

    default public boolean matches(Lookup criteria) {
        return this.matchesContracts(criteria) && this.matchesAbstract(this.includeAbstract(), criteria.includeAbstract()) && this.matchesTypes(this.scopes(), criteria.scopes()) && Qualifiers.matchesQualifiers(this.qualifiers(), criteria.qualifiers()) && this.matchesOptionals(this.runLevel(), criteria.runLevel());
    }

    default public boolean matches(ServiceInfo serviceInfo) {
        if (this == LookupSupport.CustomMethods.EMPTY) {
            return !serviceInfo.isAbstract();
        }
        boolean matches = LookupBlueprint.matches(serviceInfo.serviceType(), this.serviceType());
        if (matches && this.serviceType().isEmpty()) {
            matches = serviceInfo.contracts().containsAll(this.contracts()) || this.contracts().contains(ResolvedType.create(serviceInfo.serviceType())) || serviceInfo.factoryContracts().containsAll(this.contracts());
        }
        boolean bl = matches = matches && this.matchesProviderTypes(this.factoryTypes(), serviceInfo.factoryType()) && this.matchesAbstract(this.includeAbstract(), serviceInfo.isAbstract()) && (this.scopes().isEmpty() || this.scopes().contains(serviceInfo.scope())) && LookupBlueprint.matchesWeight(serviceInfo, this) && this.matchesOptionals(serviceInfo.runLevel(), this.runLevel());
        if (serviceInfo.factoryType() == FactoryType.SERVICES) {
            return matches;
        }
        return matches && Qualifiers.matchesQualifiers(serviceInfo.qualifiers(), this.qualifiers());
    }

    default public boolean matchesContracts(Lookup criteria) {
        if (criteria == LookupSupport.CustomMethods.EMPTY) {
            return true;
        }
        boolean matches = this.matchesOptionals(this.serviceType(), criteria.serviceType());
        if (matches && criteria.serviceType().isEmpty()) {
            matches = this.contracts().containsAll(criteria.contracts());
        }
        return matches;
    }

    default public boolean matchesQualifiers(Set<Qualifier> qualifiers) {
        return Qualifiers.matchesQualifiers(qualifiers, this.qualifiers());
    }

    private static boolean matchesWeight(ServiceInfo src, LookupBlueprint criteria) {
        if (criteria.weight().isEmpty()) {
            return true;
        }
        Double srcWeight = src.weight();
        return srcWeight.compareTo(criteria.weight().get()) <= 0;
    }

    private static boolean matches(Object src, Optional<?> criteria) {
        if (criteria.isEmpty()) {
            return true;
        }
        return Objects.equals(src, criteria.get());
    }

    private boolean matchesProviderTypes(Set<FactoryType> providerTypes, FactoryType providerType) {
        if (providerTypes.isEmpty() || providerTypes.size() == 1 && providerTypes.contains((Object)FactoryType.NONE)) {
            return true;
        }
        return providerTypes.contains((Object)providerType);
    }

    private boolean matchesTypes(Set<TypeName> scopes, Set<TypeName> criteria) {
        if (criteria.isEmpty()) {
            return true;
        }
        for (TypeName scope : scopes) {
            if (!criteria.contains(scope)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesOptionals(Optional<?> src, Optional<?> criteria) {
        if (criteria.isEmpty()) {
            return true;
        }
        return src.map(it -> Objects.equals(it, criteria.get())).orElse(false);
    }

    private boolean matchesAbstract(boolean criteriaAbstract, boolean isAbstract) {
        if (criteriaAbstract) {
            return true;
        }
        return !isAbstract;
    }
}

