/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.GenericType;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Dependency;
import io.helidon.service.registry.DependencyBlueprint;
import io.helidon.service.registry.EventManager;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class GeneratedService {
    private GeneratedService() {
    }

    public static abstract class QualifiedFactoryInterceptionWrapper<T, A extends Annotation>
    extends InterceptionWrapper<T>
    implements Service.QualifiedFactory<T, A> {
        private final Service.QualifiedFactory<T, A> delegate;

        protected QualifiedFactoryInterceptionWrapper(Service.QualifiedFactory<T, A> delegate) {
            this.delegate = delegate;
        }

        @Override
        public List<Service.QualifiedInstance<T>> list(Qualifier qualifier, Lookup lookup, GenericType<T> type2) {
            return this.delegate.list(qualifier, lookup, type2).stream().map(this::wrapQualifiedInstance).collect(Collectors.toUnmodifiableList());
        }

        @Override
        public Optional<Service.QualifiedInstance<T>> first(Qualifier qualifier, Lookup lookup, GenericType<T> type2) {
            return this.delegate.first(qualifier, lookup, type2).map(this::wrapQualifiedInstance);
        }
    }

    public static abstract class IpFactoryInterceptionWrapper<T>
    extends InterceptionWrapper<T>
    implements Service.InjectionPointFactory<T> {
        private final Service.InjectionPointFactory<T> delegate;

        protected IpFactoryInterceptionWrapper(Service.InjectionPointFactory<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public List<Service.QualifiedInstance<T>> list(Lookup lookup) {
            return this.delegate.first(lookup).stream().map(this::wrapQualifiedInstance).collect(Collectors.toUnmodifiableList());
        }

        @Override
        public Optional<Service.QualifiedInstance<T>> first(Lookup lookup) {
            return this.delegate.first(lookup).map(this::wrapQualifiedInstance);
        }
    }

    public static abstract class ServicesFactoryInterceptionWrapper<T>
    extends InterceptionWrapper<T>
    implements Service.ServicesFactory<T> {
        private final Service.ServicesFactory<T> delegate;

        protected ServicesFactoryInterceptionWrapper(Service.ServicesFactory<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public List<Service.QualifiedInstance<T>> services() {
            return this.delegate.services().stream().map(this::wrapQualifiedInstance).collect(Collectors.toUnmodifiableList());
        }
    }

    public static abstract class SupplierFactoryInterceptionWrapper<T>
    extends InterceptionWrapper<T>
    implements Supplier<T> {
        private final Supplier<T> delegate;

        protected SupplierFactoryInterceptionWrapper(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T get() {
            return this.wrap(this.delegate.get());
        }
    }

    static abstract class InterceptionWrapper<T> {
        InterceptionWrapper() {
        }

        protected Service.QualifiedInstance<T> wrapQualifiedInstance(Service.QualifiedInstance<T> qualifiedInstance) {
            return Service.QualifiedInstance.create(this.wrap(qualifiedInstance.get()), qualifiedInstance.qualifiers());
        }

        protected abstract T wrap(T var1);
    }

    public static final class DependencySupport {
        private DependencySupport() {
        }

        public static List<Dependency> combineDependencies(List<Dependency> myType, List<Dependency> superType) {
            ArrayList<Dependency> result = new ArrayList<Dependency>(myType);
            result.addAll(superType.stream().filter(it -> it.elementKind() == ElementKind.FIELD).toList());
            Set injectedMethods = myType.stream().filter(it -> it.elementKind() == ElementKind.METHOD).map(DependencyBlueprint::method).flatMap(Optional::stream).collect(Collectors.toSet());
            result.addAll(superType.stream().filter(it -> it.elementKind() == ElementKind.METHOD).filter(it -> it.method().isPresent()).filter(it -> injectedMethods.add(it.method().get())).toList());
            return List.copyOf(result);
        }
    }

    @Service.Contract
    public static interface EventObserverRegistration {
        public void register(EventManager var1);
    }

    public static interface ScopeHandlerDescriptor {
        public TypeName handledScope();
    }

    public static interface PerInstanceDescriptor {
        public TypeName createFor();
    }

    public static interface QualifiedFactoryDescriptor {
        public TypeName qualifierType();
    }
}

