/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.DependencyContext;
import io.helidon.service.registry.InterceptionMetadata;
import io.helidon.service.registry.ServiceDescriptor;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class ExistingInstanceDescriptor<T>
implements ServiceDescriptor<T> {
    private static final TypeName DESCRIPTOR_TYPE = TypeName.create(ExistingInstanceDescriptor.class);
    private final T instance;
    private final TypeName serviceType;
    private final Set<ResolvedType> contracts;
    private final double weight;

    private ExistingInstanceDescriptor(T instance, TypeName serviceType, Set<ResolvedType> contracts, double weight) {
        this.instance = instance;
        this.serviceType = serviceType;
        this.contracts = contracts;
        this.weight = weight;
    }

    public static <T> ExistingInstanceDescriptor<T> create(T instance, Collection<Class<? super T>> contracts, double weight) {
        TypeName serviceType = TypeName.create(instance.getClass());
        Set<ResolvedType> contractSet = contracts.stream().map(ResolvedType::create).collect(Collectors.toSet());
        return new ExistingInstanceDescriptor<T>(instance, serviceType, contractSet, weight);
    }

    @Override
    public TypeName serviceType() {
        return this.serviceType;
    }

    @Override
    public TypeName descriptorType() {
        return DESCRIPTOR_TYPE;
    }

    @Override
    public Set<ResolvedType> contracts() {
        return this.contracts;
    }

    @Override
    public Object instantiate(DependencyContext ctx, InterceptionMetadata metadata) {
        return this.instance;
    }

    @Override
    public double weight() {
        return this.weight;
    }

    public String toString() {
        return String.valueOf(this.contracts) + " (" + this.weight + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExistingInstanceDescriptor)) {
            return false;
        }
        ExistingInstanceDescriptor that = (ExistingInstanceDescriptor)o;
        return Double.compare(this.weight, that.weight) == 0 && this.instance == that.instance && Objects.equals(this.contracts, that.contracts);
    }

    public int hashCode() {
        return Objects.hash(this.instance, this.contracts, this.weight);
    }
}

