/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.LazyValue;
import io.helidon.common.Weights;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.metadata.hson.Hson;
import io.helidon.service.metadata.DescriptorMetadata;
import io.helidon.service.metadata.Descriptors;
import io.helidon.service.registry.DescriptorHandler;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceDiscovery;
import io.helidon.service.registry.ServiceLoader__ServiceDescriptor;
import io.helidon.service.registry.ServiceRegistryConfig;
import io.helidon.service.registry.ServiceRegistryException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

class CoreServiceDiscovery
implements ServiceDiscovery {
    private static final System.Logger LOGGER = System.getLogger(CoreServiceDiscovery.class.getName());
    private final List<DescriptorHandler> allDescriptors;

    private CoreServiceDiscovery(ServiceRegistryConfig config) {
        LinkedHashMap allDescriptors = new LinkedHashMap();
        ClassLoader classLoader = CoreServiceDiscovery.classLoader();
        if (config.discoverServices()) {
            classLoader.resources("META-INF/helidon/service-registry.json").forEach(url -> this.loadServices((URL)url).map(DescriptorHandlerImpl::new).forEach(it -> allDescriptors.putIfAbsent(it.descriptorType(), it)));
        }
        ArrayList result = new ArrayList(allDescriptors.values());
        if (config.discoverServicesFromServiceLoader()) {
            classLoader.resources("META-INF/helidon/service.loader").flatMap(CoreServiceDiscovery::loadLines).filter(Predicate.not(Line::isEmpty)).filter(Predicate.not(Line::isComment)).flatMap(DescriptorHandlerImpl::parseServiceProvider).forEach(result::add);
        }
        this.allDescriptors = List.copyOf(result);
    }

    static ServiceDiscovery create(ServiceRegistryConfig config) {
        return new CoreServiceDiscovery(config);
    }

    static ServiceDiscovery noop() {
        return NoopServiceDiscovery.INSTANCE;
    }

    @Override
    public List<DescriptorHandler> allMetadata() {
        return this.allDescriptors;
    }

    private static <T> Class<T> toClass(TypeName className) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            cl = cl == null ? CoreServiceDiscovery.class.getClassLoader() : cl;
            return cl.loadClass(className.fqName());
        }
        catch (ClassNotFoundException e) {
            try {
                return CoreServiceDiscovery.class.getClassLoader().loadClass(className.fqName());
            }
            catch (ClassNotFoundException ex) {
                ServiceRegistryException toThrow = new ServiceRegistryException("Resolution of type \"" + className.fqName() + "\" to class failed.", ex);
                toThrow.addSuppressed(e);
                throw toThrow;
            }
        }
    }

    private static ServiceDescriptor<?> getDescriptorInstance(TypeName descriptorType) {
        Class clazz = CoreServiceDiscovery.toClass(descriptorType);
        try {
            Field field = clazz.getField("INSTANCE");
            Object descriptorInstance = field.get(null);
            if (descriptorInstance instanceof ServiceDescriptor) {
                ServiceDescriptor sd = (ServiceDescriptor)descriptorInstance;
                return sd;
            }
            return (ServiceDescriptor)field.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new ServiceRegistryException("Could not obtain the instance of service descriptor " + descriptorType.fqName(), e);
        }
    }

    private static ClassLoader classLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return CoreServiceDiscovery.class.getClassLoader();
        }
        return cl;
    }

    private static Stream<Line> loadLines(URL url) {
        Stream<Line> stream;
        BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        try {
            String line;
            ArrayList<Line> lines = new ArrayList<Line>();
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                lines.add(new Line(url.toString(), line, ++lineNumber));
            }
            stream = lines.stream();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.log(System.Logger.Level.WARNING, "Failed to read services from " + String.valueOf(url), (Throwable)e);
                return Stream.of(new Line[0]);
            }
        }
        br.close();
        return stream;
    }

    private static DescriptorHandlerImpl createServiceProviderDescriptor(TypeName providerType, ServiceLoader.Provider<Object> provider) {
        Class<Object> serviceClass = provider.type();
        double weight = Weights.find(serviceClass, 100.0);
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Discovered service provider for type %s: %s, weight: %s".formatted(providerType.fqName(), serviceClass.getName(), weight));
        }
        ServiceDescriptor<Object> descriptor = ServiceLoader__ServiceDescriptor.create(providerType, provider, weight);
        return new DescriptorHandlerImpl(DescriptorMetadata.create(descriptor.descriptorType(), weight, descriptor.contracts(), descriptor.factoryContracts()), LazyValue.create(descriptor));
    }

    private Stream<DescriptorMetadata> loadServices(URL url) {
        Hson.Array array;
        try (InputStream stream = url.openStream();){
            array = Hson.parse(stream).asArray();
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.WARNING, "Failed to read services from " + String.valueOf(url), (Throwable)e);
            return Stream.of(new DescriptorMetadata[0]);
        }
        return Descriptors.descriptors("classpath descriptor " + String.valueOf(url), array).stream();
    }

    static class NoopServiceDiscovery
    implements ServiceDiscovery {
        private static final ServiceDiscovery INSTANCE = new NoopServiceDiscovery();

        NoopServiceDiscovery() {
        }

        @Override
        public List<DescriptorHandler> allMetadata() {
            return List.of();
        }
    }

    private record Line(String source, String line, int lineNumber) {
        boolean isEmpty() {
            return this.line.isEmpty();
        }

        boolean isComment() {
            return this.line.startsWith("#");
        }
    }

    private record DescriptorHandlerImpl(DescriptorMetadata metadata, LazyValue<ServiceDescriptor<?>> descriptorSupplier) implements DescriptorHandler
    {
        DescriptorHandlerImpl(DescriptorMetadata metadata) {
            this(metadata, LazyValue.create(() -> CoreServiceDiscovery.getDescriptorInstance(metadata.descriptorType())));
        }

        @Override
        public ServiceDescriptor<?> descriptor() {
            return (ServiceDescriptor)this.descriptorSupplier.get();
        }

        @Override
        public TypeName descriptorType() {
            return this.metadata.descriptorType();
        }

        @Override
        public Set<ResolvedType> contracts() {
            return this.metadata.contracts();
        }

        @Override
        public Set<ResolvedType> factoryContracts() {
            return this.metadata.factoryContracts();
        }

        @Override
        public double weight() {
            return this.metadata.weight();
        }

        @Override
        public Hson.Struct toHson() {
            return this.metadata.toHson();
        }

        private static Stream<DescriptorHandlerImpl> parseServiceProvider(Line line) {
            TypeName providerType = TypeName.create(line.line.trim());
            Class providerClass = CoreServiceDiscovery.toClass(providerType);
            CoreServiceDiscovery.class.getModule().addUses(providerClass);
            ServiceLoader serviceLoader = ServiceLoader.load(providerClass);
            return serviceLoader.stream().map(it -> CoreServiceDiscovery.createServiceProviderDescriptor(providerType, it));
        }
    }
}

